/*
 * Decompiled with CFR 0.152.
 */
package com.Rolfmao.upgradednetherite.config;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="upgradednetherite", bus=Mod.EventBusSubscriber.Bus.MOD)
public class UpgradedNetheriteConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ArmorOptions ARMOR_OPTIONS = new ArmorOptions(BUILDER);
    public static ForgeConfigSpec spec = BUILDER.build();

    public static class Helper {
        private static final FileConfig CONFIG_FILE = FileConfig.of((File)new File(FMLPaths.CONFIGDIR.get().toFile(), "upgradednetherite-common.toml"));

        public static <T> T get(String category, String subCategory, String value) {
            return Helper.get(category + "." + subCategory, value);
        }

        public static <T> T get(String category, String value) {
            CONFIG_FILE.load();
            return (T)CONFIG_FILE.get(category + "." + value);
        }

        public static String getSubConfig(String category, String subCategory) {
            return category + "." + subCategory;
        }
    }

    public static class ArmorOptions {
        public ForgeConfigSpec.BooleanValue DisableTooltips;
        public ForgeConfigSpec.BooleanValue UpgradedPlayerArmorRequireSet;
        public ForgeConfigSpec.BooleanValue EnableFireImmune;
        public ForgeConfigSpec.BooleanValue EnableBreakEnderArmor;
        public ForgeConfigSpec.BooleanValue EnableDamageDurabilityFireArmor;
        public ForgeConfigSpec.IntValue DelayDamageDurabilityFireArmor;
        public ForgeConfigSpec.IntValue DamageDurabilityFireArmor;
        public ForgeConfigSpec.BooleanValue EnableDamageDurabilityWaterArmor;
        public ForgeConfigSpec.IntValue DelayDamageDurabilityWaterArmor;
        public ForgeConfigSpec.IntValue DamageDurabilityWaterArmor;
        public ForgeConfigSpec.BooleanValue EnableDamageDurabilityWitherArmor;
        public ForgeConfigSpec.IntValue DelayDamageDurabilityWitherArmor;
        public ForgeConfigSpec.IntValue DamageDurabilityWitherArmor;
        public ForgeConfigSpec.BooleanValue EnableDamageDurabilityPoisonArmor;
        public ForgeConfigSpec.IntValue DelayDamageDurabilityPoisonArmor;
        public ForgeConfigSpec.IntValue DamageDurabilityPoisonArmor;
        public ForgeConfigSpec.BooleanValue EnableDamageDurabilityPhantomArmor;
        public ForgeConfigSpec.IntValue MultiplierDamageDurabilityPhantomArmor;
        public ForgeConfigSpec.BooleanValue EnableWaterDamageDurabilityFeatherArmor;
        public ForgeConfigSpec.BooleanValue EnableLavaDamageDurabilityFeatherArmor;
        public ForgeConfigSpec.BooleanValue EnableFallDamageDurabilityFeatherArmor;
        public ForgeConfigSpec.IntValue DelayDamageDurabilityFeatherArmor;
        public ForgeConfigSpec.IntValue DamageDurabilityFeatherArmor;

        ArmorOptions(ForgeConfigSpec.Builder builder) {
            builder.push("General Options");
            this.DisableTooltips = builder.comment("Disable Tooltips ?(Client Only)").define("DisableTooltips", false);
            builder.pop();
            builder.push("Armor Options");
            this.UpgradedPlayerArmorRequireSet = builder.comment("Upgraded Player Armor effect require to wear full set ?").define("UpgradedPlayerArmorRequireSet", true);
            builder.pop();
            builder.push("Fire Armor Effect Options");
            this.EnableFireImmune = builder.comment("Enable Fire Upgraded Armor Effect : Fire damage immune. ?").define("EnableFireImmune", true);
            this.EnableDamageDurabilityFireArmor = builder.comment("Fire Upgraded Armor loose durability when protect the player ? (Require EnableFireImmune = True)").define("EnableDamageDurabilityFireArmor", false);
            this.DelayDamageDurabilityFireArmor = builder.comment("How many tick between durability damage for the Fire Upgraded Armor when it protect the player ? (20ticks = 1sec)").defineInRange("DelayDamageDurabilityFireArmor", 20, 1, 1000);
            this.DamageDurabilityFireArmor = builder.comment("How many durability damage take the Fire Upgraded Armor when protect the player ? ").defineInRange("DamageDurabilityFireArmor", 1, 1, 100);
            builder.pop();
            builder.push("Ender Armor Effect Options");
            this.EnableBreakEnderArmor = builder.comment("Ender Upgraded Armor Break when save the player ? ").define("EnableBreakEnderArmor", false);
            builder.pop();
            builder.push("Water Armor Effect Options");
            this.EnableDamageDurabilityWaterArmor = builder.comment("Water Upgraded Armor loose durability when protect the player ? ").define("EnableDamageDurabilityWaterArmor", false);
            this.DelayDamageDurabilityWaterArmor = builder.comment("How many tick between durability damage for the Water Upgraded Armor when it protect the player ? (20ticks = 1sec)").defineInRange("DelayDamageDurabilityWaterArmor", 20, 1, 1000);
            this.DamageDurabilityWaterArmor = builder.comment("How many durability damage take the Water Upgraded Armor when protect the player ? ").defineInRange("DamageDurabilityWaterArmor", 1, 1, 100);
            builder.pop();
            builder.push("Wither Armor Effect Options");
            this.EnableDamageDurabilityWitherArmor = builder.comment("Wither Upgraded Armor loose durability when protect the player ? ").define("EnableDamageDurabilityWitherArmor", false);
            this.DelayDamageDurabilityWitherArmor = builder.comment("How many tick between durability damage for the Wither Upgraded Armor when it protect the player ? (20ticks = 1sec)").defineInRange("DelayDamageDurabilityWitherArmor", 20, 1, 1000);
            this.DamageDurabilityWitherArmor = builder.comment("How many durability damage take the Wither Upgraded Armor when protect the player ? ").defineInRange("DamageDurabilityWitherArmor", 5, 1, 100);
            builder.pop();
            builder.push("Poison Armor Effect Options");
            this.EnableDamageDurabilityPoisonArmor = builder.comment("Poison Upgraded Armor loose durability when protect the player ? ").define("EnableDamageDurabilityPoisonArmor", false);
            this.DelayDamageDurabilityPoisonArmor = builder.comment("How many tick between durability damage for the Poison Upgraded Armor when it protect the player ? (20ticks = 1sec)").defineInRange("DelayDamageDurabilityPoisonArmor", 20, 1, 1000);
            this.DamageDurabilityPoisonArmor = builder.comment("How many durability damage take the Poison Upgraded Armor when protect the player ? ").defineInRange("DamageDurabilityPoisonArmor", 5, 1, 100);
            builder.pop();
            builder.push("Phantom Armor Effect Options");
            this.EnableDamageDurabilityPhantomArmor = builder.comment("Phantom Upgraded Armor loose durability when protect the player ? (Depend on fall distance)").define("EnableDamageDurabilityPhantomArmor", false);
            this.MultiplierDamageDurabilityPhantomArmor = builder.comment("How many durability damage take the Phantom Upgraded Armor when protect the player ? (Fall distance * Value)").defineInRange("MultiplierDamageDurabilityPhantomArmor", 1, 1, 100);
            builder.pop();
            builder.push("Feather Armor Effect Options");
            this.EnableWaterDamageDurabilityFeatherArmor = builder.comment("Feather Upgraded Armor loose durability when the player walk on water ? ").define("EnableWaterDamageDurabilityFeatherArmor", false);
            this.EnableLavaDamageDurabilityFeatherArmor = builder.comment("Feather Upgraded Armor loose durability when the player walk on lava ? ").define("EnableLavaDamageDurabilityFeatherArmor", false);
            this.EnableFallDamageDurabilityFeatherArmor = builder.comment("Feather Upgraded Armor loose durability when the player slow falling ? ").define("EnableFallDamageDurabilityFeatherArmor", false);
            this.DelayDamageDurabilityFeatherArmor = builder.comment("How many tick between durability damage for the Feather Upgraded Armor when the player walk on water/lava or slow falling ? (20ticks = 1sec)").defineInRange("DelayDamageDurabilityFeatherArmor", 20, 1, 1000);
            this.DamageDurabilityFeatherArmor = builder.comment("How many durability damage take the Feather Upgraded Armor when the player walk on water/lava or slow falling ? ").defineInRange("DamageDurabilityFeatherArmor", 1, 1, 100);
            builder.pop();
        }
    }
}

