/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.buddiesforbaby.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.buddiesforbaby.world.features.BananaTree1Feature;
import net.mcreator.buddiesforbaby.world.features.BananaTree2Feature;
import net.mcreator.buddiesforbaby.world.features.BananaTree3Feature;
import net.mcreator.buddiesforbaby.world.features.BananaTree4Feature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class BuddiesForBabyModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"buddies_for_baby");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> BANANA_TREE_1 = BuddiesForBabyModFeatures.register("banana_tree_1", BananaTree1Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, BananaTree1Feature.GENERATE_BIOMES, BananaTree1Feature::placedFeature));
    public static final RegistryObject<Feature<?>> BANANA_TREE_2 = BuddiesForBabyModFeatures.register("banana_tree_2", BananaTree2Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, BananaTree2Feature.GENERATE_BIOMES, BananaTree2Feature::placedFeature));
    public static final RegistryObject<Feature<?>> BANANA_TREE_3 = BuddiesForBabyModFeatures.register("banana_tree_3", BananaTree3Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, BananaTree3Feature.GENERATE_BIOMES, BananaTree3Feature::placedFeature));
    public static final RegistryObject<Feature<?>> BANANA_TREE_4 = BuddiesForBabyModFeatures.register("banana_tree_4", BananaTree4Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, BananaTree4Feature.GENERATE_BIOMES, BananaTree4Feature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

