/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.client.WandToast;
import net.nicguzzo.wands.client.render.ClientRender;
import net.nicguzzo.wands.client.screens.MagicBagScreen;
import net.nicguzzo.wands.client.screens.PaletteScreen;
import net.nicguzzo.wands.client.screens.WandScreen;
import net.nicguzzo.wands.items.WandItem;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandProps;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WandsModClient {
    static boolean shift = false;
    static boolean alt = false;
    public static boolean has_optifine = false;
    public static KeyMapping wand_menu_km;
    public static final Logger LOGGER;
    public static final Map keys;
    public static final int wand_menu_key = 89;
    public static final int wand_mode_key = 86;
    public static final int wand_action_key = 72;
    public static final int wand_orientation_key = 88;
    public static final int wand_undo_key = 85;
    public static final int wand_invert_key = 73;
    public static final int wand_fill_circle_key = 75;
    public static final int wand_rotate = 82;
    public static final int palette_mode_key = 80;
    public static final int palette_menu_key = 74;
    public static final int wand_conf_key = -1;
    public static final int wand_m_inc_key = 262;
    public static final int wand_m_dec_key = 263;
    public static final int wand_n_inc_key = 265;
    public static final int wand_n_dec_key = 264;
    public static final int toggle_stair_slab_key = 46;
    public static final int area_diagonal_spread = 44;
    public static final int inc_sel_block = 90;

    public static void initialize() {
        String k = "key.wands.";
        String tab = "key.categories.wands";
        wand_menu_km = new KeyMapping(k + "wand_menu", 89, "key.categories.wands");
        keys.put(wand_menu_km, WandsMod.WandKeys.MENU);
        keys.put(new KeyMapping(k + "wand_mode", 86, "key.categories.wands"), WandsMod.WandKeys.MODE);
        keys.put(new KeyMapping(k + "palette_menu", 74, "key.categories.wands"), WandsMod.WandKeys.PALETTE_MENU);
        keys.put(new KeyMapping(k + "wand_action", 72, "key.categories.wands"), WandsMod.WandKeys.ACTION);
        keys.put(new KeyMapping(k + "wand_orientation", 88, "key.categories.wands"), WandsMod.WandKeys.ORIENTATION);
        keys.put(new KeyMapping(k + "wand_invert", 73, "key.categories.wands"), WandsMod.WandKeys.INVERT);
        keys.put(new KeyMapping(k + "wand_fill_circle", 75, "key.categories.wands"), WandsMod.WandKeys.FILL);
        keys.put(new KeyMapping(k + "wand_undo", 85, "key.categories.wands"), WandsMod.WandKeys.UNDO);
        keys.put(new KeyMapping(k + "wand_palette_mode", 80, "key.categories.wands"), WandsMod.WandKeys.PALETTE_MODE);
        keys.put(new KeyMapping(k + "wand_rotate", 82, "key.categories.wands"), WandsMod.WandKeys.ROTATE);
        keys.put(new KeyMapping(k + "m_inc", 262, "key.categories.wands"), WandsMod.WandKeys.M_INC);
        keys.put(new KeyMapping(k + "m_dec", 263, "key.categories.wands"), WandsMod.WandKeys.M_DEC);
        keys.put(new KeyMapping(k + "n_inc", 265, "key.categories.wands"), WandsMod.WandKeys.N_INC);
        keys.put(new KeyMapping(k + "n_dec", 264, "key.categories.wands"), WandsMod.WandKeys.N_DEC);
        keys.put(new KeyMapping(k + "toggle_stair_slab", 46, "key.categories.wands"), WandsMod.WandKeys.TOGGLE_STAIRSLAB);
        keys.put(new KeyMapping(k + "area_diagonal_spread", 44, "key.categories.wands"), WandsMod.WandKeys.DIAGONAL_SPREAD);
        keys.put(new KeyMapping(k + "inc_sel_block", 90, "key.categories.wands"), WandsMod.WandKeys.INC_SEL_BLK);
        keys.forEach((km, v) -> Compat.register_key((KeyMapping)km));
        ClientTickEvent.CLIENT_PRE.register(e -> {
            boolean any = false;
            for (Map.Entry me : keys.entrySet()) {
                KeyMapping km = (KeyMapping)me.getKey();
                if (!km.m_90859_()) continue;
                if (!any) {
                    any = true;
                }
                WandsModClient.send_key(((WandsMod.WandKeys)((Object)((Object)me.getValue()))).ordinal(), Screen.m_96638_(), Screen.m_96639_());
            }
            if (!(any || alt == Screen.m_96639_() && shift == Screen.m_96638_())) {
                alt = Screen.m_96639_();
                shift = Screen.m_96638_();
                ClientRender.wand.is_alt_pressed = alt;
                ClientRender.wand.is_shift_pressed = shift;
                WandsModClient.send_key(-1, shift, alt);
            }
        });
        Compat.render_info();
        if (WandsMod.is_forge) {
            ClientLifecycleEvent.CLIENT_SETUP.register(e -> {
                WandsMod.LOGGER.info("registering menues...");
                try {
                    MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.PALETTE_CONTAINER.get()), PaletteScreen::new);
                    MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.WAND_CONTAINER.get()), WandScreen::new);
                    MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.MAGIC_WAND_CONTANIER.get()), MagicBagScreen::new);
                }
                catch (Exception ex) {
                    WandsMod.LOGGER.error(ex.getMessage());
                }
                WandsMod.LOGGER.info("registering menues.");
            });
        } else {
            MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.PALETTE_CONTAINER.get()), PaletteScreen::new);
            MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.WAND_CONTAINER.get()), WandScreen::new);
            MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.MAGIC_WAND_CONTANIER.get()), MagicBagScreen::new);
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)WandsMod.SND_PACKET, (packet, context) -> {
            BlockPos pos = packet.m_130135_();
            boolean destroy = packet.readBoolean();
            ItemStack item_stack = packet.m_130267_();
            boolean no_tool = packet.readBoolean();
            boolean damaged_tool = packet.readBoolean();
            int i_sound = packet.readInt();
            context.queue(() -> {
                if (i_sound > -1 && i_sound < Wand.Sounds.values().length) {
                    Wand.Sounds snd = Wand.Sounds.values()[i_sound];
                    SoundEvent sound = snd.get_sound();
                    context.getPlayer().f_19853_.m_5594_(context.getPlayer(), pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (!item_stack.m_41619_()) {
                    Block block = Block.m_49814_((Item)item_stack.m_41720_());
                    SoundType sound_type = block.m_49962_(block.m_49966_());
                    SoundEvent sound = destroy ? sound_type.m_56775_() : sound_type.m_56777_();
                    context.getPlayer().f_19853_.m_5594_(context.getPlayer(), pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (no_tool) {
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)new WandToast("no tool"));
                }
                if (damaged_tool) {
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)new WandToast("invalid or damaged"));
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)WandsMod.STATE_PACKET, (packet, context) -> {
            long seed = packet.readLong();
            int mode = packet.readInt();
            int slot = packet.readInt();
            boolean xp = packet.readBoolean();
            int levels = packet.readInt();
            float prog = packet.readFloat();
            context.queue(() -> {
                if (ClientRender.wand != null) {
                    ClientRender.wand.palette.seed = seed;
                    ClientRender.wand.mode = WandProps.Mode.values()[mode];
                    if (ClientRender.wand.mode == WandProps.Mode.DIRECTION) {
                        ClientRender.wand.palette.slot = slot;
                    }
                    if (xp) {
                        context.getPlayer().f_36078_ = levels;
                        context.getPlayer().f_36080_ = prog;
                    }
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)WandsMod.CONF_PACKET, (packet, context) -> {
            ServerData srv = Minecraft.m_91087_().m_91089_();
            if (srv != null && WandsMod.config != null) {
                WandsMod.config.blocks_per_xp = packet.readFloat();
                WandsMod.config.destroy_in_survival_drop = packet.readBoolean();
                WandsMod.config.survival_unenchanted_drops = packet.readBoolean();
                WandsMod.config.allow_wand_to_break = packet.readBoolean();
                WandsMod.config.allow_offhand_to_break = packet.readBoolean();
                WandsMod.config.mend_tools = packet.readBoolean();
                LOGGER.info("got config");
                context.queue(() -> {});
            }
        });
    }

    public static void send_key(int key, boolean shift, boolean alt) {
        Minecraft client = Minecraft.m_91087_();
        if (client.m_91403_() != null) {
            FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
            packet.writeInt(key);
            packet.writeBoolean(shift);
            packet.writeBoolean(alt);
            NetworkManager.sendToServer((ResourceLocation)WandsMod.KB_PACKET, (FriendlyByteBuf)packet);
        }
    }

    public static void send_palette(boolean next_mode, boolean toggle_rotate) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeBoolean(next_mode);
        packet.writeBoolean(toggle_rotate);
        NetworkManager.sendToServer((ResourceLocation)WandsMod.PALETTE_PACKET, (FriendlyByteBuf)packet);
    }

    public static void send_wand(ItemStack item) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130055_(item);
        NetworkManager.sendToServer((ResourceLocation)WandsMod.WAND_PACKET, (FriendlyByteBuf)packet);
    }

    public static void render_wand_info(PoseStack poseStack) {
        Minecraft client = Minecraft.m_91087_();
        if (client != null && client.f_91074_ != null) {
            boolean off;
            ItemStack stack = client.f_91074_.m_21205_();
            ItemStack offhand_stack = client.f_91074_.m_21206_();
            boolean main = stack != null && !stack.m_41619_() && stack.m_41720_() instanceof WandItem;
            boolean bl = off = offhand_stack != null && !offhand_stack.m_41619_() && offhand_stack.m_41720_() instanceof WandItem;
            if (main || off) {
                Font font;
                int screenWidth = client.m_91268_().m_85445_();
                int screenHeight = client.m_91268_().m_85446_();
                if (main) {
                    RenderSystem.m_69478_();
                    RenderSystem.m_69453_();
                    font = client.f_91062_;
                    Compat.set_color(1.0f, 1.0f, 1.0f, 1.0f);
                    Compat.set_pos_tex_shader();
                    Wand wand = ClientRender.wand;
                    WandProps.Mode mode = WandProps.getMode(stack);
                    WandProps.Action action = WandProps.getAction(stack);
                    Rotation r = WandProps.getRotation(stack);
                    String rot = "";
                    switch (r) {
                        case NONE: {
                            rot = "0\u00b0";
                            break;
                        }
                        case CLOCKWISE_90: {
                            rot = "90\u00b0";
                            break;
                        }
                        case CLOCKWISE_180: {
                            rot = "180\u00b0";
                            break;
                        }
                        case COUNTERCLOCKWISE_90: {
                            rot = "270\u00b0";
                        }
                    }
                    Object ln1 = "";
                    String ln2 = "Action: " + action.toString();
                    String ln3 = "Mode: " + mode.toString() + " Rot:" + rot;
                    if (wand.valid) {
                        switch (mode) {
                            case DIRECTION: {
                                int mult = WandProps.getVal(stack, WandProps.Value.MULTIPLIER);
                                ln1 = "pos: [" + wand.pos.m_123341_() + "," + wand.pos.m_123342_() + "," + wand.pos.m_123343_() + "] x" + mult;
                                break;
                            }
                            case GRID: {
                                int gm = WandProps.getVal(stack, WandProps.Value.GRIDM);
                                int gn = WandProps.getVal(stack, WandProps.Value.GRIDN);
                                int gms = WandProps.getVal(stack, WandProps.Value.GRIDMS);
                                int gns = WandProps.getVal(stack, WandProps.Value.GRIDNS);
                                Object skp = "";
                                if (gms > 0 || gns > 0) {
                                    skp = " - (" + gms + "x" + gns + ")";
                                }
                                ln1 = "Grid " + gm + "x" + gn + (String)skp;
                                break;
                            }
                            case ROW_COL: 
                            case FILL: 
                            case LINE: 
                            case AREA: 
                            case VEIN: {
                                int arealim = WandProps.getVal(stack, WandProps.Value.AREALIM);
                                ln1 = "Blocks: " + wand.block_buffer.get_length();
                                if (arealim <= 0) break;
                                ln1 = (String)ln1 + " Limit: " + arealim;
                                break;
                            }
                            case CIRCLE: {
                                ln1 = "Radius: " + wand.radius + " N: " + wand.block_buffer.get_length();
                                break;
                            }
                            case COPY: 
                            case PASTE: {
                                ln1 = "Copied Blocks: " + wand.copy_paste_buffer.size();
                            }
                        }
                    }
                    Objects.requireNonNull(font);
                    int h = 3 * 9;
                    float x = (int)((float)screenWidth * (WandsMod.config.wand_mode_display_x_pos / 100.0f));
                    float y = (int)((float)(screenHeight - h) * (WandsMod.config.wand_mode_display_y_pos / 100.0f));
                    font.m_92883_(poseStack, (String)ln1, x, y, 0xFFFFFF);
                    Objects.requireNonNull(font);
                    font.m_92883_(poseStack, ln2, x, y + 9.0f, 0xFFFFFF);
                    Objects.requireNonNull(font);
                    font.m_92883_(poseStack, ln3, x, y + (float)(9 * 2), 0xFFFFFF);
                }
                if (WandsMod.config.show_tools_info) {
                    font = client.f_91062_;
                    ItemRenderer itemRenderer = client.m_91291_();
                    if (!main) {
                        stack = offhand_stack;
                    }
                    CompoundTag ctag = stack.m_41784_();
                    ListTag tag = ctag.m_128437_("Tools", 10);
                    int ix = (int)((float)screenWidth * (WandsMod.config.wand_tools_display_x_pos / 100.0f));
                    int iy = (int)((float)(screenHeight - 20) * (WandsMod.config.wand_tools_display_y_pos / 100.0f));
                    tag.forEach(element -> {
                        CompoundTag stackTag = (CompoundTag)element;
                        int slot = stackTag.m_128451_("Slot");
                        ItemStack item = ItemStack.m_41712_((CompoundTag)stackTag.m_128469_("Tool"));
                        int yoff = 0;
                        if (ClientRender.has_target && slot == ClientRender.wand.digger_item_slot) {
                            yoff = -5;
                        }
                        itemRenderer.m_115203_(item, ix + slot * 16, iy + yoff);
                        itemRenderer.m_115174_(font, item, ix + slot * 16, iy, null);
                    });
                }
            }
        }
    }

    static {
        LOGGER = LogManager.getLogger();
        keys = new HashMap();
    }
}

