/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.config.WandsConfig;
import net.nicguzzo.wands.items.WandItem;
import net.nicguzzo.wands.utils.Colorf;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.wand.CopyBuffer;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandProps;

public class ClientRender {
    public static final float p_o = -0.005f;
    private static long t0 = 0L;
    private static long t1 = 0L;
    private static long t00 = 0L;
    private static boolean prnt;
    public static BlockPos last_pos;
    static Direction last_side;
    static WandProps.Mode last_mode;
    static Rotation last_rot;
    static boolean last_alt;
    static int last_buffer_size;
    static WandProps.Orientation last_orientation;
    public static Wand wand;
    static VoxelShape preview_shape;
    static AABB def_aabb;
    private static final int grid_n = 16;
    private static int grid_i;
    private static final double[] grid_vx;
    private static final double[] grid_vy;
    private static final double[] grid_vz;
    static boolean force;
    static float x1;
    static float y1;
    static float z1;
    static float x2;
    static float y2;
    static float z2;
    static float opacity;
    static boolean fancy;
    static boolean fat_lines;
    static boolean drawlines;
    static boolean block_outlines;
    static boolean fill_outlines;
    static boolean copy_outlines;
    static boolean paste_outlines;
    static float fat_lines_width;
    static Minecraft client;
    private static final ResourceLocation GRID_TEXTURE;
    private static final ResourceLocation LINE_TEXTURE;
    public static RandomSource random;
    static Direction[] dirs;
    public static boolean update_colors;
    static Colorf block_col;
    static Colorf bo_col;
    static Colorf bbox_col;
    static Colorf destroy_col;
    static Colorf tool_use_col;
    static Colorf start_col;
    static Colorf end_col;
    static Colorf line_col;
    static Colorf paste_bb_col;
    public static boolean has_target;
    static PoseStack matrixStack2;
    static BlockPos.MutableBlockPos bp;
    static boolean water;
    static BlockState AIR;
    static int mirroraxis;

    public static void render(PoseStack matrixStack) {
        client = Minecraft.m_91087_();
        LocalPlayer player = ClientRender.client.f_91074_;
        if (player == null) {
            return;
        }
        if (ClientRender.client.f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        if (update_colors) {
            update_colors = false;
            WandsConfig.get_instance().parse_colors();
            ClientRender.update_colors();
        }
        drawlines = !WandsMod.config.no_lines;
        block_outlines = WandsMod.config.block_outlines;
        fill_outlines = WandsMod.config.fill_outlines;
        copy_outlines = WandsMod.config.copy_outlines;
        paste_outlines = WandsMod.config.paste_outlines;
        opacity = WandsMod.config.preview_opacity;
        fancy = WandsConfig.get_instance().fancy_preview;
        fat_lines = WandsConfig.get_instance().fat_lines;
        if (WandsConfig.get_instance().fat_lines_width > 0.0f && (double)WandsConfig.get_instance().fat_lines_width < 0.5) {
            fat_lines_width = WandsConfig.get_instance().fat_lines_width;
        }
        ItemStack stack = player.m_21205_();
        prnt = false;
        force = false;
        if (stack != null && !stack.m_41619_() && stack.m_41720_() instanceof WandItem) {
            t1 = System.currentTimeMillis();
            if (t1 - t0 > 1000L) {
                t0 = System.currentTimeMillis();
                prnt = true;
            }
            if (t1 - t00 > 100L) {
                t00 = System.currentTimeMillis();
                force = true;
            }
            HitResult hitResult = ClientRender.client.f_91077_;
            WandProps.Mode mode = WandProps.getMode(stack);
            mirroraxis = WandProps.getVal(player.m_21205_(), WandProps.Value.MIRRORAXIS);
            if (hitResult != null && hitResult.m_6662_() == HitResult.Type.BLOCK && !ClientRender.wand.is_alt_pressed) {
                BlockHitResult block_hit;
                has_target = true;
                ClientRender.wand.lastPlayerDirection = player.m_6350_();
                ClientRender.wand.lastHitResult = block_hit = (BlockHitResult)hitResult;
                Rotation rot = WandProps.getRotation(stack);
                WandProps.Orientation orientation = WandProps.getOrientation(stack);
                Direction side = block_hit.m_82434_();
                BlockPos pos = block_hit.m_82425_();
                BlockState block_state = ClientRender.client.f_91073_.m_8055_(pos);
                if (force) {
                    ClientRender.wand.force_render = false;
                    if ((mode == WandProps.Mode.FILL || mode == WandProps.Mode.LINE || mode == WandProps.Mode.CIRCLE || mode == WandProps.Mode.COPY) && WandProps.getFlag(stack, WandProps.Flag.INCSELBLOCK)) {
                        pos = pos.m_5484_(side, 1);
                    }
                    last_pos = pos;
                    last_side = side;
                    last_mode = mode;
                    last_orientation = orientation;
                    last_rot = rot;
                    last_alt = ClientRender.wand.is_alt_pressed;
                    last_buffer_size = ClientRender.wand.block_buffer.get_length();
                    wand.do_or_preview((Player)player, player.f_19853_, block_state, pos, side, block_hit.m_82450_(), stack, prnt);
                }
                preview_shape = null;
                if (block_state != null && last_pos != null) {
                    preview_shape = block_state.m_60808_((BlockGetter)ClientRender.client.f_91073_, last_pos);
                }
                ClientRender.preview_mode(ClientRender.wand.mode, matrixStack, block_state);
            } else {
                has_target = false;
                if (ClientRender.wand.is_alt_pressed && (ClientRender.wand.copy_paste_buffer.size() > 0 || ClientRender.wand.block_buffer.get_length() > 0)) {
                    if (ClientRender.wand.mode != WandProps.Mode.LINE && ClientRender.wand.mode != WandProps.Mode.CIRCLE) {
                        ClientRender.wand.p1 = last_pos;
                    }
                    ClientRender.preview_mode(ClientRender.wand.mode, matrixStack, null);
                } else {
                    ClientRender.wand.block_buffer.reset();
                }
                if (water) {
                    water = false;
                }
            }
        }
    }

    private static void preview_mode(WandProps.Mode mode, PoseStack matrixStack, BlockState state) {
        Compat.pre_render(matrixStack);
        Camera camera = ClientRender.client.f_91063_.m_109153_();
        RenderSystem.m_69458_((boolean)true);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        boolean fabulous_depth_buffer = false;
        boolean bl = fabulous_depth_buffer = WandsMod.config.render_last && Minecraft.m_91085_();
        if (Screen.m_96637_() || fabulous_depth_buffer) {
            RenderSystem.m_69465_();
        } else {
            RenderSystem.m_69482_();
        }
        if (camera.m_90593_() && last_pos != null) {
            float last_pos_x = last_pos.m_123341_();
            float last_pos_y = last_pos.m_123342_();
            float last_pos_z = last_pos.m_123343_();
            float wand_x1 = ClientRender.wand.x1;
            float wand_y1 = ClientRender.wand.y1;
            float wand_z1 = ClientRender.wand.z1;
            float nx = 0.0f;
            float ny = 0.0f;
            float nz = 0.0f;
            float off2 = 0.05f;
            Compat.set_color(1.0f, 1.0f, 1.0f, 0.8f);
            RenderSystem.m_69832_((float)1.0f);
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            switch (mode) {
                case DIRECTION: {
                    List list;
                    if (ClientRender.wand.valid && preview_shape != null && !preview_shape.m_83281_() && !(list = preview_shape.m_83299_()).isEmpty() && ClientRender.wand.grid_voxel_index >= 0 && ClientRender.wand.grid_voxel_index < list.size()) {
                        int vi;
                        if (fancy) {
                            RenderSystem.m_69493_();
                            RenderSystem.m_69464_();
                            RenderSystem.m_69481_();
                            RenderSystem.m_69478_();
                            Compat.set_render_quads_block(bufferBuilder);
                            Compat.set_texture(GRID_TEXTURE);
                            vi = 0;
                            for (AABB aabb : list) {
                                if (vi == ClientRender.wand.grid_voxel_index) {
                                    nx = ClientRender.wand.side.m_122436_().m_123341_();
                                    ny = ClientRender.wand.side.m_122436_().m_123342_();
                                    nz = ClientRender.wand.side.m_122436_().m_123343_();
                                    switch (ClientRender.wand.side) {
                                        case UP: {
                                            x1 = last_pos_x + (float)aabb.f_82288_;
                                            y1 = last_pos_y + (float)aabb.f_82292_ + 0.02f;
                                            z1 = last_pos_z + (float)aabb.f_82290_;
                                            x2 = last_pos_x + (float)aabb.f_82291_;
                                            z2 = last_pos_z + (float)aabb.f_82293_;
                                            bufferBuilder.m_5954_(x1, y1, z1, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x1, y1, z2, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x2, y1, z2, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x2, y1, z1, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0, 0, nx, ny, nz);
                                            break;
                                        }
                                        case DOWN: {
                                            x1 = last_pos_x + (float)aabb.f_82288_;
                                            y1 = last_pos_y + (float)aabb.f_82289_ - 0.02f;
                                            z1 = last_pos_z + (float)aabb.f_82290_;
                                            x2 = last_pos_x + (float)aabb.f_82291_;
                                            z2 = last_pos_z + (float)aabb.f_82293_;
                                            bufferBuilder.m_5954_(x1, y1, z1, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x2, y1, z1, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x2, y1, z2, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x1, y1, z2, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0, 0, nx, ny, nz);
                                            break;
                                        }
                                        case SOUTH: {
                                            x1 = last_pos_x + (float)aabb.f_82288_;
                                            y1 = last_pos_y + (float)aabb.f_82289_;
                                            z1 = last_pos_z + (float)aabb.f_82293_ + 0.02f;
                                            x2 = last_pos_x + (float)aabb.f_82291_;
                                            y2 = last_pos_y + (float)aabb.f_82292_;
                                            bufferBuilder.m_5954_(x1, y1, z1, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x2, y1, z1, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x2, y2, z1, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x1, y2, z1, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0, 0, nx, ny, nz);
                                            break;
                                        }
                                        case NORTH: {
                                            x1 = last_pos_x + (float)aabb.f_82288_;
                                            y1 = last_pos_y + (float)aabb.f_82289_;
                                            z1 = last_pos_z + (float)aabb.f_82290_ - 0.02f;
                                            x2 = last_pos_x + (float)aabb.f_82291_;
                                            y2 = last_pos_y + (float)aabb.f_82292_;
                                            bufferBuilder.m_5954_(x1, y1, z1, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x1, y2, z1, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x2, y2, z1, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x2, y1, z1, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0, 0, nx, ny, nz);
                                            break;
                                        }
                                        case EAST: {
                                            x1 = last_pos_x + (float)aabb.f_82291_ + 0.02f;
                                            y1 = last_pos_y + (float)aabb.f_82289_;
                                            z1 = last_pos_z + (float)aabb.f_82290_;
                                            y2 = last_pos_y + (float)aabb.f_82292_;
                                            z2 = last_pos_z + (float)aabb.f_82293_;
                                            bufferBuilder.m_5954_(x1, y1, z1, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x1, y2, z1, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x1, y2, z2, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x1, y1, z2, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0, 0, nx, ny, nz);
                                            break;
                                        }
                                        case WEST: {
                                            x1 = last_pos_x + (float)aabb.f_82288_ - 0.02f;
                                            y1 = last_pos_y + (float)aabb.f_82289_;
                                            z1 = last_pos_z + (float)aabb.f_82290_;
                                            y2 = last_pos_y + (float)aabb.f_82292_;
                                            z2 = last_pos_z + (float)aabb.f_82293_;
                                            bufferBuilder.m_5954_(x1, y1, z1, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x1, y1, z2, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x1, y2, z2, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0, 0, nx, ny, nz);
                                            bufferBuilder.m_5954_(x1, y2, z1, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0, 0, nx, ny, nz);
                                        }
                                    }
                                }
                                ++vi;
                            }
                            tesselator.m_85914_();
                            RenderSystem.m_69478_();
                            RenderSystem.m_69472_();
                        }
                        if (!fancy || !fat_lines) {
                            Compat.set_render_lines(bufferBuilder);
                            vi = 0;
                            for (AABB aabb : list) {
                                if (vi == ClientRender.wand.grid_voxel_index) {
                                    ClientRender.grid(bufferBuilder, ClientRender.wand.side, last_pos_x, last_pos_y, last_pos_z, aabb);
                                }
                                ++vi;
                            }
                            tesselator.m_85914_();
                        }
                    }
                }
                case ROW_COL: 
                case FILL: 
                case AREA: 
                case GRID: 
                case LINE: 
                case CIRCLE: 
                case VEIN: {
                    if (!ClientRender.wand.valid && mode != WandProps.Mode.LINE && mode != WandProps.Mode.CIRCLE && (!ClientRender.wand.valid || !ClientRender.wand.has_empty_bucket)) break;
                    if (drawlines && fill_outlines && (mode == WandProps.Mode.ROW_COL || mode == WandProps.Mode.FILL)) {
                        if (fat_lines) {
                            RenderSystem.m_69493_();
                            Compat.set_render_quads_pos_tex(bufferBuilder);
                            ClientRender.preview_block_fat(bufferBuilder, (float)ClientRender.wand.bb1_x - off2, (float)ClientRender.wand.bb1_y - off2, (float)ClientRender.wand.bb1_z - off2, (float)ClientRender.wand.bb2_x + off2, (float)ClientRender.wand.bb2_y + off2, (float)ClientRender.wand.bb2_z + off2, bbox_col, false);
                            tesselator.m_85914_();
                            RenderSystem.m_69472_();
                            RenderSystem.m_69481_();
                        } else {
                            Compat.set_render_lines(bufferBuilder);
                            ClientRender.preview_block(bufferBuilder, (float)ClientRender.wand.bb1_x - off2, (float)ClientRender.wand.bb1_y - off2, (float)ClientRender.wand.bb1_z - off2, (float)ClientRender.wand.bb2_x + off2, (float)ClientRender.wand.bb2_y + off2, (float)ClientRender.wand.bb2_z + off2, bbox_col);
                            tesselator.m_85914_();
                        }
                    }
                    if (ClientRender.wand.has_empty_bucket || ClientRender.wand.valid && (has_target || ClientRender.wand.is_alt_pressed) && ClientRender.wand.block_buffer != null) {
                        random.m_188584_(0L);
                        if (fancy && !ClientRender.wand.destroy && !ClientRender.wand.use && !ClientRender.wand.has_empty_bucket) {
                            RenderSystem.m_69493_();
                            RenderSystem.m_69481_();
                            Compat.set_color(1.0f, 1.0f, 1.0f, opacity);
                            Compat.set_render_quads_block(bufferBuilder);
                            for (int idx = 0; idx < ClientRender.wand.block_buffer.get_length() && idx < Wand.MAX_LIMIT; ++idx) {
                                if (ClientRender.wand.block_buffer.state[idx] == null) continue;
                                BlockState st = ClientRender.wand.block_buffer.state[idx];
                                if (ClientRender.wand.has_water_bucket) {
                                    st = Blocks.f_49990_.m_49966_();
                                } else if (ClientRender.wand.has_lava_bucket) {
                                    st = Blocks.f_49991_.m_49966_();
                                }
                                ClientRender.render_shape(matrixStack, tesselator, bufferBuilder, st, ClientRender.wand.block_buffer.buffer_x[idx], ClientRender.wand.block_buffer.buffer_y[idx], ClientRender.wand.block_buffer.buffer_z[idx]);
                                if (ClientRender.wand.block_buffer.state[idx].m_61138_((Property)DoublePlantBlock.f_52858_)) {
                                    ClientRender.render_shape(matrixStack, tesselator, bufferBuilder, (BlockState)ClientRender.wand.block_buffer.state[idx].m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER), ClientRender.wand.block_buffer.buffer_x[idx], ClientRender.wand.block_buffer.buffer_y[idx] + 1, ClientRender.wand.block_buffer.buffer_z[idx]);
                                    continue;
                                }
                                if (!(ClientRender.wand.block_buffer.state[idx].m_60734_() instanceof DoorBlock)) continue;
                                ClientRender.render_shape(matrixStack, tesselator, bufferBuilder, (BlockState)ClientRender.wand.block_buffer.state[idx].m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER), ClientRender.wand.block_buffer.buffer_x[idx], ClientRender.wand.block_buffer.buffer_y[idx] + 1, ClientRender.wand.block_buffer.buffer_z[idx]);
                            }
                            tesselator.m_85914_();
                            RenderSystem.m_69472_();
                        }
                        ClientRender.render_mode_outline(tesselator, bufferBuilder);
                    }
                    if (!drawlines || ClientRender.wand.p1 == null || mode != WandProps.Mode.LINE && mode != WandProps.Mode.CIRCLE) break;
                    if (fat_lines) {
                        RenderSystem.m_69493_();
                        Compat.set_render_quads_pos_tex(bufferBuilder);
                        boolean even = WandProps.getFlag(ClientRender.wand.wand_stack, WandProps.Flag.EVEN);
                        float off = mode == WandProps.Mode.CIRCLE && even ? -1.0f : 0.0f;
                        ClientRender.preview_block_fat(bufferBuilder, (float)ClientRender.wand.p1.m_123341_() + off, (float)ClientRender.wand.p1.m_123342_() + off, (float)ClientRender.wand.p1.m_123343_() + off, ClientRender.wand.p1.m_123341_() + 1, ClientRender.wand.p1.m_123342_() + 1, ClientRender.wand.p1.m_123343_() + 1, start_col, false);
                        tesselator.m_85914_();
                        if (has_target) {
                            Compat.set_render_quads_pos_tex(bufferBuilder);
                            ClientRender.preview_block_fat(bufferBuilder, last_pos_x, last_pos_y, last_pos_z, last_pos_x + 1.0f, last_pos_y + 1.0f, last_pos_z + 1.0f, end_col, false);
                            tesselator.m_85914_();
                            RenderSystem.m_69465_();
                            Compat.set_render_quads_pos_tex(bufferBuilder);
                            off = mode == WandProps.Mode.CIRCLE && even ? 0.0f : 0.5f;
                            ClientRender.player_facing_line(bufferBuilder, (float)camera.m_90583_().f_82479_, (float)camera.m_90583_().f_82480_, (float)camera.m_90583_().f_82481_, last_pos_x + off, last_pos_y + off, last_pos_z + off, wand_x1 + off, wand_y1 + off, wand_z1 + off, line_col);
                            tesselator.m_85914_();
                        }
                        RenderSystem.m_69472_();
                        RenderSystem.m_69482_();
                        RenderSystem.m_69481_();
                        break;
                    }
                    Compat.set_render_lines(bufferBuilder);
                    bufferBuilder.m_5483_((double)last_pos_x + 0.5, (double)last_pos_y + 0.5, (double)last_pos_z + 0.5).m_85950_(ClientRender.line_col.r, ClientRender.line_col.g, ClientRender.line_col.b, ClientRender.line_col.a).m_5752_();
                    bufferBuilder.m_5483_((double)wand_x1 + 0.5, (double)wand_y1 + 0.5, (double)wand_z1 + 0.5).m_85950_(ClientRender.line_col.r, ClientRender.line_col.g, ClientRender.line_col.b, ClientRender.line_col.a).m_5752_();
                    RenderSystem.m_69465_();
                    ClientRender.preview_block(bufferBuilder, ClientRender.wand.p1.m_123341_(), ClientRender.wand.p1.m_123342_(), ClientRender.wand.p1.m_123343_(), ClientRender.wand.p1.m_123341_() + 1, ClientRender.wand.p1.m_123342_() + 1, ClientRender.wand.p1.m_123343_() + 1, start_col);
                    ClientRender.preview_block(bufferBuilder, last_pos_x - off2, last_pos_y - off2, last_pos_z - off2, last_pos_x + 1.0f + off2, last_pos_y + 1.0f + off2, last_pos_z + 1.0f + off2, end_col);
                    RenderSystem.m_69482_();
                    tesselator.m_85914_();
                    break;
                }
                case COPY: {
                    if (!drawlines || !copy_outlines || !ClientRender.wand.valid) break;
                    x1 = ClientRender.wand.copy_x1 > ClientRender.wand.copy_x2 ? (float)ClientRender.wand.copy_x1 + off2 : (float)ClientRender.wand.copy_x1 - off2;
                    y1 = ClientRender.wand.copy_y1 > ClientRender.wand.copy_y2 ? (float)ClientRender.wand.copy_y1 + off2 : (float)ClientRender.wand.copy_y1 - off2;
                    z1 = ClientRender.wand.copy_z1 > ClientRender.wand.copy_z2 ? (float)ClientRender.wand.copy_z1 + off2 : (float)ClientRender.wand.copy_z1 - off2;
                    x2 = ClientRender.wand.copy_x2 > ClientRender.wand.copy_x1 ? (float)ClientRender.wand.copy_x2 + off2 : (float)ClientRender.wand.copy_x2 - off2;
                    y2 = ClientRender.wand.copy_y2 > ClientRender.wand.copy_y1 ? (float)ClientRender.wand.copy_y2 + off2 : (float)ClientRender.wand.copy_y2 - off2;
                    float f = z2 = ClientRender.wand.copy_z2 > ClientRender.wand.copy_z1 ? (float)ClientRender.wand.copy_z2 + off2 : (float)ClientRender.wand.copy_z2 - off2;
                    if (fat_lines) {
                        RenderSystem.m_69493_();
                        Compat.set_render_quads_pos_tex(bufferBuilder);
                        ClientRender.preview_block_fat(bufferBuilder, x1, y1, z1, x2, y2, z2, bbox_col, false);
                        tesselator.m_85914_();
                        RenderSystem.m_69472_();
                        RenderSystem.m_69481_();
                        break;
                    }
                    Compat.set_render_lines(bufferBuilder);
                    ClientRender.preview_block(bufferBuilder, x1, y1, z1, x2, y2, z2, bbox_col);
                    tesselator.m_85914_();
                    break;
                }
                case PASTE: {
                    if (ClientRender.wand.copy_paste_buffer.size() <= 0) break;
                    int mx = 1;
                    int my = 1;
                    int mz = 1;
                    switch (mirroraxis) {
                        case 1: {
                            mx = -1;
                            break;
                        }
                        case 2: {
                            my = -1;
                            break;
                        }
                        case 3: {
                            mz = -1;
                        }
                    }
                    BlockPos b_pos = last_pos;
                    if (!ClientRender.wand.replace && !ClientRender.wand.destroy) {
                        b_pos = last_pos.m_5484_(last_side, 1);
                    }
                    if (!ClientRender.wand.destroy && fancy) {
                        RenderSystem.m_69481_();
                        RenderSystem.m_69493_();
                        Compat.set_color(1.0f, 1.0f, 1.0f, opacity);
                        Compat.set_render_quads_block(bufferBuilder);
                        random.m_188584_(0L);
                        ClientRender.wand.random.m_188584_(ClientRender.wand.palette.seed);
                        BlockPos po = ClientRender.wand.copy_paste_buffer.get((int)0).pos;
                        for (CopyBuffer b : ClientRender.wand.copy_paste_buffer) {
                            BlockState st = b.state;
                            st = ClientRender.wand.palette.has_palette ? wand.get_state() : wand.mirror_stair(st, mirroraxis);
                            BlockPos p = b.pos.m_7954_(last_rot);
                            int px = b_pos.m_123341_() + p.m_123341_() * mx;
                            int py = b_pos.m_123342_() + p.m_123342_() * my;
                            int pz = b_pos.m_123343_() + p.m_123343_() * mz;
                            ClientRender.render_shape(matrixStack, tesselator, bufferBuilder, st, px, py, pz);
                        }
                        tesselator.m_85914_();
                        RenderSystem.m_69472_();
                    }
                    if (!drawlines || !paste_outlines) break;
                    Colorf c = ClientRender.wand.destroy ? destroy_col : paste_bb_col;
                    x1 = 2.1474836E9f;
                    y1 = 2.1474836E9f;
                    z1 = 2.1474836E9f;
                    x2 = -2.1474836E9f;
                    y2 = -2.1474836E9f;
                    z2 = -2.1474836E9f;
                    if (fat_lines) {
                        RenderSystem.m_69493_();
                        Compat.set_render_quads_pos_tex(bufferBuilder);
                    } else {
                        Compat.set_render_lines(bufferBuilder);
                    }
                    for (CopyBuffer b : ClientRender.wand.copy_paste_buffer) {
                        BlockPos p = b.pos.m_7954_(last_rot);
                        float x = b_pos.m_123341_() + p.m_123341_() * mx;
                        float y = b_pos.m_123342_() + p.m_123342_() * my;
                        float z = b_pos.m_123343_() + p.m_123343_() * mz;
                        if (fat_lines) {
                            ClientRender.preview_block_fat(bufferBuilder, x, y, z, x + 1.0f, y + 1.0f, z + 1.0f, c, true);
                        } else {
                            ClientRender.preview_block(bufferBuilder, x, y, z, x + 1.0f, y + 1.0f, z + 1.0f, c);
                        }
                        if (x < x1) {
                            x1 = x;
                        }
                        if (y < y1) {
                            y1 = y;
                        }
                        if (z < z1) {
                            z1 = z;
                        }
                        if (x + 1.0f > x2) {
                            x2 = x + 1.0f;
                        }
                        if (y + 1.0f > y2) {
                            y2 = y + 1.0f;
                        }
                        if (!(z + 1.0f > z2)) continue;
                        z2 = z + 1.0f;
                    }
                    tesselator.m_85914_();
                    RenderSystem.m_69472_();
                    if (fat_lines) {
                        RenderSystem.m_69493_();
                        Compat.set_render_quads_pos_tex(bufferBuilder);
                    } else {
                        Compat.set_render_lines(bufferBuilder);
                    }
                    if (fat_lines) {
                        ClientRender.preview_block_fat(bufferBuilder, x1, y1, z1, x2, y2, z2, c, false);
                    } else {
                        ClientRender.preview_block(bufferBuilder, x1, y1, z1, x2, y2, z2, c);
                    }
                    tesselator.m_85914_();
                    RenderSystem.m_69472_();
                }
            }
            RenderSystem.m_69832_((float)1.0f);
        }
        Compat.post_render(matrixStack);
        RenderSystem.m_69458_((boolean)true);
    }

    public static void render_mode_outline(Tesselator tesselator, BufferBuilder bufferBuilder) {
        Colorf mode_outline_color = bo_col;
        if (ClientRender.wand.destroy || ClientRender.wand.has_empty_bucket) {
            mode_outline_color = destroy_col;
        }
        if (ClientRender.wand.use && (ClientRender.wand.has_hoe || ClientRender.wand.has_axe || ClientRender.wand.has_shovel)) {
            mode_outline_color = tool_use_col;
        }
        if (drawlines && block_outlines) {
            if (fat_lines) {
                RenderSystem.m_69493_();
                Compat.set_render_quads_pos_tex(bufferBuilder);
            } else {
                RenderSystem.m_69481_();
                Compat.set_render_lines(bufferBuilder);
            }
            for (int idx = 0; idx < ClientRender.wand.block_buffer.get_length() && idx < Wand.MAX_LIMIT; ++idx) {
                float x = ClientRender.wand.block_buffer.buffer_x[idx];
                float y = ClientRender.wand.block_buffer.buffer_y[idx];
                float z = ClientRender.wand.block_buffer.buffer_z[idx];
                if (ClientRender.wand.block_buffer.state[idx] == null) continue;
                preview_shape = ClientRender.wand.block_buffer.state[idx].m_60808_((BlockGetter)ClientRender.client.f_91073_, last_pos);
                List list = preview_shape.m_83299_();
                for (AABB aabb : list) {
                    if (fat_lines) {
                        ClientRender.preview_block_fat(bufferBuilder, x + (float)aabb.f_82288_, y + (float)aabb.f_82289_, z + (float)aabb.f_82290_, x + (float)aabb.f_82291_, y + (float)aabb.f_82292_, z + (float)aabb.f_82293_, mode_outline_color, ClientRender.wand.destroy);
                        continue;
                    }
                    ClientRender.preview_block(bufferBuilder, (double)x + aabb.f_82288_, (double)y + aabb.f_82289_, (double)z + aabb.f_82290_, (double)x + aabb.f_82291_, (double)y + aabb.f_82292_, (double)z + aabb.f_82293_, mode_outline_color);
                }
            }
            tesselator.m_85914_();
            if (fat_lines) {
                RenderSystem.m_69472_();
            }
        }
    }

    static void preview_block(BufferBuilder bufferBuilder, double fx1, double fy1, double fz1, double fx2, double fy2, double fz2, Colorf c) {
        fy2 -= (double)-0.005f;
        bufferBuilder.m_5483_(fx1 += (double)-0.005f, fy1 += (double)-0.005f, fz1 += (double)-0.005f).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx2 -= (double)-0.005f, fy1, fz1).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx1, fy1, fz1).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx1, fy1, fz2 -= (double)-0.005f).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx1, fy1, fz2).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx2, fy1, fz2).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx2, fy1, fz1).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx2, fy1, fz2).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx1, fy2, fz1).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx2, fy2, fz1).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx1, fy2, fz1).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx1, fy2, fz2).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx1, fy2, fz2).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx2, fy2, fz2).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx2, fy2, fz1).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx2, fy2, fz2).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx1, fy1, fz1).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx1, fy2, fz1).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx2, fy1, fz1).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx2, fy2, fz1).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx1, fy1, fz2).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx1, fy2, fz2).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx2, fy1, fz2).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
        bufferBuilder.m_5483_(fx2, fy2, fz2).m_85950_(c.r, c.g, c.b, c.a).m_5752_();
    }

    static void preview_block_fat(BufferBuilder bufferBuilder, float fx1, float fy1, float fz1, float fx2, float fy2, float fz2, Colorf c, boolean cross) {
        float off = 0.01f;
        fx1 -= off;
        fy1 -= off;
        fz1 -= off;
        fx2 += off;
        fy2 += off;
        fz2 += off;
        Compat.set_color(c.r, c.g, c.b, c.a);
        Compat.set_texture(LINE_TEXTURE);
        float w = fat_lines_width;
        float nx = 0.0f;
        float ny = 0.0f;
        float nz = -1.0f;
        ClientRender.quad_line(bufferBuilder, 0.0f, w, 0.0f, fx1, fy1, fz1, fx2, fy1, fz1, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, 0.0f, -w, 0.0f, fx2, fy2, fz1, fx1, fy2, fz1, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, w, 0.0f, 0.0f, fx1, fy2 - w, fz1, fx1, fy1 + w, fz1, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, -w, 0.0f, 0.0f, fx2, fy1 + w, fz1, fx2, fy2 - w, fz1, nx, ny, nz, c);
        if (cross) {
            ClientRender.quad_line(bufferBuilder, -w, 0.0f, 0.0f, fx1 + w, fy1, fz1, fx2, fy2, fz1, nx, ny, nz, c);
            ClientRender.quad_line(bufferBuilder, w, 0.0f, 0.0f, fx1, fy2, fz1, fx2 - w, fy1, fz1, nx, ny, nz, c);
        }
        nx = 0.0f;
        ny = 0.0f;
        nz = 1.0f;
        ClientRender.quad_line(bufferBuilder, 0.0f, w, 0.0f, fx2, fy1, fz2, fx1, fy1, fz2, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, 0.0f, -w, 0.0f, fx1, fy2, fz2, fx2, fy2, fz2, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, w, 0.0f, 0.0f, fx1, fy1 + w, fz2, fx1, fy2 - w, fz2, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, -w, 0.0f, 0.0f, fx2, fy2 - w, fz2, fx2, fy1 + w, fz2, nx, ny, nz, c);
        if (cross) {
            ClientRender.quad_line(bufferBuilder, w, 0.0f, 0.0f, fx1, fy1, fz2, fx2 - w, fy2, fz2, nx, ny, nz, c);
            ClientRender.quad_line(bufferBuilder, -w, 0.0f, 0.0f, fx1 + w, fy2, fz2, fx2, fy1, fz2, nx, ny, nz, c);
        }
        nx = 0.0f;
        ny = 1.0f;
        nz = 0.0f;
        ClientRender.quad_line(bufferBuilder, w, 0.0f, 0.0f, fx1, fy2, fz2, fx1, fy2, fz1, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, -w, 0.0f, 0.0f, fx2, fy2, fz1, fx2, fy2, fz2, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, 0.0f, 0.0f, w, fx1 + w, fy2, fz1, fx2 - w, fy2, fz1, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, 0.0f, 0.0f, -w, fx2 - w, fy2, fz2, fx1 + w, fy2, fz2, nx, ny, nz, c);
        if (cross) {
            ClientRender.quad_line(bufferBuilder, -w, 0.0f, 0.0f, fx1 + w, fy2, fz1, fx2, fy2, fz2, nx, ny, nz, c);
            ClientRender.quad_line(bufferBuilder, w, 0.0f, 0.0f, fx1, fy2, fz2, fx2 - w, fy2, fz1, nx, ny, nz, c);
        }
        nx = 0.0f;
        ny = -1.0f;
        nz = 0.0f;
        ClientRender.quad_line(bufferBuilder, w, 0.0f, 0.0f, fx1, fy1, fz1, fx1, fy1, fz2, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, -w, 0.0f, 0.0f, fx2, fy1, fz2, fx2, fy1, fz1, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, 0.0f, 0.0f, w, fx2 - w, fy1, fz1, fx1 + w, fy1, fz1, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, 0.0f, 0.0f, -w, fx1 + w, fy1, fz2, fx2 - w, fy1, fz2, nx, ny, nz, c);
        if (cross) {
            ClientRender.quad_line(bufferBuilder, w, 0.0f, 0.0f, fx1, fy1, fz1, fx2 - w, fy1, fz2, nx, ny, nz, c);
            ClientRender.quad_line(bufferBuilder, -w, 0.0f, 0.0f, fx1 + w, fy1, fz2, fx2, fy1, fz1, nx, ny, nz, c);
        }
        nx = 1.0f;
        ny = 0.0f;
        nz = 0.0f;
        ClientRender.quad_line(bufferBuilder, 0.0f, w, 0.0f, fx2, fy1, fz1, fx2, fy1, fz2, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, 0.0f, -w, 0.0f, fx2, fy2, fz2, fx2, fy2, fz1, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, 0.0f, 0.0f, w, fx2, fy2 - w, fz1, fx2, fy1 + w, fz1, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, 0.0f, 0.0f, -w, fx2, fy1 + w, fz2, fx2, fy2 - w, fz2, nx, ny, nz, c);
        if (cross) {
            ClientRender.quad_line(bufferBuilder, 0.0f, 0.0f, w, fx1, fy1, fz1, fx1, fy2, fz2 - w, nx, ny, nz, c);
            ClientRender.quad_line(bufferBuilder, 0.0f, 0.0f, w, fx1, fy1, fz2 - w, fx1, fy2, fz1, nx, ny, nz, c);
        }
        nx = -1.0f;
        ny = 0.0f;
        nz = 0.0f;
        ClientRender.quad_line(bufferBuilder, 0.0f, w, 0.0f, fx1, fy1, fz2, fx1, fy1, fz1, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, 0.0f, -w, 0.0f, fx1, fy2, fz1, fx1, fy2, fz2, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, 0.0f, 0.0f, w, fx1, fy1 + w, fz1, fx1, fy2 - w, fz1, nx, ny, nz, c);
        ClientRender.quad_line(bufferBuilder, 0.0f, 0.0f, -w, fx1, fy2 - w, fz2, fx1, fy1 + w, fz2, nx, ny, nz, c);
        if (cross) {
            ClientRender.quad_line(bufferBuilder, 0.0f, 0.0f, -w, fx2, fy1, fz1 + w, fx2, fy2, fz2, nx, ny, nz, c);
            ClientRender.quad_line(bufferBuilder, 0.0f, 0.0f, -w, fx2, fy1, fz2, fx2, fy2, fz1 + w, nx, ny, nz, c);
        }
    }

    private static void quad_line(BufferBuilder bufferBuilder, float wx, float wy, float wz, float lx1, float ly1, float lz1, float lx2, float ly2, float lz2, float nx, float ny, float nz, Colorf c) {
        bufferBuilder.m_5954_(lx1, ly1, lz1, c.r, c.g, c.b, c.a, 0.0f, 0.0f, 0, 0, nx, ny, nz);
        bufferBuilder.m_5954_(lx1 + wx, ly1 + wy, lz1 + wz, c.r, c.g, c.b, c.a, 0.0f, 1.0f, 0, 0, nx, ny, nz);
        bufferBuilder.m_5954_(lx2 + wx, ly2 + wy, lz2 + wz, c.r, c.g, c.b, c.a, 1.0f, 1.0f, 0, 0, nx, ny, nz);
        bufferBuilder.m_5954_(lx2, ly2, lz2, c.r, c.g, c.b, c.a, 1.0f, 0.0f, 0, 0, nx, ny, nz);
    }

    private static void player_facing_line(BufferBuilder bufferBuilder, float cx, float cy, float cz, float lx1, float ly1, float lz1, float lx2, float ly2, float lz2, Colorf c) {
        float w = 0.05f;
        float p2y = ly2 - ly1;
        float p1z = cz - lz1;
        float p2z = lz2 - lz1;
        float p1y = cy - ly1;
        float nx = p2y * p1z - p2z * p1y;
        float p1x = cx - lx1;
        float p2x = lx2 - lx1;
        float ny = p2z * p1x - p2x * p1z;
        float nz = p2x * p1y - p2y * p1x;
        float l = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (l != 0.0f) {
            nx = nx / l * w;
            ny = ny / l * w;
            nz = nz / l * w;
        }
        Compat.set_texture(LINE_TEXTURE);
        Compat.set_color(c.r, c.g, c.b, c.a);
        bufferBuilder.m_5954_(lx1 - nx, ly1 - ny, lz1 - nz, c.r, c.g, c.b, c.a, 0.0f, 0.0f, 0, 0, nx, ny, nz);
        bufferBuilder.m_5954_(lx1 + nx, ly1 + ny, lz1 + nz, c.r, c.g, c.b, c.a, 0.0f, 1.0f, 0, 0, nx, ny, nz);
        bufferBuilder.m_5954_(lx2 + nx, ly2 + ny, lz2 + nz, c.r, c.g, c.b, c.a, 1.0f, 1.0f, 0, 0, nx, ny, nz);
        bufferBuilder.m_5954_(lx2 - nx, ly2 - ny, lz2 - nz, c.r, c.g, c.b, c.a, 1.0f, 0.0f, 0, 0, nx, ny, nz);
    }

    private static void set_grid_v(int i, double x, double y, double z) {
        if (i < 16) {
            ClientRender.grid_vx[i] = x;
            ClientRender.grid_vy[i] = y;
            ClientRender.grid_vz[i] = z;
        }
    }

    private static void add_grid_line(double x1, double y1, double z1, double x2, double y2, double z2) {
        ClientRender.set_grid_v(grid_i, x1, y1, z1);
        ClientRender.set_grid_v(++grid_i, x2, y2, z2);
        ++grid_i;
    }

    private static void draw_lines(BufferBuilder bufferBuilder, int from, int to, float r, float g, float b, float a) {
        for (int i = from; i < to && i < 16; ++i) {
            bufferBuilder.m_5483_(grid_vx[i], grid_vy[i], grid_vz[i]).m_85950_(r, g, b, a).m_5752_();
        }
    }

    private static void grid(BufferBuilder bufferBuilder, Direction side, double x, double y, double z, AABB aabb) {
        double w = 1.0;
        double h = 1.0;
        double w2 = w * 0.33333333;
        double w3 = w * 0.66666666;
        double h2 = h * 0.33333333;
        double h3 = h * 0.66666666;
        float o = 0.01f;
        switch (side) {
            case UP: 
            case DOWN: {
                w = aabb.m_82362_();
                h = aabb.m_82385_();
                x += aabb.f_82288_;
                z += aabb.f_82290_;
                y = side == Direction.UP ? (y += aabb.f_82292_ + (double)o) : (y += aabb.f_82289_ - (double)o);
                w2 = w * 0.33333333;
                w3 = w * 0.66666666;
                h2 = h * 0.33333333;
                h3 = h * 0.66666666;
                grid_i = 0;
                ClientRender.add_grid_line(x, y, z, x + w, y, z);
                ClientRender.add_grid_line(x, y, z, x, y, z + h);
                ClientRender.add_grid_line(x + w, y, z, x + w, y, z + h);
                ClientRender.add_grid_line(x, y, z + h, x + w, y, z + h);
                ClientRender.add_grid_line(x, y, z + h2, x + w, y, z + h2);
                ClientRender.add_grid_line(x, y, z + h3, x + w, y, z + h3);
                ClientRender.add_grid_line(x + w2, y, z, x + w2, y, z + h);
                ClientRender.add_grid_line(x + w3, y, z, x + w3, y, z + h);
                ClientRender.draw_lines(bufferBuilder, 0, 16, 1.0f, 1.0f, 1.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x + w * (double)0.4f, y, z + h * (double)0.2f, x + w * 0.5, y, z + h * (double)0.05f);
                ClientRender.add_grid_line(x + w * (double)0.6f, y, z + h * (double)0.2f, x + w * 0.5, y, z + h * (double)0.05f);
                ClientRender.add_grid_line(x + w * (double)0.4f, y, z + h * (double)0.8f, x + w * 0.5, y, z + h * (double)0.95f);
                ClientRender.add_grid_line(x + w * (double)0.6f, y, z + h * (double)0.8f, x + w * 0.5, y, z + h * (double)0.95f);
                ClientRender.add_grid_line(x + w * (double)0.2f, y, z + h * (double)0.4f, x + w * (double)0.05f, y, z + h * 0.5);
                ClientRender.add_grid_line(x + w * (double)0.2f, y, z + h * (double)0.6f, x + w * (double)0.05f, y, z + h * 0.5);
                ClientRender.add_grid_line(x + w * (double)0.8f, y, z + h * (double)0.4f, x + w * (double)0.95f, y, z + h * 0.5);
                ClientRender.add_grid_line(x + w * (double)0.8f, y, z + h * (double)0.6f, x + w * (double)0.95f, y, z + h * 0.5);
                ClientRender.draw_lines(bufferBuilder, 0, 16, 0.7f, 0.0f, 0.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x + w * (double)0.4f, y, z + h * 0.5, x + w * 0.5, y, z + h * (double)0.4f);
                ClientRender.add_grid_line(x + w * (double)0.4f, y, z + h * 0.5, x + w * 0.5, y, z + h * (double)0.6f);
                ClientRender.add_grid_line(x + w * (double)0.6f, y, z + h * 0.5, x + w * 0.5, y, z + h * (double)0.6f);
                ClientRender.add_grid_line(x + w * 0.5, y, z + h * (double)0.4f, x + w * (double)0.6f, y, z + h * 0.5);
                ClientRender.draw_lines(bufferBuilder, 0, 8, 0.0f, 0.7f, 0.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x + w * (double)0.1f, y, z + h * (double)0.1f, x + w * (double)0.2f, y, z + h * (double)0.14f);
                ClientRender.add_grid_line(x + w * (double)0.1f, y, z + h * (double)0.1f, x + w * (double)0.14f, y, z + h * (double)0.2f);
                ClientRender.add_grid_line(x + w * (double)0.9f, y, z + h * (double)0.9f, x + w * (double)0.8f, y, z + h * (double)0.86f);
                ClientRender.add_grid_line(x + w * (double)0.9f, y, z + h * (double)0.9f, x + w * (double)0.86f, y, z + h * (double)0.8f);
                ClientRender.add_grid_line(x + w * (double)0.9f, y, z + h * (double)0.1f, x + w * (double)0.8f, y, z + h * (double)0.14f);
                ClientRender.add_grid_line(x + w * (double)0.9f, y, z + h * (double)0.1f, x + w * (double)0.86f, y, z + h * (double)0.2f);
                ClientRender.add_grid_line(x + w * (double)0.1f, y, z + h * (double)0.9f, x + w * (double)0.2f, y, z + h * (double)0.86f);
                ClientRender.add_grid_line(x + w * (double)0.1f, y, z + h * (double)0.9f, x + w * (double)0.14f, y, z + h * (double)0.8f);
                ClientRender.draw_lines(bufferBuilder, 0, 16, 0.0f, 0.0f, 0.7f, 1.0f);
                break;
            }
            case SOUTH: 
            case NORTH: {
                w = aabb.m_82362_();
                h = aabb.m_82376_();
                x += aabb.f_82288_;
                y += aabb.f_82289_;
                z = side == Direction.SOUTH ? (z += aabb.f_82293_ + (double)o) : (z += aabb.f_82290_ - (double)o);
                w2 = w * 0.33333333;
                w3 = w * 0.66666666;
                h2 = h * 0.33333333;
                h3 = h * 0.66666666;
                grid_i = 0;
                ClientRender.add_grid_line(x, y, z, x + w, y, z);
                ClientRender.add_grid_line(x, y, z, x, y + h, z);
                ClientRender.add_grid_line(x + w, y, z, x + w, y + h, z);
                ClientRender.add_grid_line(x, y + h, z, x + w, y + h, z);
                ClientRender.add_grid_line(x, y + h2, z, x + w, y + h2, z);
                ClientRender.add_grid_line(x, y + h3, z, x + w, y + h3, z);
                ClientRender.add_grid_line(x + w2, y, z, x + w2, y + h, z);
                ClientRender.add_grid_line(x + w3, y, z, x + w3, y + h, z);
                ClientRender.draw_lines(bufferBuilder, 0, 16, 1.0f, 1.0f, 1.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x + w * (double)0.4f, y + h * (double)0.2f, z, x + w * 0.5, y + h * (double)0.05f, z);
                ClientRender.add_grid_line(x + w * (double)0.6f, y + h * (double)0.2f, z, x + w * 0.5, y + h * (double)0.05f, z);
                ClientRender.add_grid_line(x + w * (double)0.4f, y + h * (double)0.8f, z, x + w * 0.5, y + h * (double)0.95f, z);
                ClientRender.add_grid_line(x + w * (double)0.6f, y + h * (double)0.8f, z, x + w * 0.5, y + h * (double)0.95f, z);
                ClientRender.add_grid_line(x + w * (double)0.2f, y + h * (double)0.4f, z, x + w * (double)0.05f, y + h * 0.5, z);
                ClientRender.add_grid_line(x + w * (double)0.2f, y + h * (double)0.6f, z, x + w * (double)0.05f, y + h * 0.5, z);
                ClientRender.add_grid_line(x + w * (double)0.8f, y + h * (double)0.4f, z, x + w * (double)0.95f, y + h * 0.5, z);
                ClientRender.add_grid_line(x + w * (double)0.8f, y + h * (double)0.6f, z, x + w * (double)0.95f, y + h * 0.5, z);
                ClientRender.draw_lines(bufferBuilder, 0, 16, 0.7f, 0.0f, 0.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x + w * (double)0.4f, y + h * 0.5, z, x + w * 0.5, y + h * (double)0.4f, z);
                ClientRender.add_grid_line(x + w * (double)0.4f, y + h * 0.5, z, x + w * 0.5, y + h * (double)0.6f, z);
                ClientRender.add_grid_line(x + w * (double)0.6f, y + h * 0.5, z, x + w * 0.5, y + h * (double)0.6f, z);
                ClientRender.add_grid_line(x + w * 0.5, y + h * (double)0.4f, z, x + w * (double)0.6f, y + h * 0.5, z);
                ClientRender.draw_lines(bufferBuilder, 0, 8, 0.0f, 0.7f, 0.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x + w * (double)0.1f, y + h * (double)0.1f, z, x + w * (double)0.2f, y + h * (double)0.14f, z);
                ClientRender.add_grid_line(x + w * (double)0.1f, y + h * (double)0.1f, z, x + w * (double)0.14f, y + h * (double)0.2f, z);
                ClientRender.add_grid_line(x + w * (double)0.9f, y + h * (double)0.9f, z, x + w * (double)0.8f, y + h * (double)0.86f, z);
                ClientRender.add_grid_line(x + w * (double)0.9f, y + h * (double)0.9f, z, x + w * (double)0.86f, y + h * (double)0.8f, z);
                ClientRender.add_grid_line(x + w * (double)0.9f, y + h * (double)0.1f, z, x + w * (double)0.8f, y + h * (double)0.14f, z);
                ClientRender.add_grid_line(x + w * (double)0.9f, y + h * (double)0.1f, z, x + w * (double)0.86f, y + h * (double)0.2f, z);
                ClientRender.add_grid_line(x + w * (double)0.1f, y + h * (double)0.9f, z, x + w * (double)0.2f, y + h * (double)0.86f, z);
                ClientRender.add_grid_line(x + w * (double)0.1f, y + h * (double)0.9f, z, x + w * (double)0.14f, y + h * (double)0.8f, z);
                ClientRender.draw_lines(bufferBuilder, 0, 16, 0.0f, 0.0f, 0.7f, 1.0f);
                break;
            }
            case EAST: 
            case WEST: {
                y += aabb.f_82289_;
                z += aabb.f_82290_;
                x = side == Direction.EAST ? (x += aabb.f_82291_ + (double)o) : (x += aabb.f_82288_ - (double)o);
                w = aabb.m_82376_();
                h = aabb.m_82385_();
                w2 = w * 0.33333333;
                w3 = w * 0.66666666;
                h2 = h * 0.33333333;
                h3 = h * 0.66666666;
                grid_i = 0;
                ClientRender.add_grid_line(x, y, z, x, y + w, z);
                ClientRender.add_grid_line(x, y, z, x, y, z + h);
                ClientRender.add_grid_line(x, y + w, z, x, y + w, z + h);
                ClientRender.add_grid_line(x, y, z + h, x, y + w, z + h);
                ClientRender.add_grid_line(x, y, z + h2, x, y + w, z + h2);
                ClientRender.add_grid_line(x, y, z + h3, x, y + w, z + h3);
                ClientRender.add_grid_line(x, y + w2, z, x, y + w2, z + h);
                ClientRender.add_grid_line(x, y + w3, z, x, y + w3, z + h);
                ClientRender.draw_lines(bufferBuilder, 0, 16, 1.0f, 1.0f, 1.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x, y + w * (double)0.4f, z + h * (double)0.2f, x, y + w * 0.5, z + h * (double)0.05f);
                ClientRender.add_grid_line(x, y + w * (double)0.6f, z + h * (double)0.2f, x, y + w * 0.5, z + h * (double)0.05f);
                ClientRender.add_grid_line(x, y + w * (double)0.4f, z + h * (double)0.8f, x, y + w * 0.5, z + h * (double)0.95f);
                ClientRender.add_grid_line(x, y + w * (double)0.6f, z + h * (double)0.8f, x, y + w * 0.5, z + h * (double)0.95f);
                ClientRender.add_grid_line(x, y + w * (double)0.2f, z + h * (double)0.4f, x, y + w * (double)0.05f, z + h * 0.5);
                ClientRender.add_grid_line(x, y + w * (double)0.2f, z + h * (double)0.6f, x, y + w * (double)0.05f, z + h * 0.5);
                ClientRender.add_grid_line(x, y + w * (double)0.8f, z + h * (double)0.4f, x, y + w * (double)0.95f, z + h * 0.5);
                ClientRender.add_grid_line(x, y + w * (double)0.8f, z + h * (double)0.6f, x, y + w * (double)0.95f, z + h * 0.5);
                ClientRender.draw_lines(bufferBuilder, 0, 16, 0.7f, 0.0f, 0.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x, y + w * (double)0.4f, z + h * 0.5, x, y + w * 0.5, z + h * (double)0.4f);
                ClientRender.add_grid_line(x, y + w * (double)0.4f, z + h * 0.5, x, y + w * 0.5, z + h * (double)0.6f);
                ClientRender.add_grid_line(x, y + w * (double)0.6f, z + h * 0.5, x, y + w * 0.5, z + h * (double)0.6f);
                ClientRender.add_grid_line(x, y + w * 0.5, z + h * (double)0.4f, x, y + w * (double)0.6f, z + h * 0.5);
                ClientRender.draw_lines(bufferBuilder, 0, 8, 0.0f, 0.7f, 0.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x, y + w * (double)0.1f, z + h * (double)0.1f, x, y + w * (double)0.2f, z + h * (double)0.14f);
                ClientRender.add_grid_line(x, y + w * (double)0.1f, z + h * (double)0.1f, x, y + w * (double)0.14f, z + h * (double)0.2f);
                ClientRender.add_grid_line(x, y + w * (double)0.9f, z + h * (double)0.9f, x, y + w * (double)0.8f, z + h * (double)0.86f);
                ClientRender.add_grid_line(x, y + w * (double)0.9f, z + h * (double)0.9f, x, y + w * (double)0.86f, z + h * (double)0.8f);
                ClientRender.add_grid_line(x, y + w * (double)0.9f, z + h * (double)0.1f, x, y + w * (double)0.8f, z + h * (double)0.14f);
                ClientRender.add_grid_line(x, y + w * (double)0.9f, z + h * (double)0.1f, x, y + w * (double)0.86f, z + h * (double)0.2f);
                ClientRender.add_grid_line(x, y + w * (double)0.1f, z + h * (double)0.9f, x, y + w * (double)0.2f, z + h * (double)0.86f);
                ClientRender.add_grid_line(x, y + w * (double)0.1f, z + h * (double)0.9f, x, y + w * (double)0.14f, z + h * (double)0.8f);
                ClientRender.draw_lines(bufferBuilder, 0, 16, 0.0f, 0.0f, 0.7f, 1.0f);
            }
        }
    }

    static void render_shape(PoseStack matrixStack, Tesselator tesselator, BufferBuilder bufferBuilder, BlockState state, double x, double y, double z) {
        float u1 = 0.0f;
        float v1 = 0.0f;
        float u0 = 0.0f;
        float v0 = 0.0f;
        float r = ClientRender.block_col.r;
        float g = ClientRender.block_col.g;
        float b = ClientRender.block_col.b;
        float a = ClientRender.block_col.a;
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        bp.m_122169_(x, y, z);
        boolean is_water = state == Blocks.f_49990_.m_49966_();
        boolean is_lava = state == Blocks.f_49991_.m_49966_();
        boolean invalid = false;
        if (is_water || is_lava || ClientRender.wand.mode != WandProps.Mode.PASTE && ClientRender.wand.has_water_bucket && ClientRender.wand.level.m_8055_((BlockPos)bp).m_60795_()) {
            int i;
            TextureAtlasSprite sprite;
            water = true;
            float h = 0.875f;
            RenderSystem.m_69481_();
            if (is_water) {
                sprite = ModelBakery.f_119222_.m_119204_();
                i = BiomeColors.m_108811_((BlockAndTintGetter)ClientRender.wand.level, (BlockPos)bp);
            } else {
                sprite = ModelBakery.f_119221_.m_119204_();
                i = 0xFFFFFF;
            }
            r = (float)(i >> 16 & 0xFF) / 255.0f;
            g = (float)(i >> 8 & 0xFF) / 255.0f;
            b = (float)(i & 0xFF) / 255.0f;
            Compat.set_texture(TextureAtlas.f_118259_);
            int bf = LevelRenderer.m_109541_((BlockAndTintGetter)ClientRender.wand.level, (BlockPos)bp);
            u0 = sprite.m_118409_();
            v0 = sprite.m_118411_();
            u1 = sprite.m_118410_();
            v1 = sprite.m_118412_();
            float o = 0.1f;
            bufferBuilder.m_5483_(x + (double)o, y + (double)h - (double)o, z + (double)o).m_85950_(r, g, b, a).m_7421_(u1, v1).m_85969_(bf).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_(x + (double)o, y + (double)h - (double)o, z + 1.0 - (double)o).m_85950_(r, g, b, a).m_7421_(u1, v0).m_85969_(bf).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_(x + 1.0 - (double)o, y + (double)h - (double)o, z + 1.0 - (double)o).m_85950_(r, g, b, a).m_7421_(u0, v0).m_85969_(bf).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_(x + 1.0 - (double)o, y + (double)h - (double)o, z + (double)o).m_85950_(r, g, b, a).m_7421_(u0, v1).m_85969_(bf).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_(x + (double)o, y + (double)o, z + (double)o).m_85950_(r, g, b, a).m_7421_(u1, v1).m_85969_(bf).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_(x + 1.0 - (double)o, y + (double)o, z + (double)o).m_85950_(r, g, b, a).m_7421_(u0, v1).m_85969_(bf).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_(x + 1.0 - (double)o, y + (double)o, z + 1.0 - (double)o).m_85950_(r, g, b, a).m_7421_(u0, v0).m_85969_(bf).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_(x + (double)o, y + (double)o, z + 1.0 - (double)o).m_85950_(r, g, b, a).m_7421_(u1, v0).m_85969_(bf).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_(x + (double)o, y + (double)o, z + (double)o).m_85950_(r, g, b, a).m_7421_(u1, v1).m_85969_(bf).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_(x + (double)o, y + (double)h - (double)o, z + (double)o).m_85950_(r, g, b, a).m_7421_(u1, v0).m_85969_(bf).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_(x + 1.0 - (double)o, y + (double)h - (double)o, z + (double)o).m_85950_(r, g, b, a).m_7421_(u0, v0).m_85969_(bf).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_(x + 1.0 - (double)o, y + (double)o, z + (double)o).m_85950_(r, g, b, a).m_7421_(u0, v1).m_85969_(bf).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_(x + (double)o, y + (double)o, z + 1.0 - (double)o).m_85950_(r, g, b, a).m_7421_(u1, v1).m_85969_(bf).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_(x + 1.0 - (double)o, y + (double)o, z + 1.0 - (double)o).m_85950_(r, g, b, a).m_7421_(u0, v1).m_85969_(bf).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_(x + 1.0 - (double)o, y + (double)h - (double)o, z + 1.0 - (double)o).m_85950_(r, g, b, a).m_7421_(u0, v0).m_85969_(bf).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_(x + (double)o, y + (double)h - (double)o, z + 1.0 - (double)o).m_85950_(r, g, b, a).m_7421_(u1, v0).m_85969_(bf).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_(x + (double)o, y + (double)o, z + (double)o).m_85950_(r, g, b, a).m_7421_(u0, v1).m_85969_(bf).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_(x + (double)o, y + (double)o, z + 1.0 - (double)o).m_85950_(r, g, b, a).m_7421_(u1, v1).m_85969_(bf).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_(x + (double)o, y + (double)h - (double)o, z + 1.0 - (double)o).m_85950_(r, g, b, a).m_7421_(u1, v0).m_85969_(bf).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_(x + (double)o, y + (double)h - (double)o, z + (double)o).m_85950_(r, g, b, a).m_7421_(u0, v0).m_85969_(bf).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_(x + 1.0 - (double)o, y + (double)o, z + (double)o).m_85950_(r, g, b, a).m_7421_(u0, v1).m_85969_(bf).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_(x + 1.0 - (double)o, y + (double)h - (double)o, z + (double)o).m_85950_(r, g, b, a).m_7421_(u0, v0).m_85969_(bf).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_(x + 1.0 - (double)o, y + (double)h - (double)o, z + 1.0 - (double)o).m_85950_(r, g, b, a).m_7421_(u1, v0).m_85969_(bf).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_(x + 1.0 - (double)o, y + (double)o, z + 1.0 - (double)o).m_85950_(r, g, b, a).m_7421_(u1, v1).m_85969_(bf).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            return;
        }
        try {
            BakedModel bakedModel = blockRenderer.m_110910_(state);
            if (bakedModel != null) {
                if (!state.m_60710_((LevelReader)ClientRender.client.f_91073_, (BlockPos)bp)) {
                    r = 1.0f;
                    g = 0.0f;
                    b = 0.0f;
                    invalid = true;
                }
                for (Direction dir : dirs) {
                    List bake_list = bakedModel.m_213637_(state, dir, random);
                    if (bake_list == null || bake_list.isEmpty()) continue;
                    Compat.set_identity(matrixStack2);
                    if (ClientRender.wand.replace && ClientRender.wand.mode != WandProps.Mode.COPY) {
                        Vec3i n = ClientRender.wand.side.m_122436_();
                        matrixStack2.m_85837_(x + (double)(0.5f * (1.0f - (float)n.m_123341_())) + (double)n.m_123341_(), y + (double)(0.5f * (1.0f - (float)n.m_123342_())) + (double)n.m_123342_(), z + (double)(0.5f * (1.0f - (float)n.m_123343_())) + (double)n.m_123343_());
                        matrixStack2.m_85841_(0.5f, 0.5f, 0.5f);
                        matrixStack2.m_252880_(-0.5f, -0.5f, -0.5f);
                    } else {
                        matrixStack2.m_85837_(x, y, z);
                    }
                    for (BakedQuad quad : bake_list) {
                        if (!ClientRender.wand.replace && !Compat.shouldRenderFace(state, (BlockGetter)ClientRender.wand.level, (BlockPos)bp, quad.m_111306_(), (BlockPos)bp)) continue;
                        Compat.set_texture(TextureAtlas.f_118259_);
                        int[] verts = quad.m_111303_();
                        int n = verts.length / 4;
                        int ii = -1;
                        if (!invalid) {
                            if (quad.m_111304_()) {
                                ii = state.m_60734_() instanceof GrassBlock ? BiomeColors.m_108793_((BlockAndTintGetter)ClientRender.wand.level, (BlockPos)bp) : (state.m_60734_() instanceof LeavesBlock ? BiomeColors.m_108804_((BlockAndTintGetter)ClientRender.wand.level, (BlockPos)bp) : client.m_91298_().m_92582_(state, ClientRender.wand.level, last_pos));
                                r = (float)(ii >> 16 & 0xFF) / 255.0f;
                                g = (float)(ii >> 8 & 0xFF) / 255.0f;
                                b = (float)(ii & 0xFF) / 255.0f;
                            } else {
                                r = ClientRender.block_col.r;
                                g = ClientRender.block_col.g;
                                b = ClientRender.block_col.b;
                            }
                        }
                        float f = ClientRender.wand.level.m_7717_(quad.m_111306_(), quad.m_111307_());
                        bufferBuilder.m_85995_(matrixStack2.m_85850_(), quad, new float[]{f, f, f, f}, r, g, b, new int[]{-1, -1, -1, -1}, n, true);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void update_colors() {
        bo_col.fromColor(WandsConfig.c_block_outline);
        bbox_col.fromColor(WandsConfig.c_bounding_box);
        destroy_col.fromColor(WandsConfig.c_destroy);
        tool_use_col.fromColor(WandsConfig.c_tool_use);
        start_col.fromColor(WandsConfig.c_start);
        end_col.fromColor(WandsConfig.c_end);
        paste_bb_col.fromColor(WandsConfig.c_paste_bb);
        block_col.fromColor(WandsConfig.c_block);
        line_col.fromColor(WandsConfig.c_line);
    }

    static {
        last_pos = null;
        last_side = null;
        last_rot = Rotation.NONE;
        last_alt = false;
        last_buffer_size = -1;
        last_orientation = null;
        wand = new Wand();
        preview_shape = null;
        def_aabb = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        grid_i = 0;
        grid_vx = new double[16];
        grid_vy = new double[16];
        grid_vz = new double[16];
        force = false;
        x1 = 0.0f;
        y1 = 0.0f;
        z1 = 0.0f;
        x2 = 0.0f;
        y2 = 0.0f;
        z2 = 0.0f;
        opacity = 0.8f;
        fancy = true;
        fat_lines = true;
        drawlines = true;
        block_outlines = false;
        fill_outlines = false;
        copy_outlines = false;
        paste_outlines = false;
        fat_lines_width = 0.05f;
        GRID_TEXTURE = new ResourceLocation("wands", "textures/blocks/grid.png");
        LINE_TEXTURE = new ResourceLocation("wands", "textures/blocks/line.png");
        random = RandomSource.m_216327_();
        dirs = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, null};
        update_colors = true;
        block_col = new Colorf(1.0f, 1.0f, 1.0f, 1.0f);
        bo_col = new Colorf(1.0f, 1.0f, 1.0f, 1.0f);
        bbox_col = new Colorf(0.0f, 0.0f, 1.0f, 1.0f);
        destroy_col = new Colorf(1.0f, 0.0f, 0.0f, 1.0f);
        tool_use_col = new Colorf(0.0f, 1.0f, 1.0f, 1.0f);
        start_col = new Colorf(1.0f, 1.0f, 0.0f, 1.0f);
        end_col = new Colorf(1.0f, 1.0f, 0.0f, 1.0f);
        line_col = new Colorf(1.0f, 0.0f, 1.0f, 1.0f);
        paste_bb_col = new Colorf(0.0f, 0.0f, 0.0f, 1.0f);
        has_target = false;
        matrixStack2 = new PoseStack();
        bp = new BlockPos.MutableBlockPos();
        water = false;
        AIR = Blocks.f_50016_.m_49966_();
        mirroraxis = 0;
    }

    public static enum Colors {
        BLOCK_OUTLINE,
        BOUNDING_BOX,
        DESTROY,
        TOOL_USE,
        START,
        END,
        LINE,
        PASTE_BB,
        BlOCK;

    }
}

