/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.items;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.client.render.ClientRender;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.wand.PlayerWand;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandProps;
import org.jetbrains.annotations.Nullable;

public class WandItem
extends TieredItem
implements Vanishable {
    public int limit = 0;
    public boolean can_blast;
    public boolean unbreakable;
    public boolean removes_water;
    public boolean removes_lava;

    public WandItem(Tier tier, int limit, boolean removes_water, boolean removes_lava, boolean unbreakable, boolean can_blast, Item.Properties properties) {
        super(tier, properties);
        this.limit = limit;
        this.removes_lava = removes_lava;
        this.removes_water = removes_water;
        this.unbreakable = unbreakable;
        this.can_blast = can_blast;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        Wand wand = null;
        if (!world.m_5776_()) {
            wand = PlayerWand.get(context.m_43723_());
            if (wand == null) {
                PlayerWand.add_player(context.m_43723_());
                wand = PlayerWand.get(context.m_43723_());
                if (wand == null) {
                    return InteractionResult.FAIL;
                }
            }
        } else {
            wand = ClientRender.wand;
        }
        wand.force_render = true;
        ItemStack stack = context.m_43723_().m_21205_();
        if (!wand.is_alt_pressed && stack != null && !stack.m_41619_() && stack.m_41720_() instanceof WandItem) {
            Vec3 hit = context.m_43720_();
            BlockPos pos = context.m_8083_();
            Direction side = context.m_43719_();
            BlockState block_state = world.m_8055_(pos);
            WandProps.Mode mode = WandProps.getMode(stack);
            if (mode == WandProps.Mode.FILL || mode == WandProps.Mode.LINE || mode == WandProps.Mode.CIRCLE || mode == WandProps.Mode.COPY) {
                if (WandProps.getFlag(stack, WandProps.Flag.INCSELBLOCK)) {
                    pos = pos.m_5484_(side, 1);
                }
                if (mode == WandProps.Mode.COPY) {
                    if (wand.copy_pos1 == null) {
                        wand.copy_pos1 = pos;
                        return InteractionResult.SUCCESS;
                    }
                    wand.copy_pos2 = pos;
                } else {
                    if (wand.p1 == null) {
                        wand.p1_state = block_state;
                        wand.p2 = false;
                        wand.p1 = pos;
                        wand.x1 = pos.m_123341_();
                        wand.y1 = pos.m_123342_();
                        wand.z1 = pos.m_123343_();
                        return InteractionResult.SUCCESS;
                    }
                    block_state = wand.p1_state;
                    wand.p2 = true;
                }
            }
            wand.lastPlayerDirection = context.m_43723_().m_6350_();
            wand.do_or_preview(context.m_43723_(), world, block_state, pos, side, hit, stack, true);
            if (!world.m_5776_()) {
                wand.palette.seed = world.f_46441_.m_188503_(20000000);
                WandsMod.send_state((ServerPlayer)context.m_43723_(), wand);
            }
            if (mode == WandProps.Mode.COPY && wand.copy_pos1 != null && wand.copy_pos2 != null) {
                wand.copy_pos1 = null;
                wand.copy_pos2 = null;
            }
        } else if (world.m_5776_()) {
            this.send_placement(wand);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand interactionHand) {
        Wand wand = null;
        if (!world.m_5776_()) {
            wand = PlayerWand.get(player);
            if (wand == null) {
                PlayerWand.add_player(player);
                wand = PlayerWand.get(player);
                if (wand == null) {
                    return InteractionResultHolder.m_19100_((Object)player.m_21120_(interactionHand));
                }
            }
        } else {
            wand = ClientRender.wand;
            wand.force_render = true;
            if (wand.is_alt_pressed) {
                this.send_placement(wand);
            }
        }
        if (!wand.is_alt_pressed) {
            wand.clear();
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(interactionHand));
    }

    public void send_placement(Wand wand) {
        Minecraft client = Minecraft.m_91087_();
        if (client.m_91403_() != null && wand.lastHitResult != null) {
            FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
            packet.m_130062_(wand.lastHitResult);
            if (wand.p1 != null) {
                packet.m_130064_(wand.p1);
            } else {
                packet.m_130064_(wand.lastHitResult.m_82425_());
            }
            if ((wand.mode == WandProps.Mode.FILL || wand.mode == WandProps.Mode.LINE || wand.mode == WandProps.Mode.CIRCLE || wand.mode == WandProps.Mode.COPY) && ClientRender.last_pos != null) {
                wand.p2 = true;
            }
            packet.m_130064_(ClientRender.last_pos);
            packet.writeBoolean(wand.p2);
            packet.writeInt(ClientRender.wand.lastPlayerDirection.ordinal());
            NetworkManager.sendToServer((ResourceLocation)WandsMod.POS_PACKET, (FriendlyByteBuf)packet);
        }
    }

    public static boolean has_tools(ItemStack stack) {
        ListTag tag = stack.m_41784_().m_128437_("Tools", 10);
        for (int i = 0; i < tag.size() && i < 9; ++i) {
            CompoundTag stackTag = (CompoundTag)tag.get(i);
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)stackTag.m_128469_("Tool"));
            if (itemStack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        CompoundTag tag = stack.m_41784_();
        list.add((Component)Compat.literal("mode: " + WandProps.getMode(stack).toString()));
        list.add((Component)Compat.literal("limit: " + this.limit));
        list.add((Component)Compat.literal("orientation: " + WandProps.orientations[tag.m_128451_("orientation")].toString()));
        int a = tag.m_128451_("axis");
        if (a < WandProps.axes.length) {
            list.add((Component)Compat.literal("axis: " + WandProps.axes[a].toString()));
        } else {
            list.add((Component)Compat.literal("axis: none"));
        }
        list.add((Component)Compat.literal("plane: " + WandProps.Plane.values()[tag.m_128451_("plane")].toString()));
        list.add((Component)Compat.literal("fill circle: " + tag.m_128471_("cfill")));
        list.add((Component)Compat.literal("rotation: " + tag.m_128451_("rotation")));
    }

    public int m_6473_() {
        return this.m_43314_().m_6601_();
    }
}

