/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.wand;

import java.util.Map;
import java.util.Vector;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nicguzzo.wands.items.PaletteItem;
import net.nicguzzo.wands.wand.BlockAccounting;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandProps;

public class Palette {
    public ItemStack item = null;
    public boolean has_palette = false;
    public int slot = 0;
    public volatile long seed = System.currentTimeMillis();
    public Vector<PaletteSlot> palette_slots = new Vector();

    void update_palette(Map<Item, BlockAccounting> block_accounting) {
        this.slot = 0;
        if (this.item != null && this.item.m_41720_() instanceof PaletteItem) {
            this.palette_slots.clear();
            ListTag palette_inv = this.item.m_41784_().m_128437_("Palette", 10);
            int s = palette_inv.size();
            for (int i = 0; i < s; ++i) {
                Block blk;
                CompoundTag stackTag = (CompoundTag)palette_inv.get(i);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)stackTag.m_128469_("Block"));
                if (stack.m_41619_() || (blk = Block.m_49814_((Item)stack.m_41720_())) == Blocks.f_50016_) continue;
                PaletteSlot psl = new PaletteSlot(i, blk.m_49966_(), stack);
                if (this.palette_slots.stream().noneMatch(pp -> pp.stack.m_41656_(stack))) {
                    block_accounting.put(stack.m_41720_(), new BlockAccounting());
                }
                this.palette_slots.add(psl);
            }
        }
    }

    public BlockState get_state(Wand wand) {
        BlockState st = wand.block_state;
        if (this.palette_slots.size() > 0) {
            PaletteItem.PaletteMode palette_mode = PaletteItem.getMode(this.item);
            int bound = this.palette_slots.size();
            if (palette_mode == PaletteItem.PaletteMode.RANDOM) {
                this.slot = wand.random.m_188503_(bound);
            }
            PaletteSlot ps = this.palette_slots.get(this.slot);
            if (!(palette_mode != PaletteItem.PaletteMode.ROUND_ROBIN || wand.mode == WandProps.Mode.DIRECTION && wand.level.m_5776_())) {
                this.slot = (this.slot + 1) % bound;
            }
            st = ps.state;
            Block blk = st.m_60734_();
            if (palette_mode == PaletteItem.PaletteMode.RANDOM && blk instanceof SnowLayerBlock) {
                int sn = wand.random.m_188503_(7);
                st = (BlockState)st.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(sn + 1));
            }
            st = wand.state_for_placement(st, null);
            if (PaletteItem.getRotate(this.item)) {
                st = ps.state.m_60734_().m_6843_(ps.state, Rotation.m_221990_((RandomSource)wand.random));
            }
        }
        return st;
    }

    public boolean state_in_slot(BlockState bs) {
        boolean cond = false;
        if (this.has_palette) {
            for (PaletteSlot slot : this.palette_slots) {
                if (!bs.equals(slot.state)) continue;
                cond = true;
                break;
            }
        }
        return cond;
    }

    public static class PaletteSlot {
        public ItemStack stack;
        public BlockState state;
        public int slot;

        PaletteSlot(int s, BlockState b, ItemStack stk) {
            this.slot = s;
            this.state = b;
            this.stack = stk;
        }
    }
}

