/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.wand;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.items.WandItem;
import net.nicguzzo.wands.utils.WandUtils;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandMode;
import net.nicguzzo.wands.wand.modes.AreaMode;
import net.nicguzzo.wands.wand.modes.BlastMode;
import net.nicguzzo.wands.wand.modes.CircleMode;
import net.nicguzzo.wands.wand.modes.CopyMode;
import net.nicguzzo.wands.wand.modes.DirectionMode;
import net.nicguzzo.wands.wand.modes.FillMode;
import net.nicguzzo.wands.wand.modes.GridMode;
import net.nicguzzo.wands.wand.modes.LineMode;
import net.nicguzzo.wands.wand.modes.PasteMode;
import net.nicguzzo.wands.wand.modes.RowColMode;
import net.nicguzzo.wands.wand.modes.VeinMode;

public class WandProps {
    public static Mode[] modes = Mode.values();
    public static Action[] actions = Action.values();
    public static Orientation[] orientations = Orientation.values();
    public static Plane[] planes = Plane.values();
    public static Direction.Axis[] axes = Direction.Axis.values();
    public static Rotation[] rotations = Rotation.values();
    public static StateMode[] state_modes = StateMode.values();
    public static MirrorAxis[] mirrorAxes = MirrorAxis.values();

    public static boolean getFlag(ItemStack stack, Flag flag) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128441_(flag.toString())) {
                return tag.m_128471_(flag.toString());
            }
            tag.m_128379_(flag.toString(), flag.get_default());
            return flag.get_default();
        }
        return false;
    }

    public static void setFlag(ItemStack stack, Flag flag, boolean f) {
        if (WandUtils.is_wand(stack)) {
            stack.m_41784_().m_128379_(flag.toString(), f);
        }
    }

    public static void toggleFlag(ItemStack stack, Flag flag) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            boolean b = WandProps.getFlag(stack, flag);
            tag.m_128379_(flag.toString(), !b);
        }
    }

    public static void setVal(ItemStack stack, Value v, int n) {
        if (WandUtils.is_wand(stack)) {
            stack.m_41784_().m_128405_(v.toString(), n);
        }
    }

    public static void incVal(ItemStack stack, Value v, int inc, int max) {
        int n;
        if (WandUtils.is_wand(stack) && (n = stack.m_41784_().m_128451_(v.toString())) + inc <= max) {
            stack.m_41784_().m_128405_(v.toString(), n + inc);
        }
    }

    public static void incVal(ItemStack stack, Value v, int inc) {
        WandProps.incVal(stack, v, inc, v.max);
    }

    public static void decVal(ItemStack stack, Value v, int inc, int min) {
        int n;
        if (WandUtils.is_wand(stack) && (n = stack.m_41784_().m_128451_(v.toString())) - inc >= min) {
            stack.m_41784_().m_128405_(v.toString(), n - inc);
        }
    }

    public static void decVal(ItemStack stack, Value v, int dec) {
        WandProps.decVal(stack, v, dec, v.min);
    }

    public static int getVal(ItemStack stack, Value v) {
        if (WandUtils.is_wand(stack)) {
            int i = stack.m_41784_().m_128451_(v.toString());
            if (i < v.min) {
                return v.min;
            }
            if (i > v.max) {
                return v.max;
            }
            return i;
        }
        return -1;
    }

    public static Mode getMode(ItemStack stack) {
        int m;
        if (WandUtils.is_wand(stack) && (m = stack.m_41784_().m_128451_("mode")) >= 0 && m < modes.length) {
            return modes[m];
        }
        return Mode.DIRECTION;
    }

    public static void setMode(ItemStack stack, Mode mode) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_("mode", mode.ordinal());
        }
    }

    public static void nextMode(ItemStack stack) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            int mode = (tag.m_128451_("mode") + 1) % modes.length;
            WandItem wand = (WandItem)stack.m_41720_();
            if (mode == Mode.VEIN.ordinal() && !WandsMod.config.enable_vein_mode) {
                mode = Mode.BLAST.ordinal();
            }
            if (!wand.can_blast && mode == Mode.BLAST.ordinal() || !WandsMod.config.enable_blast_mode && mode == Mode.BLAST.ordinal()) {
                mode = Mode.DIRECTION.ordinal();
            }
            tag.m_128405_("mode", mode);
        }
    }

    public static void prevMode(ItemStack stack) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            int mode = tag.m_128451_("mode") - 1;
            if (mode < 0) {
                mode = modes.length - 1;
            }
            WandItem wand = (WandItem)stack.m_41720_();
            if (!wand.can_blast && mode == Mode.BLAST.ordinal() || !WandsMod.config.enable_blast_mode && mode == Mode.BLAST.ordinal()) {
                mode = Mode.BLAST.ordinal() - 1;
            }
            if (mode == Mode.VEIN.ordinal() && !WandsMod.config.enable_vein_mode) {
                mode = Mode.VEIN.ordinal() - 1;
            }
            tag.m_128405_("mode", mode);
        }
    }

    public static Orientation getOrientation(ItemStack stack) {
        if (WandUtils.is_wand(stack)) {
            int o = stack.m_41784_().m_128451_("orientation");
            return orientations[o];
        }
        return Orientation.ROW;
    }

    public static void setOrientation(ItemStack stack, Orientation o) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_("orientation", o.ordinal());
        }
    }

    public static void nextOrientation(ItemStack stack) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            int o = (tag.m_128451_("orientation") + 1) % 2;
            tag.m_128405_("orientation", o);
        }
    }

    public static Plane getPlane(ItemStack stack) {
        int p;
        Plane plane = Plane.XZ;
        if (WandUtils.is_wand(stack) && (p = stack.m_41784_().m_128451_("plane")) >= 0 && p < planes.length) {
            plane = planes[p];
        }
        return plane;
    }

    public static void setPlane(ItemStack stack, Plane p) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_("plane", p.ordinal());
        }
    }

    public static void nextPlane(ItemStack stack) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            int plane = (tag.m_128451_("plane") + 1) % 3;
            tag.m_128405_("plane", plane);
        }
    }

    public static Rotation getRotation(ItemStack stack) {
        if (WandUtils.is_wand(stack)) {
            return rotations[stack.m_41784_().m_128451_("rotation")];
        }
        return Rotation.NONE;
    }

    public static void nextRotation(ItemStack stack) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            int rot = (tag.m_128451_("rotation") + 1) % rotations.length;
            tag.m_128405_("rotation", rot);
        }
    }

    public static void setRotation(ItemStack stack, Rotation rot) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_("rotation", rot.ordinal());
        }
    }

    public static Action getAction(ItemStack stack) {
        int m;
        if (WandUtils.is_wand(stack) && (m = stack.m_41784_().m_128451_("action")) < actions.length) {
            return actions[m];
        }
        return Action.PLACE;
    }

    public static void setAction(ItemStack stack, Action a) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_("action", a.ordinal());
        }
    }

    public static void nextAction(ItemStack stack) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            int a = (tag.m_128451_("action") + 1) % actions.length;
            tag.m_128405_("action", a);
        }
    }

    public static void prevAction(ItemStack stack) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            int a = tag.m_128451_("action") - 1;
            if (a < 0) {
                a = actions.length - 1;
            }
            tag.m_128405_("action", a);
        }
    }

    public static Direction.Axis getAxis(ItemStack stack) {
        int p;
        Direction.Axis axis = Direction.Axis.Y;
        if (WandUtils.is_wand(stack) && (p = stack.m_41784_().m_128451_("axis")) >= 0 && p < axes.length) {
            axis = axes[p];
        }
        return axis;
    }

    public static void setAxis(ItemStack stack, Direction.Axis axis) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_("axis", axis.ordinal());
        }
    }

    public static void setAxis(ItemStack stack, int a) {
        if (stack != null && WandUtils.is_wand(stack) && !stack.m_41619_()) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_("axis", a);
        }
    }

    public static void nextAxis(ItemStack stack) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            int axis = (tag.m_128451_("axis") + 1) % 3;
            tag.m_128405_("axis", axis);
        }
    }

    public static StateMode getStateMode(ItemStack stack) {
        int m;
        if (WandUtils.is_wand(stack) && (m = stack.m_41784_().m_128451_("state_mode")) < state_modes.length) {
            return state_modes[m];
        }
        return StateMode.TARGET;
    }

    public static void setStateMode(ItemStack stack, StateMode mode) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_("state_mode", mode.ordinal());
        }
    }

    public static void incGrid(ItemStack stack, Value v, int n) {
        if (WandUtils.is_wand(stack)) {
            int c;
            CompoundTag tag = stack.m_41784_();
            WandItem w = (WandItem)stack.m_41720_();
            if (v.coval != null && (c = stack.m_41784_().m_128451_(v.coval.toString())) * n <= w.limit) {
                int nn = stack.m_41784_().m_128451_(v.toString());
                tag.m_128405_(v.toString(), nn + n);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Flag {
        INVERTED{

            public String toString() {
                return "inverted";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        CFILLED{

            public String toString() {
                return "cfill";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        EVEN{

            public String toString() {
                return "circle_even";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        DIAGSPREAD{

            public String toString() {
                return "diag_spread";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        MATCHSTATE{

            public String toString() {
                return "match_state";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        INCSELBLOCK{

            public String toString() {
                return "inc_sel_block";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        STAIRSLAB{

            public String toString() {
                return "stair_slab";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        RFILLED{

            public String toString() {
                return "rfill";
            }

            @Override
            public boolean get_default() {
                return true;
            }
        };


        public abstract boolean get_default();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Value {
        MULTIPLIER{

            public String toString() {
                return "multiplier";
            }
        }
        ,
        ROWCOLLIM{

            public String toString() {
                return "row_col_limit";
            }
        }
        ,
        AREALIM{

            public String toString() {
                return "area_limit";
            }
        }
        ,
        BLASTRAD{

            public String toString() {
                return "blast_radius";
            }
        }
        ,
        GRIDM{

            public String toString() {
                return "grid_m";
            }
        }
        ,
        GRIDN{

            public String toString() {
                return "grid_n";
            }
        }
        ,
        GRIDMS{

            public String toString() {
                return "grid_msp";
            }
        }
        ,
        GRIDNS{

            public String toString() {
                return "grid_nsp";
            }
        }
        ,
        GRIDMOFF{

            public String toString() {
                return "grid_moff";
            }
        }
        ,
        GRIDNOFF{

            public String toString() {
                return "grid_noff";
            }
        }
        ,
        MIRRORAXIS{

            public String toString() {
                return "mirror_axis";
            }
        }
        ,
        SKIPBLOCK{

            public String toString() {
                return "skip_block";
            }
        };

        public int def = 0;
        public int min = 0;
        public int max = Wand.MAX_LIMIT;
        public Value coval = null;

        static {
            Value.MULTIPLIER.def = 1;
            Value.MULTIPLIER.min = 1;
            Value.MULTIPLIER.max = 16;
            Value.ROWCOLLIM.def = 0;
            Value.ROWCOLLIM.min = 0;
            Value.BLASTRAD.def = 4;
            Value.BLASTRAD.min = 4;
            Value.BLASTRAD.max = 16;
            Value.GRIDM.coval = GRIDN;
            Value.GRIDN.coval = GRIDM;
            Value.GRIDM.min = 1;
            Value.GRIDN.min = 1;
            Value.MIRRORAXIS.min = 0;
            Value.MIRRORAXIS.max = 3;
            Value.SKIPBLOCK.max = 100;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Mode {
        DIRECTION{

            public String toString() {
                return "Direction";
            }

            @Override
            public WandMode get_mode() {
                return new DirectionMode();
            }
        }
        ,
        ROW_COL{

            public String toString() {
                return "Row/Column";
            }

            @Override
            public WandMode get_mode() {
                return new RowColMode();
            }
        }
        ,
        FILL{

            public String toString() {
                return "Fill";
            }

            @Override
            public WandMode get_mode() {
                return new FillMode();
            }
        }
        ,
        AREA{

            public String toString() {
                return "Area";
            }

            @Override
            public WandMode get_mode() {
                return new AreaMode();
            }
        }
        ,
        GRID{

            public String toString() {
                return "Grid";
            }

            @Override
            public WandMode get_mode() {
                return new GridMode();
            }
        }
        ,
        LINE{

            public String toString() {
                return "Line";
            }

            @Override
            public WandMode get_mode() {
                return new LineMode();
            }
        }
        ,
        CIRCLE{

            public String toString() {
                return "Circle";
            }

            @Override
            public WandMode get_mode() {
                return new CircleMode();
            }
        }
        ,
        COPY{

            public String toString() {
                return "Copy";
            }

            @Override
            public WandMode get_mode() {
                return new CopyMode();
            }
        }
        ,
        PASTE{

            public String toString() {
                return "Paste";
            }

            @Override
            public WandMode get_mode() {
                return new PasteMode();
            }
        }
        ,
        VEIN{

            public String toString() {
                return "Vein";
            }

            @Override
            public WandMode get_mode() {
                return new VeinMode();
            }
        }
        ,
        BLAST{

            public String toString() {
                return "Blast";
            }

            @Override
            public WandMode get_mode() {
                return new BlastMode();
            }
        };


        public abstract WandMode get_mode();
    }

    public static enum Orientation {
        ROW,
        COL;

    }

    public static enum Plane {
        XZ,
        XY,
        YZ;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Action {
        PLACE{

            public String toString() {
                return "Place";
            }
        }
        ,
        REPLACE{

            public String toString() {
                return "Replace";
            }
        }
        ,
        DESTROY{

            public String toString() {
                return "Destroy";
            }
        }
        ,
        USE{

            public String toString() {
                return "Use";
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum StateMode {
        CLONE{

            public String toString() {
                return "Clone";
            }
        }
        ,
        APPLY{

            public String toString() {
                return "Apply rotaion/axis";
            }
        }
        ,
        TARGET{

            public String toString() {
                return "Use Target";
            }
        };

    }

    public static enum MirrorAxis {
        NONE,
        X,
        Y,
        Z;

    }
}

