/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.client;

import com.github.alexthe666.citadel.client.event.EventGetOutlineColor;
import com.github.alexthe668.domesticationinnovation.DomesticationMod;
import com.github.alexthe668.domesticationinnovation.client.DiscJockeySound;
import com.github.alexthe668.domesticationinnovation.client.particle.ParticleBlight;
import com.github.alexthe668.domesticationinnovation.client.particle.ParticleDeflectionShield;
import com.github.alexthe668.domesticationinnovation.client.particle.ParticleGiantPop;
import com.github.alexthe668.domesticationinnovation.client.particle.ParticleIntimidation;
import com.github.alexthe668.domesticationinnovation.client.particle.ParticleLanternBugs;
import com.github.alexthe668.domesticationinnovation.client.particle.ParticleMagnet;
import com.github.alexthe668.domesticationinnovation.client.particle.ParticlePsychicWall;
import com.github.alexthe668.domesticationinnovation.client.particle.ParticleSimpleBubble;
import com.github.alexthe668.domesticationinnovation.client.particle.ParticleSniff;
import com.github.alexthe668.domesticationinnovation.client.particle.ParticleVampire;
import com.github.alexthe668.domesticationinnovation.client.particle.ParticleZZZ;
import com.github.alexthe668.domesticationinnovation.client.render.ChainLightningRender;
import com.github.alexthe668.domesticationinnovation.client.render.LayerManager;
import com.github.alexthe668.domesticationinnovation.client.render.OreColorRegistry;
import com.github.alexthe668.domesticationinnovation.client.render.RecallBallRender;
import com.github.alexthe668.domesticationinnovation.client.render.RenderFeather;
import com.github.alexthe668.domesticationinnovation.client.render.RenderGiantBubble;
import com.github.alexthe668.domesticationinnovation.client.render.RenderHighlightedBlock;
import com.github.alexthe668.domesticationinnovation.client.render.RenderJukeboxFollower;
import com.github.alexthe668.domesticationinnovation.client.render.RenderPsychicWall;
import com.github.alexthe668.domesticationinnovation.server.CommonProxy;
import com.github.alexthe668.domesticationinnovation.server.entity.DIEntityRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.FeatherEntity;
import com.github.alexthe668.domesticationinnovation.server.entity.FollowingJukeboxEntity;
import com.github.alexthe668.domesticationinnovation.server.entity.HighlightedBlockEntity;
import com.github.alexthe668.domesticationinnovation.server.entity.TameableUtils;
import com.github.alexthe668.domesticationinnovation.server.item.DIItemRegistry;
import com.github.alexthe668.domesticationinnovation.server.item.DeedOfOwnershipItem;
import com.github.alexthe668.domesticationinnovation.server.item.FeatherOnAStickItem;
import com.github.alexthe668.domesticationinnovation.server.misc.DIParticleRegistry;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientProxy
extends CommonProxy {
    public static final Map<Integer, DiscJockeySound> DISC_JOCKEY_SOUND_MAP = new HashMap<Integer, DiscJockeySound>();
    public static Map<Entity, int[]> shadowPunchRenderData = new HashMap<Entity, int[]>();

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        ImmutableList entityTypes = ImmutableList.copyOf((Collection)ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(LayerManager::canApply).filter(DefaultAttributes::m_22301_).map(entityType -> entityType).collect(Collectors.toList()));
        entityTypes.forEach(entityType -> LayerManager.addLayerIfApplicable((EntityType<? extends LivingEntity>)entityType, event));
    }

    public static float getNametagOffset() {
        return ModList.get().isLoaded("neat") ? 0.5f : 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientProxy::onAddLayers);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientProxy::setupParticles);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        EntityRenderers.m_174036_((EntityType)((EntityType)DIEntityRegistry.CHAIN_LIGHTNING.get()), ChainLightningRender::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)DIEntityRegistry.RECALL_BALL.get()), RecallBallRender::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)DIEntityRegistry.FEATHER.get()), RenderFeather::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)DIEntityRegistry.GIANT_BUBBLE.get()), RenderGiantBubble::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)DIEntityRegistry.FOLLOWING_JUKEBOX.get()), RenderJukeboxFollower::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)DIEntityRegistry.HIGHLIGHTED_BLOCK.get()), RenderHighlightedBlock::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)DIEntityRegistry.PSYCHIC_WALL.get()), RenderPsychicWall::new);
        ItemProperties.register((Item)((Item)DIItemRegistry.FEATHER_ON_A_STICK.get()), (ResourceLocation)new ResourceLocation("cast"), (stack, lvl, holder, i) -> {
            boolean flag1;
            if (holder == null) {
                return 0.0f;
            }
            boolean flag = holder.m_21205_() == stack;
            boolean bl = flag1 = holder.m_21206_() == stack;
            if (holder.m_21205_().m_41720_() instanceof FeatherOnAStickItem) {
                flag1 = false;
            }
            return (flag || flag1) && holder instanceof Player && ((Player)holder).f_36083_ instanceof FeatherEntity ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)((Item)DIItemRegistry.DEED_OF_OWNERSHIP.get()), (ResourceLocation)new ResourceLocation("bound"), (stack, lvl, holder, i) -> DeedOfOwnershipItem.isBound(stack) ? 1.0f : 0.0f);
    }

    public static void setupParticles(RegisterParticleProvidersEvent event) {
        DomesticationMod.LOGGER.debug("Registered particle factories");
        event.register((ParticleType)DIParticleRegistry.DEFLECTION_SHIELD.get(), (ParticleProvider)new ParticleDeflectionShield.Factory());
        event.register((ParticleType)DIParticleRegistry.MAGNET.get(), ParticleMagnet.Factory::new);
        event.register((ParticleType)DIParticleRegistry.ZZZ.get(), ParticleZZZ.Factory::new);
        event.register((ParticleType)DIParticleRegistry.GIANT_POP.get(), ParticleGiantPop.Factory::new);
        event.register((ParticleType)DIParticleRegistry.SIMPLE_BUBBLE.get(), ParticleSimpleBubble.Factory::new);
        event.register((ParticleType)DIParticleRegistry.VAMPIRE.get(), ParticleVampire.Factory::new);
        event.register((ParticleType)DIParticleRegistry.SNIFF.get(), ParticleSniff.Factory::new);
        event.register((ParticleType)DIParticleRegistry.PSYCHIC_WALL.get(), ParticlePsychicWall.Factory::new);
        event.register((ParticleType)DIParticleRegistry.INTIMIDATION.get(), (ParticleProvider)new ParticleIntimidation.Factory());
        event.register((ParticleType)DIParticleRegistry.BLIGHT.get(), ParticleBlight.Factory::new);
        event.register((ParticleType)DIParticleRegistry.LANTERN_BUGS.get(), ParticleLanternBugs.Factory::new);
    }

    @SubscribeEvent
    public void onOutlineColor(EventGetOutlineColor event) {
        if (event.getEntityIn() instanceof HighlightedBlockEntity) {
            event.setColor(OreColorRegistry.getBlockColor(((HighlightedBlockEntity)event.getEntityIn()).getBlockState()));
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void renderNametagEvent(RenderNameTagEvent event) {
        if (TameableUtils.isTamed(event.getEntity()) && TameableUtils.isPetOf((Player)Minecraft.m_91087_().f_91074_, event.getEntity()) && TameableUtils.hasAnyEnchants((LivingEntity)event.getEntity()) && Minecraft.m_91087_().f_91074_.m_6144_()) {
            event.setResult(Event.Result.DENY);
            this.renderNametagEnchantments(event.getEntity(), event.getContent(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
        }
    }

    @SubscribeEvent
    public void onAttackEntityFromClientEvent(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isAttack() && ((Boolean)DomesticationMod.CONFIG.swingThroughPets.get()).booleanValue() && !Minecraft.m_91087_().f_91074_.m_6144_() && Minecraft.m_91087_().f_91077_ instanceof EntityHitResult && TameableUtils.isPetOf((Player)Minecraft.m_91087_().f_91074_, ((EntityHitResult)Minecraft.m_91087_().f_91077_).m_82443_())) {
            event.setCanceled(true);
            event.setSwingHand(true);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Vec3 vec3 = player.m_20299_(1.0f);
            Vec3 vec31 = player.m_20252_(1.0f);
            double d0 = (double)Minecraft.m_91087_().f_91072_.m_105286_() + 1.5;
            double d1 = Minecraft.m_91087_().f_91077_.m_82450_().m_82557_(vec3) + 8.0;
            Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * d0, vec31.f_82480_ * d0, vec31.f_82481_ * d0);
            AABB aabb = player.m_20191_().m_82369_(vec31.m_82490_(d0)).m_82377_(1.0, 1.0, 1.0);
            EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)player, (Vec3)vec3, (Vec3)vec32, (AABB)aabb, arg_0 -> ClientProxy.lambda$onAttackEntityFromClientEvent$4((Player)player, arg_0), (double)d1);
            if (entityhitresult != null) {
                Minecraft.m_91087_().f_91072_.m_105223_((Player)player, entityhitresult.m_82443_());
            }
        }
    }

    private void renderNametagEnchantments(Entity entity, Component nameTag, PoseStack pose, MultiBufferSource buffer, int lightIn) {
        if (Minecraft.m_91087_().f_91074_.m_6144_() && TameableUtils.isTamed(entity) && TameableUtils.hasAnyEnchants((LivingEntity)entity)) {
            LivingEntity living = (LivingEntity)entity;
            List<Component> list = TameableUtils.getEnchantDescriptions(living);
            double d0 = Minecraft.m_91087_().m_91290_().m_114471_(entity);
            if (ForgeHooksClient.isNameplateInRenderDistance((Entity)entity, (double)d0)) {
                if (nameTag instanceof MutableComponent) {
                    int health = Math.round(living.m_21223_());
                    int maxHealth = Math.round(living.m_21233_());
                    nameTag = ((MutableComponent)nameTag).m_130946_(" (" + health + "/" + maxHealth + ")");
                }
                Font font = Minecraft.m_91087_().f_91062_;
                boolean flag = !entity.m_20163_();
                float f = entity.m_20206_() + 0.5f;
                int i = -10 * list.size();
                pose.m_85836_();
                pose.m_85837_(0.0, (double)(f + ClientProxy.getNametagOffset()), 0.0);
                pose.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
                pose.m_85841_(-0.025f, -0.025f, 0.025f);
                float f3 = !list.isEmpty() ? (float)(-font.m_92852_((FormattedText)list.get(0)) / 2) : (float)(-font.m_92852_((FormattedText)nameTag) / 2);
                pose.m_85836_();
                pose.m_252880_(f3 + 12.0f, (float)(-10 * list.size() + 16), 0.0f);
                pose.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                pose.m_85841_(22.0f, 22.0f, 22.0f);
                Minecraft.m_91087_().m_91291_().m_174269_(new ItemStack((ItemLike)DIItemRegistry.COLLAR_TAG.get()), ItemTransforms.TransformType.GROUND, lightIn, OverlayTexture.f_118083_, pose, buffer, entity.m_19879_());
                pose.m_85849_();
                Matrix4f matrix4f = pose.m_85850_().m_252922_();
                float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
                int j = (int)(f1 * 255.0f) << 24;
                float f2 = -font.m_92852_((FormattedText)nameTag) / 2;
                font.m_253181_(nameTag, f2, (float)i - 0.25f, 0x20FFFFFF, false, matrix4f, buffer, flag, j, lightIn);
                if (flag) {
                    font.m_253181_(nameTag, f2, (float)i - 0.25f, -1, false, matrix4f, buffer, false, 0, lightIn);
                }
                pose.m_85836_();
                pose.m_85841_(0.8f, 0.8f, 0.8f);
                matrix4f = pose.m_85850_().m_252922_();
                for (int k = 0; k < list.size(); ++k) {
                    float f4 = -font.m_92852_((FormattedText)list.get(k)) / 2;
                    font.m_253181_(list.get(k), f4, (float)i * 1.25f + (float)(k * 10) + 12.0f, 0x20FFFFFF, false, matrix4f, buffer, flag, j, lightIn);
                    if (!flag) continue;
                    font.m_253181_(list.get(k), f4, (float)i * 1.25f + (float)(k * 10) + 12.0f, -1, false, matrix4f, buffer, false, 0, lightIn);
                }
                pose.m_85849_();
                pose.m_85849_();
            }
        }
    }

    @Override
    public void updateVisualDataForMob(Entity entity, int[] arr) {
        shadowPunchRenderData.put(entity, arr);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateEntityStatus(Entity entity, byte updateKind) {
        if (entity instanceof FollowingJukeboxEntity) {
            DiscJockeySound sound;
            SoundEvent record = ((FollowingJukeboxEntity)entity).getRecordSound();
            if (entity.m_6084_() && updateKind == 66) {
                if (record != null && (DISC_JOCKEY_SOUND_MAP.get(entity.m_19879_()) == null || DISC_JOCKEY_SOUND_MAP.get(entity.m_19879_()).getRecordSound() != record)) {
                    sound = new DiscJockeySound(record, (FollowingJukeboxEntity)entity);
                    DISC_JOCKEY_SOUND_MAP.put(entity.m_19879_(), sound);
                } else {
                    sound = DISC_JOCKEY_SOUND_MAP.get(entity.m_19879_());
                }
                if (sound != null && !Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)sound) && sound.m_7767_() && sound.isNearest()) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
                }
            }
            if ((updateKind == 67 || record == null) && DISC_JOCKEY_SOUND_MAP.containsKey(entity.m_19879_())) {
                sound = DISC_JOCKEY_SOUND_MAP.get(entity.m_19879_());
                DISC_JOCKEY_SOUND_MAP.remove(entity.m_19879_());
                Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)sound);
            }
        }
    }

    private static /* synthetic */ boolean lambda$onAttackEntityFromClientEvent$4(Player player, Entity entity) {
        return !entity.m_5833_() && entity.m_6087_() && !TameableUtils.isPetOf(player, entity);
    }
}

