/*
 * Decompiled with CFR 0.152.
 */
package grim3212.mc.doubledoors;

import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class BlockTrapDoorBaM
extends BlockTrapDoor {
    private static final NeighbourBlocks[] _neighbour_blocks = new NeighbourBlocks[]{new NeighbourBlocks(new RelBlockCoord(0, -1), new RelBlockCoord(1, 0), new RelBlockCoord(-1, 0)), new NeighbourBlocks(new RelBlockCoord(0, 1), new RelBlockCoord(-1, 0), new RelBlockCoord(1, 0)), new NeighbourBlocks(new RelBlockCoord(-1, 0), new RelBlockCoord(0, -1), new RelBlockCoord(0, 1)), new NeighbourBlocks(new RelBlockCoord(1, 0), new RelBlockCoord(0, 1), new RelBlockCoord(0, -1))};

    public BlockTrapDoorBaM(Material material) {
        super(material);
    }

    private boolean IsValidNeighbour(World par1World, int source_x, int source_y, int source_z, int neighbour_x, int neighbour_y, int neighbour_z) {
        int meta_source = par1World.func_72805_g(source_x, source_y, source_z);
        int meta_neighbour = par1World.func_72805_g(neighbour_x, neighbour_y, neighbour_z);
        return Blocks.field_150415_aT == par1World.func_147439_a(neighbour_x, neighbour_y, neighbour_z) && (meta_source & 8) == (meta_neighbour & 8);
    }

    private void activateDoubleTrap(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, boolean isPowered, boolean include_left_right) {
        int meta = par1World.func_72805_g(par2, par3, par4);
        NeighbourBlocks neighbour_blocks = _neighbour_blocks[meta & 3];
        int coord_x = par2 + neighbour_blocks.counterpart.x;
        int coord_z = par4 + neighbour_blocks.counterpart.z;
        if (this.IsValidNeighbour(par1World, par2, par3, par4, coord_x, par3, coord_z) && (par1World.func_72805_g(coord_x, par3, coord_z) & 4) != (meta & 4)) {
            if (isPowered) {
                this.MyOnPoweredBlockChange(par1World, coord_x, par3, coord_z, (meta & 4) != 0, false);
            } else {
                this.MyOnBlockActivated(par1World, coord_x, par3, coord_z, par5EntityPlayer, 0, 0.0f, 0.0f, 0.0f, false);
            }
        }
        if (include_left_right) {
            int left_x = par2 + neighbour_blocks.left.x;
            int left_z = par4 + neighbour_blocks.left.z;
            int right_x = par2 + neighbour_blocks.right.x;
            int right_z = par4 + neighbour_blocks.right.z;
            if (!this.IsValidNeighbour(par1World, par2, par3, par4, left_x, par3, left_z) && this.IsValidNeighbour(par1World, par2, par3, par4, right_x, par3, right_z)) {
                left_x = right_x + neighbour_blocks.right.x;
                left_z = right_z + neighbour_blocks.right.z;
            } else if (!this.IsValidNeighbour(par1World, par2, par3, par4, right_x, par3, right_z) && this.IsValidNeighbour(par1World, par2, par3, par4, left_x, par3, left_z)) {
                right_x = left_x + neighbour_blocks.left.x;
                right_z = left_z + neighbour_blocks.left.z;
            }
            if (this.IsValidNeighbour(par1World, par2, par3, par4, left_x, par3, left_z) && (par1World.func_72805_g(left_x, par3, left_z) & 4) != (meta & 4)) {
                if (isPowered) {
                    this.MyOnPoweredBlockChange(par1World, left_x, par3, left_z, (meta & 4) != 0, false);
                } else {
                    this.MyOnBlockActivated(par1World, left_x, par3, left_z, par5EntityPlayer, 0, 0.0f, 0.0f, 0.0f, false);
                }
            }
            if (this.IsValidNeighbour(par1World, par2, par3, par4, right_x, par3, right_z) && (par1World.func_72805_g(right_x, par3, right_z) & 4) != (meta & 4)) {
                if (isPowered) {
                    this.MyOnPoweredBlockChange(par1World, right_x, par3, right_z, (meta & 4) != 0, false);
                } else {
                    this.MyOnBlockActivated(par1World, right_x, par3, right_z, par5EntityPlayer, 0, 0.0f, 0.0f, 0.0f, false);
                }
            }
        }
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        return this.MyOnBlockActivated(par1World, par2, par3, par4, par5EntityPlayer, par6, par7, par8, par9, true);
    }

    public boolean MyOnBlockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9, boolean include_left_right) {
        boolean was_open = BlockTrapDoorBaM.func_150118_d((int)par1World.func_72805_g(par2, par3, par4));
        boolean ret = super.func_149727_a(par1World, par2, par3, par4, par5EntityPlayer, par6, par7, par8, par9);
        if (was_open != BlockTrapDoorBaM.func_150118_d((int)par1World.func_72805_g(par2, par3, par4))) {
            this.activateDoubleTrap(par1World, par2, par3, par4, par5EntityPlayer, false, include_left_right);
        }
        return ret;
    }

    public void func_150120_a(World par1World, int par2, int par3, int par4, boolean par5) {
        this.MyOnPoweredBlockChange(par1World, par2, par3, par4, par5, true);
    }

    public void MyOnPoweredBlockChange(World par1World, int par2, int par3, int par4, boolean par5, boolean include_left_right) {
        super.func_150120_a(par1World, par2, par3, par4, par5);
        boolean flag = BlockTrapDoorBaM.func_150118_d((int)par1World.func_72805_g(par2, par3, par4));
        if (flag == par5) {
            this.activateDoubleTrap(par1World, par2, par3, par4, null, true, include_left_right);
        }
    }

    private static class RelBlockCoord {
        public final int x;
        public final int z;

        public RelBlockCoord(int new_x, int new_z) {
            this.x = new_x;
            this.z = new_z;
        }
    }

    private static class NeighbourBlocks {
        public final RelBlockCoord counterpart;
        public final RelBlockCoord left;
        public final RelBlockCoord right;

        public NeighbourBlocks(RelBlockCoord cp, RelBlockCoord l, RelBlockCoord r) {
            this.counterpart = cp;
            this.left = l;
            this.right = r;
        }
    }
}

