/*
 * Decompiled with CFR 0.152.
 */
package grim3212.mc.doubledoors;

import cpw.mods.fml.common.FMLLog;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class DDClassTransformer
implements IClassTransformer {
    public byte[] transform(String className, String arg1, byte[] data) {
        byte[] newData = data;
        if (className.equals("net.minecraft.block.Block")) {
            FMLLog.log((String)"Double Doors", (Level)Level.INFO, (String)("Patching class: " + className + " - (Block)"), (Object[])new Object[0]);
            try {
                newData = this.patchClassBlock(data, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (className.equals("aji")) {
            FMLLog.log((String)"Double Doors", (Level)Level.INFO, (String)("Patching class: " + className + " - (Block)"), (Object[])new Object[0]);
            try {
                newData = this.patchClassBlock(data, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newData;
    }

    public byte[] patchClassBlock(byte[] data, boolean obfuscated) throws Exception {
        String classBlock = obfuscated ? "aji" : "net/minecraft/block/Block";
        String methodRegisterBlocks = obfuscated ? "p" : "registerBlocks";
        String methodSetHardness = obfuscated ? "func_149711_c" : "setHardness";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(data);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean wooddoorFound = false;
        boolean irondoorFound = false;
        boolean fencegateFound = false;
        boolean trapdoorFound = false;
        for (int i = 0; i < classNode.methods.size(); ++i) {
            MethodNode method = (MethodNode)classNode.methods.get(i);
            if (!method.name.equals(methodRegisterBlocks) || !method.desc.equals("()V")) continue;
            for (int j = 0; j < method.instructions.size(); ++j) {
                AbstractInsnNode instruction = method.instructions.get(j);
                if (instruction.getOpcode() != 18) continue;
                LdcInsnNode ldcInstruction = (LdcInsnNode)instruction;
                if (ldcInstruction.cst.equals("wooden_door")) {
                    if (!wooddoorFound) {
                        ((TypeInsnNode)method.instructions.get((int)(j + 1))).desc = "grim3212/mc/doubledoors/BlockWoodDoorBaM";
                        ((MethodInsnNode)method.instructions.get((int)(j + 4))).owner = "grim3212/mc/doubledoors/BlockWoodDoorBaM";
                    }
                    wooddoorFound = true;
                    continue;
                }
                if (ldcInstruction.cst.equals("iron_door")) {
                    if (!irondoorFound) {
                        ((TypeInsnNode)method.instructions.get((int)(j + 1))).desc = "grim3212/mc/doubledoors/BlockIronDoorBaM";
                        ((MethodInsnNode)method.instructions.get((int)(j + 4))).owner = "grim3212/mc/doubledoors/BlockIronDoorBaM";
                    }
                    irondoorFound = true;
                    continue;
                }
                if (ldcInstruction.cst.equals("fence_gate")) {
                    if (!fencegateFound) {
                        ((TypeInsnNode)method.instructions.get((int)(j + 1))).desc = "grim3212/mc/doubledoors/BlockFenceGateBaM";
                        ((MethodInsnNode)method.instructions.get((int)(j + 3))).owner = "grim3212/mc/doubledoors/BlockFenceGateBaM";
                        ((MethodInsnNode)method.instructions.get((int)(j + 5))).owner = "grim3212/mc/doubledoors/BlockFenceGateBaM";
                        ((MethodInsnNode)method.instructions.get((int)(j + 5))).name = methodSetHardness;
                        ((MethodInsnNode)method.instructions.get((int)(j + 5))).desc = "(F)L" + classBlock + ";";
                    }
                    fencegateFound = true;
                    continue;
                }
                if (!ldcInstruction.cst.equals("trapdoor")) continue;
                if (!trapdoorFound) {
                    ((TypeInsnNode)method.instructions.get((int)(j + 1))).desc = "grim3212/mc/doubledoors/BlockTrapDoorBaM";
                    ((MethodInsnNode)method.instructions.get((int)(j + 4))).owner = "grim3212/mc/doubledoors/BlockTrapDoorBaM";
                }
                trapdoorFound = true;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

