/*
 * Decompiled with CFR 0.152.
 */
package com.calialec.radarbro;

import com.calialec.radarbro.GuiScreenAddWaypoint;
import com.calialec.radarbro.GuiSlotWaypoint;
import com.calialec.radarbro.WaypointNBTStorage;
import com.calialec.radarbro.mod_RadarBro;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringTranslate;
import org.lwjgl.input.Keyboard;

public class GuiWaypointManager
extends GuiScreen
implements GuiYesNoCallback {
    private GuiScreen parentScreen;
    private GuiSlotWaypoint waypointSlotContainer;
    private List waypointList = new ArrayList();
    private int selectedWaypoint = -1;
    private GuiButton buttonEdit;
    private GuiButton buttonDelete;
    private GuiButton buttonToggle;
    private boolean deleteClicked = false;
    private boolean addClicked = false;
    private boolean editClicked = false;
    private String timeTooltip = null;
    private WaypointNBTStorage tempWaypoint = null;

    public GuiWaypointManager(GuiScreen par1GuiScreen) {
        this.parentScreen = par1GuiScreen;
    }

    public void func_73866_w_() {
        this.loadWaypointList();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.waypointSlotContainer = new GuiSlotWaypoint(this);
        this.initGuiControls();
    }

    public void loadWaypointList() {
        try {
            NBTTagCompound nbttagcompound = CompressedStreamTools.func_74797_a((File)new File(mod_RadarBro.radarBroDir, "waypoints.dat"));
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("waypoints", 10);
            this.waypointList.clear();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                this.waypointList.add(WaypointNBTStorage.createWaypointNBTStorage(nbttaglist.func_150305_b(i)));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void saveWaypointList() {
        try {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.waypointList.size(); ++i) {
                nbttaglist.func_74742_a((NBTBase)((WaypointNBTStorage)this.waypointList.get(i)).getCompoundTag());
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74782_a("waypoints", (NBTBase)nbttaglist);
            CompressedStreamTools.func_74793_a((NBTTagCompound)nbttagcompound, (File)new File(mod_RadarBro.radarBroDir, "waypoints.dat"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initGuiControls() {
        boolean flag;
        StringTranslate stringTranslate = new StringTranslate();
        this.buttonEdit = new GuiButton(7, this.field_146294_l / 2 - 154, this.field_146295_m - 28, 100, 20, stringTranslate.func_74805_b("selectServer.edit"));
        this.field_146292_n.add(this.buttonEdit);
        this.buttonDelete = new GuiButton(2, this.field_146294_l / 2 - 50, this.field_146295_m - 28, 100, 20, stringTranslate.func_74805_b("selectServer.delete"));
        this.field_146292_n.add(this.buttonDelete);
        this.buttonToggle = new GuiButton(4, this.field_146294_l / 2 - 154, this.field_146295_m - 52, 155, 20, "Toggle Waypoint");
        this.field_146292_n.add(this.buttonToggle);
        this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 + 4, this.field_146295_m - 52, 150, 20, "Add Waypoint"));
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 + 4 + 50, this.field_146295_m - 28, 100, 20, stringTranslate.func_74805_b("gui.done")));
        this.buttonToggle.field_146124_l = flag = this.selectedWaypoint >= 0 && this.selectedWaypoint < this.waypointSlotContainer.func_148127_b();
        this.buttonEdit.field_146124_l = flag;
        this.buttonDelete.field_146124_l = flag;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void updateToggledState(boolean doubleClicked) {
        if (doubleClicked) {
            WaypointNBTStorage waypointnbtstorage = (WaypointNBTStorage)this.waypointList.get(this.selectedWaypoint);
            waypointnbtstorage.enabled = waypointnbtstorage.enabled.equals("true") ? "false" : "true";
            ((GuiButton)this.field_146292_n.get((int)2)).field_146126_j = waypointnbtstorage.enabled.equals("true") ? "Disable Waypoint" : "Enable Waypoint";
            this.saveWaypointList();
            mod_RadarBro.Waypoints.clear();
            this.loadWaypointList();
        } else {
            WaypointNBTStorage waypointnbtstorage = (WaypointNBTStorage)this.waypointList.get(this.selectedWaypoint);
            ((GuiButton)this.field_146292_n.get((int)2)).field_146126_j = waypointnbtstorage.enabled.equals("true") ? "Disable Waypoint" : "Enable Waypoint";
        }
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (!par1GuiButton.field_146124_l) {
            return;
        }
        if (par1GuiButton.field_146127_k == 2) {
            String s = ((WaypointNBTStorage)this.waypointList.get((int)this.selectedWaypoint)).name;
            if (s != null) {
                StringTranslate stringTranslate = new StringTranslate();
                this.deleteClicked = true;
                String s1 = "Are you sure you want to remove this waypoint?";
                String s2 = "'" + s + "' " + stringTranslate.func_74805_b("selectServer.deleteWarning");
                String s3 = stringTranslate.func_74805_b("selectServer.deleteButton");
                String s4 = stringTranslate.func_74805_b("gui.cancel");
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, s1, s2, s3, s4, this.selectedWaypoint);
                this.field_146297_k.func_147108_a((GuiScreen)guiyesno);
            }
        } else if (par1GuiButton.field_146127_k == 4) {
            this.updateToggledState(true);
            this.saveWaypointList();
            mod_RadarBro.Waypoints.clear();
            this.loadWaypointList();
        } else if (par1GuiButton.field_146127_k == 3) {
            this.addClicked = true;
            this.tempWaypoint = new WaypointNBTStorage(StatCollector.func_74838_a((String)"Waypoint"), "", "true");
            this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenAddWaypoint(this, this.tempWaypoint));
        } else if (par1GuiButton.field_146127_k == 7) {
            this.editClicked = true;
            WaypointNBTStorage waypointnbtstorage = (WaypointNBTStorage)this.waypointList.get(this.selectedWaypoint);
            this.tempWaypoint = new WaypointNBTStorage(waypointnbtstorage.name, waypointnbtstorage.coordinates, waypointnbtstorage.enabled);
            this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenAddWaypoint(this, this.tempWaypoint));
        } else if (par1GuiButton.field_146127_k == 0) {
            this.field_146297_k.func_147108_a(this.parentScreen);
        } else {
            this.waypointSlotContainer.func_148147_a(par1GuiButton);
        }
    }

    public void func_73878_a(boolean par1, int par2) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (par1) {
                this.waypointList.remove(par2);
                this.saveWaypointList();
                mod_RadarBro.Waypoints.clear();
                this.loadWaypointList();
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
        } else if (this.addClicked) {
            this.addClicked = false;
            if (par1) {
                this.waypointList.add(this.tempWaypoint);
                this.saveWaypointList();
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
        } else if (this.editClicked) {
            this.editClicked = false;
            if (par1) {
                WaypointNBTStorage waypointnbtstorage = (WaypointNBTStorage)this.waypointList.get(this.selectedWaypoint);
                waypointnbtstorage.name = this.tempWaypoint.name;
                waypointnbtstorage.coordinates = this.tempWaypoint.coordinates;
                this.saveWaypointList();
                mod_RadarBro.Waypoints.clear();
                this.loadWaypointList();
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    protected void func_73869_a(char par1, int par2) {
        if (par1 == '\r') {
            this.func_146284_a((GuiButton)this.field_146292_n.get(2));
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.timeTooltip = null;
        this.func_146276_q_();
        this.waypointSlotContainer.func_148128_a(par1, par2, par3);
        this.func_73732_a(this.field_146289_q, "Waypoint Manager", this.field_146294_l / 2, 20, 0xFFFFFF);
        super.func_73863_a(par1, par2, par3);
        if (this.timeTooltip != null) {
            this.func_35325_a(this.timeTooltip, par1, par2);
        }
    }

    protected void func_35325_a(String par1Str, int par2, int par3) {
        if (par1Str == null) {
            return;
        }
        int i = par2 + 12;
        int j = par3 - 12;
        int k = this.field_146289_q.func_78256_a(par1Str);
        this.func_73733_a(i - 3, j - 3, i + k + 3, j + 8 + 3, -1073741824, -1073741824);
        this.field_146289_q.func_78261_a(par1Str, i, j, -1);
    }

    static List getWaypointList(GuiWaypointManager par0GuiMultiplayer) {
        return par0GuiMultiplayer.waypointList;
    }

    static int setSelectedWaypoint(GuiWaypointManager par0GuiMultiplayer, int par1) {
        par0GuiMultiplayer.selectedWaypoint = par1;
        return par0GuiMultiplayer.selectedWaypoint;
    }

    static int getSelectedWaypoint(GuiWaypointManager par0GuiMultiplayer) {
        return par0GuiMultiplayer.selectedWaypoint;
    }

    static GuiButton getButtonEdit(GuiWaypointManager par0GuiMultiplayer) {
        return par0GuiMultiplayer.buttonEdit;
    }

    static GuiButton getButtonToggle(GuiWaypointManager par0GuiMultiplayer) {
        return par0GuiMultiplayer.buttonToggle;
    }

    static GuiButton getButtonDelete(GuiWaypointManager par0GuiMultiplayer) {
        return par0GuiMultiplayer.buttonDelete;
    }

    static String setTooltipText(GuiWaypointManager par0GuiMultiplayer, String par1Str) {
        par0GuiMultiplayer.timeTooltip = par1Str;
        return par0GuiMultiplayer.timeTooltip;
    }
}

