#include "/lib/util/reprojection.glsl"

#ifdef TAA_VERSION_1
	ivec2 neighbourhoodOffsets[8] =  ivec2[8](ivec2(-1, -1),
											  ivec2( 0, -1),
											  ivec2( 1, -1),
											  ivec2(-1,  0),
											  ivec2( 1,  0),
											  ivec2(-1,  1),
											  ivec2( 0,  1),
											  ivec2( 1,  1)
);
	const int numOffsets = 8;
#endif

#ifdef TAA_VERSION_2
	ivec2 neighbourhoodOffsets[25] = ivec2[25] (ivec2( 2,  2),
											    ivec2( 1,  2),
											    ivec2( 0,  2),
											    ivec2(-1,  2),
											    ivec2(-2,  2),
											    ivec2( 2,  1),
											    ivec2( 1,  1),
											    ivec2( 0,  1),
											    ivec2(-1,  1),
											    ivec2(-2,  1),
											    ivec2( 2,  0),
											    ivec2( 1,  0),
											    ivec2( 0,  0),
											    ivec2(-1,  0),
											    ivec2(-2,  0),
											    ivec2( 2, -1),
											    ivec2( 1, -1),
											    ivec2( 0, -1),
											    ivec2(-1, -1),
											    ivec2(-2, -1),
											    ivec2( 2, -2),
											    ivec2( 1, -2),
											    ivec2( 0, -2),
											    ivec2(-1, -2),
											    ivec2(-2, -2)
);
	const int numOffsets=25;
#endif

		void NeighbourhoodClamping(vec3 color, inout vec3 tempColor, float depth, inout float edge) {
	vec3 minclr = color, maxclr = color;

	ivec2 texelCoord = ivec2(gl_FragCoord.xy);

	for (int i = 0; i < numOffsets; i ++) {
		float depthCheck = texelFetch(depthtex1, texelCoord + neighbourhoodOffsets [i], 0).r;
		if (abs(GetLinearDepth(depthCheck) - GetLinearDepth(depth)) > 0.09)
			edge = 0.25;
		vec3 clr = texelFetch(colortex1, texelCoord + neighbourhoodOffsets [i], 0).rgb;
		minclr = min(minclr, clr);
		maxclr = max(maxclr, clr);
	}

	tempColor = clamp(tempColor, minclr, maxclr);
}

void TAA(inout vec3 color, inout vec4 temp) {
	float depth = texelFetch(depthtex1, texelCoord, 0).r;
	float noTAA = texelFetch(colortex7, texelCoord, 0).r;
	if (depth < 0.56 || noTAA > 0.5) {
		return;
	}

	vec3 coord = vec3(texCoord, depth);
	vec2 prvCoord = Reprojection(coord);

	vec2 view = vec2(viewWidth, viewHeight);
	float tempdepth = texture2D(depthtex1, prvCoord).r;
	if (tempdepth < 0.56) {
		return;
	}
	vec3 tempColor = texture2D(colortex2, prvCoord).gba;
	if (tempColor == vec3(0.0)) {
		temp = vec4(temp.r, color);
		return;
	}

	float edge = 0.0;
	NeighbourhoodClamping(color, tempColor, depth, edge);

	vec2 velocity = (texCoord - prvCoord.xy) * view;

	float blendFactor = float(prvCoord.x > 0.0 && prvCoord.x < 1.0 &&
		prvCoord.y > 0.0 && prvCoord.y < 1.0);

		#ifdef TAA_VERSION_1
	float a = 0.5;
	float b = 0.4;
	float c = 0.4;
		#endif

		#ifdef TAA_VERSION_2
	float a = 0.3;
	float b = 0.6;
	float c = 0.6;
		#endif

	float lengthVelocity = length(velocity) * 100;
	blendFactor *= max(exp(- lengthVelocity) * a + b - lengthVelocity * edge, c);
	color = mix(color, tempColor, blendFactor);
	temp = vec4(temp.r, color);
}