#if AURORA_COLOR == 5
	#include "/lib/color/hue.glsl"
#endif

#if AURORA_COLOR == 6
	#include "/lib/color/auroraColor.glsl"
#endif

float AuroraNoise(vec2 coord, vec2 wind, float cosT) {
	float noise = texture2D(noisetex, coord * 0.0625 + wind * 0.25).b * 3.0;
	noise += texture2D(noisetex, coord * 0.03125 + wind * 0.15).b * 3.0;
	noise = Max0(1.0 - 5.0 * (0.5 * cosT + 0.5) * abs(noise - 2.5));

	return noise;
}

vec3 DrawAurora(vec3 viewPos, float dither, int sampleCount) {

	float gradientMix = dither / sampleCount;
	float cosT = dot(normalize(viewPos), upVec);

	float visibility = pow2((1.0 - rainStrengthS));

	visibility *= 1.0 - sunVisibility;

	#if defined OVERWORLD && defined WEATHER_PERBIOME && defined AURORA_WEATHER_PERBIOME
		visibility *= pow2(isCold);
	#endif

	vec2 wind = vec2(frameTimeCounter * AURORA_SPEED * 0.000125, sin(frameTimeCounter * AURORA_SPEED * 0.05) * 0.00025);

	vec3 aurora = vec3(0.);

	if (cosT > 0.0 && visibility > 0.0) {
		vec3 wpos = normalize((gbufferModelViewInverse * vec4(viewPos, 1.0)).xyz);
		for (int i = 0; i < sampleCount; i ++) {
			vec3 planeCoord = wpos * ((AURORA_DISTANCE + (i + dither) * AURORA_SIZE / sampleCount) / wpos.y) * 0.004;
			vec2 coord = cameraPosition.xz * 0.00004 + planeCoord.xz;
			coord += vec2(coord.y, - coord.x) * 0.3;

			float noise = AuroraNoise(coord, wind, cosT);

			float colorGradient = COLOR_GRADIENT;

			if (noise > 0.0) {
				noise *= texture2D(noisetex, coord * 0.125 + wind * 0.25).b;
				noise *= 0.5 * texture2D(noisetex, coord + wind * 16.0).b + 0.75;
				noise = pow2(noise) * 3.0 / sampleCount;
				noise *= Max0(sqrt(1.0 - length(planeCoord.xz) * 3.75));

				#if AURORA_COLOR == 1
					vec3 auroraColor = mix(vec3(0.1, 1.0, 0.5), vec3(0.3451, 0.0, 0.4118), pow(gradientMix, colorGradient));

				#elif AURORA_COLOR == 2
					vec3 auroraColor = mix(vec3(0.1, 1.0, 0.5), vec3(0.0, 0.0, 0.7216), pow(gradientMix, colorGradient));

				#elif AURORA_COLOR == 3
					vec3 auroraColor = mix(vec3(0.1, 1.0, 0.5), vec3(0.6667, 0.0, 0.0), pow(gradientMix, colorGradient));

				#elif AURORA_COLOR == 4
					vec3 auroraColor = mix(vec3(0.1, 1.0, 0.5), vec3(0.6157, 0.6275, 0.0), pow(gradientMix, colorGradient));

				#elif AURORA_COLOR == 5
					vec3 auroraColor = mix(hue2(frameTimeCounter * RAINBOW_COLOR_AURORA_1_SPEED + RAINBOW_COLOR_AURORA_1_START), hue2(frameTimeCounter * RAINBOW_COLOR_AURORA_2_SPEED + RAINBOW_COLOR_AURORA_2_START), pow(gradientMix, colorGradient));

				#elif AURORA_COLOR == 6
					vec3 auroraColor = mix(auroraLowCol, auroraHighCol, pow(gradientMix, colorGradient));
				#endif
				aurora += noise * auroraColor * exp2(- 6.0 * i / sampleCount) * AURORA_VISIBILITY;
				aurora *= 1.0 - exp(- (10.0 - 9.0 * rainStrengthS) * cosT);
			}
			gradientMix += 1.0 / sampleCount;
		}
	}

	#if MC_VERSION >= 11800
		visibility *= clamp01((cameraPosition.y + 70.0) * 0.125);
	#else
		visibility *= clamp01((cameraPosition.y + 6.0) * 0.125);
	#endif

	#ifdef UNDERGROUND_SKY
		if (isEyeInWater == 0) {
			visibility *= mix(clamp01((cameraPosition.y - 48.0) * 0.0625), 1.0, eBS);
		}
	#endif

	return aurora * visibility;
}