#include "/lib/color/auroraEndColor.glsl"

float AuroraEndNoise(vec2 coord, vec2 wind, float cosT) {
	float noise = texture2D(noisetex, coord * 0.0625 + wind * 0.25).b * 3.0;
	noise += texture2D(noisetex, coord * 0.03125 + wind * 0.15).b * 3.0;
	noise = Max0(1.0 - 5.0 * (0.5 * cosT + 0.5) * abs(noise - 2.5));

	return noise;
}

vec3 DrawEndAurora(vec3 viewPos, float dither, int sampleCount) {

	float gradientMix = dither / sampleCount;
	float cosT = dot(normalize(viewPos), upVec);

	float visibility = 1.0;

	vec2 wind = vec2(frameTimeCounter * AURORA_END_SPEED * 0.000125, sin(frameTimeCounter * AURORA_END_SPEED * 0.05) * 0.00025);

	vec3 aurora = vec3(0.0);

	if (cosT > 0.0 && visibility > 0.0) {
		vec3 wpos = normalize((gbufferModelViewInverse * vec4(viewPos, 1.0)).xyz);
		for (int i = 0; i < sampleCount; i ++) {
			vec3 planeCoord = wpos * ((AURORA_END_DISTANCE + (i + dither) * AURORA_END_SIZE / sampleCount) / wpos.y) * 0.004;
			vec2 coord = cameraPosition.xz * 0.00004 + planeCoord.xz;
			coord += vec2(coord.y, - coord.x) * 2.0;

			float noise = AuroraEndNoise(coord, wind, cosT);

			float colorGradient = COLOR_END_GRADIENT;

			if (noise > 0.0) {
				noise *= texture2D(noisetex, coord * 0.125 + wind * 0.25).b;
				noise *= 0.5 * texture2D(noisetex, coord + wind * 16.0).b + 0.75;
				noise = pow2(noise) * 3.0 / sampleCount;
				noise *= Max0(sqrt(1.0 - length(planeCoord.xz) * 3.75));

				vec3 auroraColor = mix(auroraEndLowCol, auroraEndHighCol, pow(gradientMix, colorGradient));

				aurora += noise * auroraColor * exp2(- 6.0 * i / sampleCount) * AURORA_END_VISIBILITY;
				aurora *= 1.0 - exp(- (10.0 - 9.0 * rainStrengthS) * cosT);
			}
			gradientMix += 1.0 / sampleCount;
		}
	}

	return aurora * visibility;
}
