vec3 DrawEndStars(vec3 EndStarsColor, vec3 EndStarsViewPos) {
    vec3 wpos = vec3(gbufferModelViewInverse * vec4(EndStarsViewPos, 1.0));
    if (wpos.y < 0)
        wpos = - wpos;
    vec3 planeCoord = 0.75 * wpos / (wpos.y + length(wpos.xz));

    float starJitter = 1.0;

    #ifdef STARS_JITTER
        vec3 planeCoordNorm = normalize(planeCoord);
        float jitterBias = mix(5.0, 20.0, abs(sin(planeCoordNorm.y * 10.0) + sin(planeCoordNorm.x * 10.0) * cos(planeCoordNorm.z * 10.0)) * 0.5);
        starJitter = sin(frameTimeCounter * 5.0 * STARS_JITTER_SPEED + jitterBias * 2.0) * 0.5 + 0.6;
	#endif

    float cosT = clamp01(dot(normalize(EndStarsViewPos), normalize(upVec)));

    float NcosTM = abs(cosT);
    NcosTM = 1.0 - NcosTM;
    NcosTM = pow(NcosTM, (2.0 - NcosTM) * (3.0 - 0.8));
    NcosTM = Max0(NcosTM);

    vec2 coord = planeCoord.xz * 0.75;
    coord = floor(coord * 1024.0) / 1024.0;

    float multiplier = sqrt(sqrt(NcosTM)) * 6.0;
    float star = 1.0;
    if (NcosTM > 0.0) {
        star *= GetNoise(coord.xy);
        star *= GetNoise(coord.xy + 0.1);
        star *= GetNoise(coord.xy + 0.23);
    }
    star = Max0(star - 0.780) * multiplier;

    #if NEW_ENDER_STARS == 1
        float star2 = 1.0;
        if (NcosTM > 0.0) {
            star2 *= GetNoise(coord.xy);
            star2 *= GetNoise(coord.xy + 0.4);
            star2 *= GetNoise(coord.xy + 0.86);
        }
        star2 = Max0(star2 - 0.840) * multiplier;
    #endif

    #if NEW_ENDER_STARS == 1
        EndStarsColor.rgb += starJitter * star * pow(lightNight * 160, vec3(1.0, 0.0, 0.9176)) + starJitter * star2 * pow(lightNight * 400, vec3(0.0, 0.0, 1.0));
    #else
        EndStarsColor.rgb += starJitter * star * pow(lightNight * 160, vec3(1.0));
    #endif

    return clamp01(EndStarsColor);
}