#ifdef OVERWORLD
vec3 GetSkyColor(vec3 viewPos, bool isReflection) {
    float timeBrightnessInv = 1.0 - timeBrightness;
    float timeBrightnessInv2 = pow2(timeBrightnessInv);
    float timeBrightnessInv4 = pow2(timeBrightnessInv2);

    vec3 nViewPos = normalize(viewPos);

    float VoU = clamp(dot(nViewPos, upVec), - 1.0, 1.0);
    float VoL = clamp(dot(nViewPos, sunVec), - 1.0, 1.0);

    float groundDensity = 0.08 * (4.0 - 3.0 * sunVisibility) * (10.0 * pow2(rainStrengthS) + 1.0);

    float exposure = exp2(timeBrightness * 0.75 - 0.75 + SKY_EXPOSURE_D);
    float nightExposure = exp2(- 3.5 + SKY_EXPOSURE_N);
    float weatherExposure = exp2(SKY_EXPOSURE_W);

    float gradientCurve = mix(SKY_HORIZON_F, SKY_HORIZON_N, VoL);
    float baseGradient = exp(- (1.0 - pow(1.0 - Max0(VoU), gradientCurve)) / (SKY_DENSITY_D + 0.025));
    float ground = 1.0;

    #if SKY_GROUND > 0
        float groundVoU = clamp01(- VoU * 1.015 - 0.015);
        ground = 1.0 - exp(- groundDensity * max(OVERWORLD_FOG_DENSITY, 0.125) / groundVoU);

        #if SKY_GROUND == 1
            if (! isReflection) {
                ground = 1.0;
            }
        #endif
    #endif

    vec3 sky = skyCol * baseGradient / pow2(SKY_I);

    #ifdef SKY_VANILLA
    sky = mix(sky, fogCol * baseGradient, pow(1.0 - Max0(VoU), 4.0));
    #endif

    sky = sky / sqrt(pow2(sky) + 1.0) * exposure * sunVisibility * pow2(SKY_I);
    sky *= 2.0 - 0.5 * timeBrightnessInv4;
    sky *= mix(SKY_NOON, SKY_DAY, timeBrightnessInv4);

    float sunMix = (VoL * 0.5 + 0.5) * pow(clamp01(1.0 - VoU), 2.0 - sunVisibility) *
        pow(1.0 - timeBrightness * 0.6, 3.0);
    float horizonMix = pow(1.0 - abs(VoU), 2.5) * 0.125;
    float lightMix = (1.0 - (1.0 - sunMix) * (1.0 - horizonMix));

    vec3 lightSky = pow(lightSun, vec3(4.0 - sunVisibility)) * baseGradient;
    lightSky = lightSky / (1.0 + lightSky * rainStrengthS);

    sky = mix(sqrt(sky * (1.0 - lightMix)), sqrt(lightSky), lightMix);
    sky *= sky;

    float nightGradient = exp(- Max0(VoU) / SKY_DENSITY_N);
    vec3 nightSky = pow2(lightNight) * nightGradient * nightExposure;
    nightSky *= mix(SKY_NIGHT, 1.0, sunVisibility);
    sky = mix(nightSky, sky, pow2(sunVisibility));

    float rainGradient = exp(- Max0(VoU) / SKY_DENSITY_W);
    vec3 weatherSky = pow2(weatherCol.rgb) * weatherExposure;
    weatherSky *= GetLuminance(ambientCol / (weatherSky)) * (0.2 * sunVisibility + 0.2);
    sky = mix(sky, weatherSky * rainGradient, rainStrengthS);

    sky *= ground;

    #ifdef UNDERGROUND_SKY
        if (isEyeInWater == 0) {
            float ug = mix(clamp01((cameraPosition.y - 48.0) * 0.0625), 1.0, eBS);
            sky = mix(minLightCol * 0.125, sky, ug);
        }
    #endif

	#if MC_VERSION >= 11800
        sky *= clamp01((cameraPosition.y + 70.0) * 0.125);
	#else
        sky *= clamp01((cameraPosition.y + 6.0) * 0.125);
	#endif

    return sky;
}

#endif