#if defined OVERWORLD && PLANET >= 1

    vec3 drawPlanetImage(vec3 albedo, vec3 skycolor, vec2 size, vec3 wpos, sampler2D tex, float opacity) {
        vec3 newwpos = planetRotMatrix * wpos;

        vec2 planetTexCoord = (newwpos.xy / newwpos.z) / size;

        if (- 1.0 < planetTexCoord.x && planetTexCoord.x < 1.0 && - 1.0 < planetTexCoord.y && planetTexCoord.y < 1.0 && newwpos.z > 0.0) {

            vec4 planet = texture2D(tex, vec2(0.5, 0.5) + planetTexCoord * 0.5);
            planet.rgb *= mix(pow2(length(planet.rgb) + 0.2), pow2(length(planet.rgb) + 0.6), sunVisibility);
            planet.rgb = mix(albedo.rgb, planet.rgb * 0.05, planet.a * opacity);
            if (planet.a > 0.0)
                albedo.rgb = mix(planet.rgb, skycolor.rgb, sunVisibility * 0.75);
        }

        #ifdef UNDERGROUND_SKY
        if (isEyeInWater == 0) {
            albedo.rgb *= mix(clamp01((cameraPosition.y - 48.0) * 0.0625), 1.0, eBS);
        }
        #endif

        return albedo.rgb;
    }
#endif

#if defined (OVERWORLD) && defined NEBULA
vec3 drawNebulaImage(vec3 albedo, vec2 size, vec3 wpos, sampler2D tex, float opacity) {
    vec3 newwpos = nebulaRotMatrix * wpos;
    vec2 nebulaTexCoord = (newwpos.xy / newwpos.z) / size;

    if (moonVisibility > 0.0) {
        if (- 1.0 < nebulaTexCoord.x && nebulaTexCoord.x < 1.0 && - 1.0 < nebulaTexCoord.y && nebulaTexCoord.y < 1.0 && newwpos.z > 0.0) {

            vec4 nebula = texture2D(tex, vec2(0.5, 0.5) + nebulaTexCoord * 0.5);
            nebula.rgb *= pow2(length(nebula.rgb) + 0.3);
            albedo.rgb = mix(albedo.rgb, (pow2(nebula.rgb) * 0.7) * 0.05, ((1.0 - sunVisibility) * moonBrightness) * nebula.a * opacity);
        }
    }

    #ifdef UNDERGROUND_SKY
    if (isEyeInWater == 0) {
        albedo.rgb *= mix(clamp01((cameraPosition.y - 48.0) * 0.0625), 1.0, eBS);
    }
	#endif

    return albedo.rgb;
}
#endif

#if defined (OVERWORLD) && defined GALAXY
vec3 drawGalaxyImage(vec3 albedo, vec2 size, vec3 wpos, sampler2D tex, float opacity) {

    vec3 newwpos = galaxyRotMatrix * wpos;
    vec2 galaxyTexCoord = (newwpos.xy / newwpos.z) / size;

    if (moonVisibility > 0.0) {
        if (- 1.0 < galaxyTexCoord.x && galaxyTexCoord.x < 1.0 && - 1.0 < galaxyTexCoord.y && galaxyTexCoord.y < 1.0 && newwpos.z > 0.0) {

            vec4 galaxy = texture2D(tex, vec2(0.5, 0.5) + galaxyTexCoord * 0.5);
            galaxy.rgb *= pow2(length(galaxy.rgb) + 0.3);
            albedo.rgb = mix(albedo.rgb, galaxy.rgb * 0.05, ((1.0 - sunVisibility) * moonBrightness) * galaxy.a * opacity);
        }
    }

    #ifdef UNDERGROUND_SKY
    if (isEyeInWater == 0) {
        albedo.rgb *= mix(clamp01((cameraPosition.y - 48.0) * 0.0625), 1.0, eBS);
    }
	#endif

    return albedo.rgb;
}
#endif