vec3 DrawStars(inout vec3 color, vec3 viewPos) {
	vec4 moonPos = gbufferModelViewInverse * vec4(viewPos, 1.0);
	moonPos /= moonPos.w;
	vec3 moonCoord = getLunarCoord(moonPos.xyz);
	if (moonCoord.y < 0.0)
		moonCoord.y = - moonCoord.y;
	vec3 planeCoord = moonCoord / (moonCoord.y + length(moonCoord.xz));

	float floorStar = 1024.0;
	float multiplier = 0.0;
	float starJitter = 0.0;
	float starsCov = 0.0;

	vec2 starCoord = planeCoord.xz * DISTANCE_STARS;
	starCoord = floor(starCoord * floorStar) / floorStar;

	float cosT = clamp01(dot(normalize(viewPos.xyz), normalize(upVec)));

	#ifdef SUNSET_SUNRISE_STARS
	multiplier = sqrt(sqrt(cosT)) * STARS_LIGHT_INTENSITY * (1.0 - rainStrengthShiningStars) * max(Max0(1.0 - timeBrightness * 3.5) * 0.1, moonVisibility);
	#else
	multiplier = sqrt(sqrt(cosT)) * STARS_LIGHT_INTENSITY * (1.0 - rainStrengthShiningStars) * moonVisibility;
	#endif

	#ifdef STARS_JITTER
	vec3 planeCoordNorm = normalize(planeCoord);
	float jitterBias = mix(5.0, 20.0, abs(sin(planeCoordNorm.y * 10.0) + sin(planeCoordNorm.x * 10.0) * cos(planeCoordNorm.z * 10.0)) * 0.5);
	starJitter = sin(frameTimeCounter * 2.0 * STARS_JITTER_SPEED + jitterBias * 2.0 ) * 0.5 + 0.5;
	#endif

	float star = 1.0;
	if (cosT > 0.0) {
		star *= GetNoise(starCoord.xy);
		star *= GetNoise(starCoord.xy + 0.115);
		star *= GetNoise(starCoord.xy + 0.230);
	}

	#if STARS_COVERAGE == 1
	starsCov = 0.7625;
	#elif STARS_COVERAGE == 2
	starsCov = 0.7125;
	#elif STARS_COVERAGE == 3
	starsCov = 0.6625;
	#endif

	float moonStarsHideSize = MOON_STARS_HIDE_SIZE;
	float moonStarsFade = MOON_STARS_FADE;

	float sinmoonangle = length(moonCoord.xz) / length(moonCoord.xyz);
	multiplier *= clamp01((sinmoonangle - moonStarsHideSize) * moonStarsFade);

	star = clamp01(star - starsCov) * multiplier;
	star *= 1.0 - exp(- (10.0 - 9.0 * rainStrengthShiningStars) * cosT);

	#if MC_VERSION >= 11800
	star *= clamp01((cameraPosition.y + 70.0) * 0.125);
	#else
	star *= clamp01((cameraPosition.y + 6.0) * 0.125);
	#endif

	#ifdef UNDERGROUND_SKY
	if (isEyeInWater == 0) {
		star *= mix(clamp01((cameraPosition.y - 48.0) * 0.0625), 1.0, eBS);
	}
	#endif

	color += star * pow(lightNight, vec3(0.8)) * pow2(starJitter);
	return vec3(star);
}