vec3 SunGlare(vec3 color, vec3 nViewPos, vec3 lightCol) {
	float VoLp = dot(nViewPos, sunVec);
	if (VoLp > 0.0) {
		float VoL = VoLp;
		VoL *= VoL;
		VoL *= VoL;
		VoL *= VoL;

		float visfactor = 0.2;

		float sunGlare = VoL;
		sunGlare = visfactor / (1.0 - (1.0 - visfactor) * sunGlare) - visfactor;
		sunGlare *= VoLp;

		float sunGlareDay = 0.2;

		sunGlare *= sunGlareDay * SUN_GLARE_DAY * sunVisibility;

		float shadowTime = abs(sunVisibility - 0.5) * 2.0;
		shadowTime *= shadowTime;
		sunGlare *= pow2(shadowTime);

		vec3 finalSunGlare = lightCol * sunGlare;

		#if MC_VERSION >= 11800
		finalSunGlare *= clamp01((cameraPosition.y + 70.0) * 0.125);
		#else
		finalSunGlare *= clamp01((cameraPosition.y + 6.0) * 0.125);
		#endif

		#ifdef UNDERGROUND_SKY
		if (isEyeInWater == 0) {
			finalSunGlare *= mix(clamp01((cameraPosition.y - 48.0) * 0.0625), 1.0, eBS);
		}
		#endif

		if (isEyeInWater == 1)
			color += clamp01(0.025 * lightCol * finalSunGlare);

		#if SUNGLARE_RAIN == 1
		if (isEyeInWater == 1) {
			color += (SUNGLARE_UNDERWATER_STRENGTH * 0.01 * (0.1 - rainStrengthS * 2.5)) * lightCol * finalSunGlare;
		} else if (isEyeInWater == 0) {
			color += (SUNGLARE_OUTWATER_STRENGTH * 0.01 * (1.1 - rainStrengthS)) * lightCol * finalSunGlare;
		}
		#elif SUNGLARE_RAIN == 2
		if (isEyeInWater == 1) {
			color += (SUNGLARE_UNDERWATER_STRENGTH * 0.01 * lightCol * finalSunGlare * (1.0 - rainStrengthS));
		} else if (isEyeInWater == 0) {
			color += (SUNGLARE_OUTWATER_STRENGTH * 0.01 * lightCol * finalSunGlare * (1.0 - rainStrengthS));
		}
		#endif

	}
	return color;
}

vec3 MoonGlare(vec3 color, vec3 nViewPos, vec3 lightCol) {
	float VoLp = dot(nViewPos, - sunVec);
	if (VoLp > 0.0) {
		float VoL = VoLp;
		VoL *= VoL;
		VoL *= VoL;
		VoL *= VoL;

		float visfactor = 0.2;

		float sunGlare = VoL;
		sunGlare = visfactor / (1.0 - (1.0 - visfactor) * sunGlare) - visfactor;
		sunGlare *= VoLp;

		float moonPhaseOffsetSunGlare = 1.0;

		#ifdef NEWMOON_DISABLER_STUFF
		moonPhaseOffsetSunGlare = 1.0 - (float((moonPhase == 4)));
		#endif

		float sunGlareNight = 200.0;

		sunGlare *= sunGlareNight * SUN_GLARE_NIGHT * moonPhaseOffsetSunGlare * moonVisibility;

		float shadowTime = abs(sunVisibility - 0.5) * 2.0;
		shadowTime *= shadowTime;
		sunGlare *= pow2(shadowTime);

		vec3 finalSunGlare = lightCol * sunGlare;

		#if MC_VERSION >= 11800
		finalSunGlare *= clamp01((cameraPosition.y + 70.0) * 0.125);
		#else
		finalSunGlare *= clamp01((cameraPosition.y + 6.0) * 0.125);
		#endif

		#ifdef UNDERGROUND_SKY
		if (isEyeInWater == 0) {
			finalSunGlare *= mix(clamp01((cameraPosition.y - 48.0) * 0.0625), 1.0, eBS);
		}
		#endif

		if (isEyeInWater == 1)
			color += clamp01(0.025 * lightCol * finalSunGlare);

		#if SUNGLARE_RAIN == 1
		if (isEyeInWater == 1) {
			color += (SUNGLARE_UNDERWATER_STRENGTH * 0.01 * (0.1 - rainStrengthS * 2.5)) * lightCol * finalSunGlare;
		} else if (isEyeInWater == 0) {
			color += (SUNGLARE_OUTWATER_STRENGTH * 0.01 * (1.1 - rainStrengthS)) * lightCol * finalSunGlare;
		}
		#elif SUNGLARE_RAIN == 2
		if (isEyeInWater == 1) {
			color += (SUNGLARE_UNDERWATER_STRENGTH * 0.01 * lightCol * finalSunGlare * (1.0 - rainStrengthS));
		} else if (isEyeInWater == 0) {
			color += (SUNGLARE_OUTWATER_STRENGTH * 0.01 * lightCol * finalSunGlare * (1.0 - rainStrengthS));
		}
		#endif

	}
	return color;
}