vec4 GetWaterFog(vec3 viewPos) {
    float fog = length(viewPos) / waterFogRange;
    fog = 1.0 - exp(- 4.0 * fog);

    #if WATER_MODE == 0
        vec3 waterFogColor = waterColor.rgb;
    #elif  WATER_MODE == 1 || WATER_MODE == 2
        vec3 waterFogColor = pow2(fogColor) * 0.5;
    #endif

    #ifdef ENABLE_DARKNESS_EFFECT
        #if MC_VERSION >= 11900
            waterFogColor *= 0.125 * (1.0 - max(blindFactor, darknessFactor));
        #else
            waterFogColor *= 0.125 * (1.0 - blindFactor);
        #endif
    #endif

    #ifdef OVERWORLD
        vec3 waterFogTint = lightCol * eBS * shadowFade * 0.9 + 0.1;
    #endif

    #ifdef NETHER
        vec3 waterFogTint = netherCol.rgb;
    #endif

    #ifdef END
        vec3 waterFogTint = endCol.rgb;
    #endif

    waterFogTint = sqrt(waterFogTint * length(waterFogTint));

    return vec4(waterFogColor * waterFogTint, fog);
}