bool isLightHandledLeft(){
    return (heldItemId2==13001|| //Glowstone, Torch, Jack'o Lantern, Lantern, Campfire, Shroomlight, Lava Bucket, Blaze Rod
            heldItemId2==13002|| //Beacon
            heldItemId2==13003|| //Redstone Torch
            heldItemId2==13004|| //Soul Lantern, Soul Campfire, Soul Torch
            heldItemId2==13005|| //Sea Lantern
            heldItemId2==13006|| //End Rod, Crying Obsidian, End Crystal, Nether Star
            heldItemId2==13007|| //Sea Pickle
            heldItemId2==13008|| //Conduit
            heldItemId2==13009|| //Froglight ochre
            heldItemId2==13010|| //Froglight Verdant
            heldItemId2==13011); //Froglight pearl
}
bool isLightHandledRight(){
    return (heldItemId==13001|| //Glowstone, Torch, Jack'o Lantern, Lantern, Campfire, Shroomlight, Lava Bucket, Blaze Rod
            heldItemId==13002|| //Beacon
            heldItemId==13003|| //Redstone Torch
            heldItemId==13004|| //Soul Lantern, Soul Campfire, Soul Torch
            heldItemId==13005|| //Sea Lantern
            heldItemId==13006|| //End Rod, Crying Obsidian, End Crystal, Nether Star
            heldItemId==13007|| //Sea Pickle
            heldItemId==13008|| //Conduit
            heldItemId==13009|| //Froglight ochre
            heldItemId==13010|| //Froglight Verdant
            heldItemId==13011); //Froglight pearl
}
bool isLightHandled(){
    return isLightHandledLeft() || isLightHandledRight();
}

void getHandLightColor(inout vec3 lightingColor, int heldItem) {
    if (heldItem == 13002) {
        lightingColor = vec3(0.4863, 0.7686, 0.9882);
    } else if (heldItem == 13003) {
        lightingColor = vec3(0.8863, 0.0235, 0.0235);
    } else if (heldItem == 13004) {
        lightingColor = vec3(0.0, 0.1843, 1.0);
    } else if (heldItem == 13005) {
        lightingColor = vec3(0.0, 0.8549, 0.6667);
    } else if (heldItem == 13006) {
        lightingColor = vec3(0.9765, 0.3412, 1.0);
    } else if (heldItem == 13007) {
        lightingColor = vec3(0.8275, 0.8314, 0.4118);
    } else if (heldItem == 13008) {
        lightingColor = vec3(0.9922, 0.9255, 0.7059);
    } else if (heldItem == 13009) {
        lightingColor = vec3(0.8275, 0.8314, 0.4118);
    } else if (heldItem == 13010) {
        lightingColor = vec3(0.4941, 0.8314, 0.4118);
    } else if (heldItem == 13011) {
        lightingColor = vec3(0.7294, 0.5412, 0.9725);
    } else if (heldItem == 13001) {
        lightingColor = vec3(1.0, 0.3686, 0.0);
    }
}

void changeLightingColorByHand(inout vec3 lightingColor) {

    if (isLightHandledLeft() && ! isLightHandledRight()) {
        getHandLightColor(lightingColor, heldItemId2);
    } else if (isLightHandledRight() && ! isLightHandledLeft()) {
        getHandLightColor(lightingColor, heldItemId);
    } else if (isLightHandledLeft() && isLightHandledRight()) {
        vec3 leftLightingColor = lightingColor;
        vec3 rightLightingColor = lightingColor;

        getHandLightColor(leftLightingColor, heldItemId2);
        getHandLightColor(rightLightingColor, heldItemId);

        float xpos = (gl_FragCoord.x / viewWidth) * 2.0 - 1.0;

        float fade = (clamp(xpos * 2.0, - 1.0, 1.0) + 1.0) * 0.5;

        lightingColor = mix(leftLightingColor, rightLightingColor, fade);

    }
}
