#ifndef PUDDLES_ON_WATER
	if (water < 0.5 && wetness > 0.001)
#else
	if (water > 0.5 && wetness > 0.001)
#endif

{
puddles = GetPuddles(worldPos, newCoord, wetness) * clamp01(NoU) * skyRefFactor;
}

#ifdef WEATHER_PERBIOME
	float weatherweight = isCold + isDesert + isMesa + isSavanna;
	puddles *= 1.0 - weatherweight;
#endif

puddles *= clamp01(lightmap.y * 32.0 - 31.0);

float ps = sqrt(1.0 - 0.75 * porosity);
float pd = (0.5 * porosity + 0.15);

smoothness = mix(smoothness * 0.85, 1.0, puddles * ps);
f0 = max(f0, puddles * 0.02);

albedo.rgb *= 1.0 - (puddles * pd);

if (puddles > 0.001 && rainStrengthS > 0.001) {
mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x, tangent.y, binormal.y, normal.y, tangent.z, binormal.z, normal.z);

vec3 puddleNormal = GetPuddleNormal(worldPos, viewPos, tbnMatrix);
newNormal = normalize(mix(newNormal, puddleNormal, puddles * sqrt(1.0 - porosity) * rainStrengthS));
}