float GetOutlineMask() {
	float ph = ceil(viewHeight / 720.0) * 0.5 / viewHeight;
	float pw = ph / aspectRatio;

	float mask = 0.0;
	int offsetSample = 12;

	#if !defined OUTLINE_TRIPWIRE && MC_VERSION >= 11605
		offsetSample = 22;
	#endif

	for (int i = 0; i < offsetSample; i ++) {
		vec2 offset = vec2(pw, ph) * outlineOffsets [i];

		#if !defined OUTLINE_TRIPWIRE && MC_VERSION >= 11605
			if (textureLod(colortex8, texCoord + offset, 0).g > 0.5) {
				return 0.0;
			}
		#endif

		for (int j = 0; j < 2; j ++) {
			mask += float(texture2D(depthtex0, texCoord + offset).r <
				texture2D(depthtex1, texCoord + offset).r);
			offset = - offset;
		}
	}

	return float(mask > 0.5);
}