float GetPuddles(vec3 worldPos, vec2 coord, float wetness) {
    worldPos = (worldPos + cameraPosition) * 0.005;

    float height = textureGrad(normals, coord, dcdx, dcdy).a;
    height = mix(1.0, height, PARALLAX_DEPTH);
    height = smoothstep(1.0, 0.95, height) * 0.1 - 0.05;
    float noise = texture2D(noisetex, worldPos.xz * 0.5).r * 0.375;
    noise += texture2D(noisetex, worldPos.xz * 0.125).r * 0.625;
    noise = noise + (wetness * 1.25 - 0.65) + height, 0.0;
    return smoothstep(0.4, 0.6, noise);
}

float rand(vec2 worldPos) {
    return fract(sin(dot(worldPos, vec2(12.9898, 4.1414))) * 43758.5453);
}

vec2 getpos(vec2 i) {
    return vec2(rand(i), rand(i + 1.0)) * 0.5 + 0.25;
}

float GetRipple(vec3 worldPos, vec2 offset) {
    vec2 ppos = worldPos.xz + offset * 0.1 + frameTimeCounter * 0.01;
    ppos = vec2(ppos.x * 0.8 + ppos.y * 0.8, ppos.x * - 0.8 + ppos.y * 0.8);
    vec2 ppossh = ppos + vec2(fract(0.618 * floor(ppos.y)) * sin(frameTimeCounter * 0.05), 0.0);
    vec2 pposfr = fract(ppossh);
    vec2 pposfl = floor(ppossh);

    float val = texture2D(noisetex, ppos / 128.0 + frameTimeCounter * 0.007).r * 0.15;
    val += texture2D(noisetex, ppos / 128.0 - frameTimeCounter * 0.005).r * 0.15;

    float seed = rand(pposfl);
    float rippleTime = frameTimeCounter * 1.4 + fract(seed * 1.618);
    float rippleSeed = seed + floor(rippleTime) * 1.618;
    vec2 ripplePos = getpos(pposfl + rippleSeed);
    float ripple = clamp01(1.0 - 2.0 * length(pposfr - ripplePos));
    ripple = clamp01(ripple + fract(rippleTime) - 1.0);
    ripple = sin(min(ripple * 6.0 * PI, 3.0 * PI)) * pow(1.0 - fract(rippleTime), 2.0);
    val += ripple * 0.3;

    return val;
}

vec3 GetPuddleNormal(vec3 worldPos, vec3 viewPos, mat3 tbn) {
    vec3 puddlePos = worldPos + cameraPosition;
    float normalOffset = 0.1;

    float fresnel = pow(clamp01(1.0 + dot(normalize(normal), normalize(viewPos))), 7.5);//4.5
    float normalStrength = 0.35 * (1.0 - fresnel);

    float h1 = GetRipple(puddlePos, vec2(normalOffset, 0.0));
    float h2 = GetRipple(puddlePos, vec2(- normalOffset, 0.0));
    float h3 = GetRipple(puddlePos, vec2(0.0, normalOffset));
    float h4 = GetRipple(puddlePos, vec2(0.0, - normalOffset));

    float xDelta = (h2 - h1) / normalOffset;
    float yDelta = (h4 - h3) / normalOffset;

    vec3 normalMap = vec3(xDelta, yDelta, 1.0 - (xDelta * xDelta + yDelta * yDelta));
    normalMap = normalMap * normalStrength + vec3(0.0, 0.0, 1.0 - normalStrength);

    return clampVec3Inv_11(normalize(normalMap * tbn));
}