vec4 RoughReflection(vec3 viewPos, vec3 normal, float dither, float smoothness) {
	vec4 color = vec4(0.0);
	float border = 0.0;

	vec4 pos = Raytrace(depthtex0, viewPos, normal, dither);
	border = clamp01(1.0 - pow(cdist(pos.st), 50.0));

	if (pos.z < 1.0 - EPS) {
		float lod = 0.0;
		#ifdef REFLECTION_ROUGH
			float dist = 1.0 - exp(- 0.125 * (1.0 - smoothness) * pos.a);
			lod = log2(viewHeight / 8.0 * (1.0 - smoothness) * dist) * 0.35;
		#endif

		float check = float(textureLod(depthtex0, pos.st, 0.0).r < 1.0 - EPS);
		if (lod < 1.0) {
			color.a = check;
			if (color.a > 0.1)
				color.rgb = textureLod(colortex0, pos.st, 0).rgb;
		} else {
			float alpha = check;
			if (alpha > 0.1) {
				color.rgb += textureLod(colortex0, pos.st, Max0(lod - 1.0)).rgb;
				color.a += alpha;
			}
		}

		color *= color.a;
		color.a *= border;
	}
	color.rgb *= 1.8 * (1.0 - 0.065 * min(length(color.rgb), 10.0));

	return color;
}