vec4 SimpleReflection(vec3 viewPos, vec3 normal, float dither) {
	vec4 color = vec4(0.0);
	float border = 0.0;

	vec4 pos = Raytrace(depthtex1, viewPos, normal, dither);
	border = clamp01(1.0 - pow(cdist(pos.st), 50.0));

	if (pos.z < 1.0 - EPS) {
		#if MC_VERSION > 10800
			color.a = texture2D(gaux2, pos.st).a;
			if (color.a > 0.001)
				color.rgb = texture2D(gaux2, pos.st).rgb;
		#else
			color.a = textureLod(gaux2, pos.st, 0).a;
			if (color.a > 0.001)
				color.rgb = textureLod(gaux2, pos.st, 0).rgb;
		#endif

		color.a *= border;
	}

	return color;
}
