#if defined OVERWORLD && defined STARS && defined STARS_REFLECTION
	if (moonVisibility > 0.0){
		lightNight *= max(pow(fresnel/9, 2), 0.00001);
		vec3 stars = vec3(0.0);
		if(skyRefFactor > 0.5) stars = DrawStars(albedo.rgb, skyRefPos * 100.0);

	#if MC_VERSION >= 11605
		skyReflection += stars.rgb * WATER_STARS_REFLECTION_STRENGTH * 0.5;
	#else
		skyReflection += stars.rgb * WATER_STARS_REFLECTION_STRENGTH * 2.0;
	#endif
		lightNight /= max(pow(fresnel/9, 2), 0.00001);
	}
#endif

#if defined OVERWORLD && defined SHOOTING_STARS && defined SHOOTING_STARS_REFLECTION
	if (moonVisibility > 0.0){
			skyReflection += DrawShootingStar(albedo.rgb, skyRefPos * 100.0, 1.0,dither);
	}
#endif

vec4 srpl = gbufferModelViewInverse*vec4(skyRefPos * 100, 1.0);
srpl /= srpl.w;
vec3 skyRefPosLunar = getLunarCoord(srpl.xyz);


#if defined OVERWORLD && defined CLOUDS_REFLECTION && REALISTIC_CLOUDS == 1
	if (isEyeInWater == 0){
	vec4 cloud = DrawCloud(skyRefPos * 100.0, dither, lightCol, ambientCol, 8);
	skyReflection = mix(skyReflection, cloud.rgb, cloud.a);
	}
#endif


#if defined OVERWORLD && defined SHININGSTARS && defined SHININGSTARS_REFLECTION
	if (moonVisibility > 0.0){
	#if defined CLOUDS_REFLECTION && REALISTIC_CLOUDS == 1
		float cloudMask = clamp01(cloud.a * 50.0);
	#else
		float cloudMask = 0.0;
	#endif

	skyReflection = mix(skyReflection,DrawConstellations(skyReflection,skyRefPosLunar.xyz,dither),
					(1.0-rainStrengthS)*(1.0-cloudMask)*moonVisibility*SHININGSTARS_REFLECTION_STRENGTH);
	}
#endif

#if defined OVERWORLD && PLANET >=1 && defined PLANET_REFLECTION
	skyReflection = mix(skyReflection.rgb,
					drawPlanetImage(skyReflection.rgb,skyReflection.rgb, vec2(0.2* PLANET_SIZE_X,0.2* PLANET_SIZE_Y), skyRefPosLunar.xyz, colortex9,PLANET_OPACITY),
					(1.0-rainStrengthS)*mix(PLANET_REFLECTION_STRENGTH_NIGHT,PLANET_REFLECTION_STRENGTH_DAY,sunVisibility)
					);
#endif

#if defined OVERWORLD && defined NEBULA && defined NEBULA_REFLECTION
	if (moonVisibility > 0.0){
	skyReflection = mix(skyReflection.rgb,
						drawNebulaImage(skyReflection.rgb, vec2(0.2* NEBULA_SIZE_X,0.2*NEBULA_SIZE_Y), skyRefPosLunar.xyz, colortex10,NEBULA_OPACITY),
						(1.0-rainStrengthS)*NEBULA_REFLECTION_STRENGTH_NIGHT
					);
	}
#endif

#if defined OVERWORLD && defined GALAXY && defined GALAXY_REFLECTION
	if (moonVisibility > 0.0){
	skyReflection = mix(skyReflection.rgb,
						drawGalaxyImage(skyReflection.rgb, vec2(0.2* GALAXY_SIZE_X,0.2*GALAXY_SIZE_Y), skyRefPosLunar.xyz, colortex11,GALAXY_OPACITY),
						(1.0-rainStrengthS)*GALAXY_REFLECTION_STRENGTH_NIGHT
					);
	}
#endif

#if defined OVERWORLD && defined AURORA && defined AURORA_REFLECTION
	if (moonVisibility > 0.0){
	skyReflection += DrawAurora(skyRefPos * 100.0, dither, 15);
	}
#endif