#include "/settings/glowingBlocksSettings.glsl"

void getEmissiveT(inout float emission, in vec4 detectcolor, inout vec4 albedo) {

    float lengthAlbedo = clamp01(length(albedo.rgb));

    /*
    Redstone
    */
    if (mat > 3.98 && mat < 4.02) {

        #ifdef NETHER
        emission = REDSTONE_BLOCK_BRIGHTNESS_NETHER * 0.25;
        #endif

        #ifdef END
        emission = REDSTONE_BLOCK_BRIGHTNESS_ENDER * 0.25;
        #endif

        #ifdef OVERWORLD
        emission = REDSTONE_BLOCK_BRIGHTNESS_OVERWORLD * 0.25;
        #endif
    }

    /*
    Lapis Lazuli
    */
    else if (mat > 4.98 && mat < 5.02) {

        #ifdef NETHER
        emission = LAPIS_BLOCK_BRIGHTNESS_NETHER * 0.25;
        #endif

        #ifdef END
        emission = LAPIS_BLOCK_BRIGHTNESS_ENDER * 0.25;
        #endif

        #ifdef OVERWORLD
        emission = LAPIS_BLOCK_BRIGHTNESS_OVERWORLD * 0.25;
        #endif
    }

    /*
    Candle
    */
    else if (mat > 5.98 && mat < 6.02) {
        emission = pow4(lengthAlbedo) * 0.01;
        #ifdef NETHER
        emission *= 1.0 + CANDLE_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission *= 1.0 + CANDLE_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission *= 1.0 + CANDLE_BRIGHTNESS_OVERWORLD;
        #endif
    }

    #ifdef GLOW_BERRIES
    else if (mat > 6.98 && mat < 7.02) {
        if (detectcolor.r > 0.1 && detectcolor.g > 0.77 && detectcolor.b > 0.10 && detectcolor.g < detectcolor.r) {

            #ifdef NETHER
            emission += GLOW_BERRIES_GLOWING_POWER_NETHER * 5.0;
            #endif
            #ifdef END
            emission += GLOW_BERRIES_GLOWING_POWER_ENDER * 5.0;
            #endif
            #ifdef OVERWORLD
            emission += GLOW_BERRIES_GLOWING_POWER * 5.0;
            #endif
        }
    }
    #endif

    #ifdef GLOW_SPORE_BLOSSOM
    else if (mat > 7.98 && mat < 8.02) {
        if (detectcolor.r > 0.1 && detectcolor.g > 0.20 && detectcolor.b < 0.32 && detectcolor.g < detectcolor.r) {

            #ifdef NETHER
            emission += GLOW_SPORE_BLOSSOM_GLOWING_POWER_NETHER * 5.0;
            #endif

            #ifdef END
            emission += GLOW_SPORE_BLOSSOM_GLOWING_POWER_ENDER * 5.0;
             #endif

            #ifdef OVERWORLD
            emission += GLOW_SPORE_BLOSSOM_GLOWING_POWER * 5.0;
            #endif
        }
    }
    #endif

    /*
    Lantern
    */
    else if (mat > 8.98 && mat < 9.02) {
        emission = float(lengthAlbedo > 0.9) * 0.25;

        #ifdef NETHER
        emission *= 1.0 + LANTERN_BRIGHTNESS_NETHER * 4.0;
        #endif

            #ifdef END
        emission *= 1.0 + LANTERN_BRIGHTNESS_ENDER * 4.0;
        #endif

        #ifdef OVERWORLD
        emission *= 1.0 + LANTERN_BRIGHTNESS_OVERWORLD * 4.0;
        #endif
    }

    /*
    Soul Lantern
    */
    else if (mat > 9.98 && mat < 10.02) {
        emission = float(lengthAlbedo > 0.9) * 0.125;

        #ifdef NETHER
        emission *= 1.0 + SOUL_LANTERN_BRIGHTNESS_NETHER * 8.0;
        #endif

        #ifdef END
        emission *= 1.0 + SOUL_LANTERN_BRIGHTNESS_ENDER * 8.0;
        #endif

        #ifdef OVERWORLD
        emission *= 1.0 + SOUL_LANTERN_BRIGHTNESS_OVERWORLD * 8.0;
        #endif
    }

    #ifdef GLOW_LICHEN
    else if (mat > 10.98 && mat < 11.02) {
        if (detectcolor.r > 0.25 && detectcolor.b > 0.15 && detectcolor.g > 0.10 && detectcolor.b < detectcolor.r) {

            #ifdef NETHER
            emission += GLOW_LICHEN_GLOWING_POWER_NETHER;
            #endif

            #ifdef END
            emission += GLOW_LICHEN_GLOWING_POWER_ENDER;
            #endif

            #ifdef OVERWORLD
            emission += GLOW_LICHEN_GLOWING_POWER;
            #endif
        }
    }
    #endif

    #ifdef GLOW_PICKLE
    else if (mat > 11.98 && mat < 12.02) {
        if (detectcolor.g > 0.8) {
            albedo.rgb = vec3(0.7725, 0.902, 0.5373);

            #ifdef NETHER
            emission += GLOW_PICKLE_GLOWING_POWER_NETHER;
            #endif

            #ifdef END
            emission += GLOW_PICKLE_GLOWING_POWER_ENDER;
            #endif

            #ifdef OVERWORLD
            emission += GLOW_PICKLE_GLOWING_POWER * (1.0 - moonVisibility * 0.8);
            #endif
        }
    }
    #endif

    /*
    Beacon
    */
    else if (mat > 12.98 && mat < 13.02) {

        #ifdef NETHER
        emission += BEACON_LANTERN_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission += BEACON_LANTERN_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission += BEACON_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Small Ametyst
    */
    else if (mat > 13.98 && mat < 14.02) {

        #ifdef NETHER
        emission += SMALL_AMETYST_BRIGHTNESS_NETHER * 0.1;
        #endif

        #ifdef END
        emission += SMALL_AMETYST_BRIGHTNESS_ENDER * 0.1;
        #endif

        #ifdef OVERWORLD
        emission += SMALL_AMETYST_BRIGHTNESS_OVERWORLD * 0.1;
        #endif
    }

    /*
    Medium Ametyst
    */
    else if (mat > 14.98 && mat < 15.02) {

        #ifdef NETHER
        emission += MEDIUM_AMETYST_BRIGHTNESS_NETHER * 0.1;
        #endif

        #ifdef END
        emission += MEDIUM_AMETYST_BRIGHTNESS_ENDER * 0.1;
        #endif

        #ifdef OVERWORLD
        emission += MEDIUM_AMETYST_BRIGHTNESS_OVERWORLD * 0.1;
        #endif
    }

    /*
    Large Ametyst
    */
    else if (mat > 15.98 && mat < 16.02) {

        #ifdef NETHER
        emission += LARGE_AMETYST_BRIGHTNESS_NETHER * 0.1;
        #endif

        #ifdef END
        emission += LARGE_AMETYST_BRIGHTNESS_ENDER * 0.1;
        #endif

        #ifdef OVERWORLD
        emission += LARGE_AMETYST_BRIGHTNESS_OVERWORLD * 0.1;
        #endif
    }

    /*
    Cluster Ametyst
    */
    else if (mat > 16.98 && mat < 17.02) {

        #ifdef NETHER
        emission += AMETYST_CLUSTER_BRIGHTNESS_NETHER * 0.1;
        #endif

        #ifdef END
        emission += AMETYST_CLUSTER_BRIGHTNESS_ENDER * 0.1;
        #endif

        #ifdef OVERWORLD
        emission += AMETYST_CLUSTER_BRIGHTNESS_OVERWORLD * 0.1;
        #endif
    }

    /*
    Enchanted Table Emissivness
    */
    else if (mat > 17.98 && mat < 18.02) {

        #ifdef NETHER
        emission += ENCHANTED_TABLE_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission += ENCHANTED_TABLE_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission += ENCHANTED_TABLE_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Magma Block
    */
    else if (mat > 18.98 && mat < 19.02) {

        #ifdef NETHER
        emission += MAGMA_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission += MAGMA_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission += MAGMA_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Sculk Catalyst
    */
    else if (mat > 19.98 && mat < 20.02) {

        #ifdef NETHER
        emission += SCULK_CATALYST_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission += SCULK_CATALYST_BRIGHTNESS_ENDER;
        #endif

            #ifdef OVERWORLD
        emission += SCULK_CATALYST_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Sculk Vein
    */
    else if (mat > 20.98 && mat < 21.02) {

        #ifdef NETHER
        emission += SCULK_VEIN_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission += SCULK_VEIN_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission += SCULK_VEIN_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Sculk Shrieker
    */
    else if (mat > 21.98 && mat < 22.02) {

        #ifdef NETHER
        emission += SCULK_SHRIEKER_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission += SCULK_SHRIEKER_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission += SCULK_SHRIEKER_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Sculk
    */
    else if (mat > 22.98 && mat < 23.02) {

        #ifdef NETHER
        emission += SCULK_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission += SCULK_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission += SCULK_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Sculk Sensor
    */
    else if (mat > 23.98 && mat < 24.02) {

        #ifdef NETHER
        emission += SCULK_SENSOR_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission += SCULK_SENSOR_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission += SCULK_SENSOR_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Fire / Soul Fire
    */
    else if (mat > 24.98 && mat < 25.02) {
        emission = pow4(lengthAlbedo) * 0.001;

        #ifdef NETHER
        emission *= 1.0 + FIRE_BRIGHTNESS_NETHER * 200;
        #endif

        #ifdef END
        emission *= 1.0 + FIRE_BRIGHTNESS_ENDER * 200;
        #endif

        #ifdef OVERWORLD
        emission *= 1.0 + FIRE_BRIGHTNESS_OVERWORLD * 200;
        #endif
    }

    /*
    Shroom Light
    */
    else if (mat > 25.98 && mat < 26.02) {

        #ifdef NETHER
        emission += SHROOMLIGHT_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission += SHROOMLIGHT_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission += SHROOMLIGHT_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Redstone Lamp
    */
    else if (mat > 26.98 && mat < 27.02) {

        #ifdef NETHER
        emission += REDSTONE_LAMP_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission += REDSTONE_LAMP_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission += REDSTONE_LAMP_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Sea Lantern
    */
    else if (mat > 27.98 && mat < 28.02) {
        emission = float(lengthAlbedo > 0.9) * 0.25;

        #ifdef NETHER
        emission *= 1.0 + SEA_LANTERN_BRIGHTNESS_NETHER * 4.0;
        #endif

        #ifdef END
        emission *= 1.0 + SEA_LANTERN_BRIGHTNESS_ENDER * 4.0;
        #endif

        #ifdef OVERWORLD
        emission *= 1.0 + SEA_LANTERN_BRIGHTNESS_OVERWORLD * 4.0;
        #endif
    }

    /*
    GlowStone
    */
    else if (mat > 28.98 && mat < 29.02) {

        #ifdef NETHER
        emission += GLOWSTONE_BRIGHTNESS_NETHER * 5.0;
        #endif

        #ifdef END
        emission += GLOWSTONE_BRIGHTNESS_ENDER * 5.0;
        #endif

        #ifdef OVERWORLD
        emission += GLOWSTONE_BRIGHTNESS_OVERWORLD * 10.0;
        #endif
    }

    /*
    Jack'o Lantern
    */
    else if (mat > 29.98 && mat < 30.02) {

        #ifdef NETHER
        emission += GLOWSTONE_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission += GLOWSTONE_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission += GLOWSTONE_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Torch / End_Rod
    */
    else if (mat > 30.98 && mat < 31.02) {
        emission = pow4(lengthAlbedo) * 0.001;
        #ifdef NETHER
        emission += TORCH_ENDROD_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission += TORCH_ENDROD_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission += TORCH_ENDROD_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Campfire
    */
    else if (mat > 31.98 && mat < 32.02) {

        #ifdef NETHER
        emission += CAMPFIRE_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission += CAMPFIRE_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission += CAMPFIRE_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Soul CampFire / Soul Fire / Soul Torch
    */
    else if (mat > 32.98 && mat < 33.02) {

        #ifdef NETHER
        emission += SCAMPFIRE_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission += SCAMPFIRE_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission += SCAMPFIRE_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Frog Light
    */
    else if (mat > 33.98 && mat < 34.02) {

        #ifdef NETHER
        emission += FROGLIGHT_BRIGHTNESS_NETHER;
        #endif

        #ifdef END
        emission += FROGLIGHT_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission += FROGLIGHT_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Crying Obsidian and Respawn Anchor
    */
    else if (mat > 40.98 && mat < 41.02) {
        emission = (detectcolor.b - detectcolor.r) * detectcolor.r;
        #ifdef NETHER
        emission += emission * CO_RA_BRIGHTNESS_NETHER * 10.0;
        #endif

        #ifdef END
        emission += emission * CO_RA_BRIGHTNESS_ENDER;
        #endif

        #ifdef OVERWORLD
        emission += emission * CO_RA_BRIGHTNESS_OVERWORLD;
        #endif
    }

    /*
    Brewing Stand
    */
    else if (mat > 45.98 && mat < 46.02) {
        emission = float(albedo.r > 0.5 && albedo.b < 0.4) * 1.5;
    }

    /*
    Emissive Ores
    */
        #ifdef EMISSIVE_ORES

    else if (mat > 39.98 && mat < 40.02) {
        float oresEmission = 0.0;
        float stoneDetect = max(abs(detectcolor.r - detectcolor.g), max(abs(detectcolor.r - detectcolor.b), abs(detectcolor.g - detectcolor.b)));
        float ores = Max0(Max0(stoneDetect - 0.175));
        oresEmission = ores * 2.0;

        #if PICKAXE_REVEAL > 0
            if ((heldItemId == 11000 || heldItemId2 == 11000)) {
            #if PICKAXE_REVEAL > 1

                float oscillation = 0;
                oscillation = sin(frameTimeCounter * 0.75);
                oscillation = pow2(oscillation);

                emission += oresEmission * EMISSIVE_ORES_BRIGHTNESS_STRENGTH * oscillation;

            #else

                emission += oresEmission * EMISSIVE_ORES_BRIGHTNESS_STRENGTH;

            #endif
            }
        #else
        emission += oresEmission * EMISSIVE_ORES_BRIGHTNESS_STRENGTH;
        #endif
    }
        #endif

}
