const vec2 blurOffsets4[4] = vec2[4](
	vec2(0.21848650099008202, -0.09211370200809937),
	vec2(-0.5866112654782878, 0.32153793477769893),
	vec2(-0.06595078555407359, -0.879656059066481),
	vec2(0.43407555004227927, 0.6502318262968816)
);

vec4 getDiskBlur4(sampler2D colortex, vec2 coord, float strength) {
	vec4 blur = vec4(0.0);

	for (int i = 0; i < 4; i ++) {
		vec2 pixelOffset = blurOffsets4 [i] * 1.0 / vec2(viewWidth, viewHeight) * strength;
		blur += texture2D(colortex, coord + pixelOffset);
	}

	blur *= 0.25;

	return blur;
}