/*//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##     //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##     //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####      //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##       //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####      //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##     //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##     //
//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####           //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##          //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #                //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####           //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##          //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####           //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////*/

//Settings//

#include "/lib/util/fastMath.glsl"

#include "/settings/globalSettings.glsl"

//Varyings//
varying vec2 texCoord;

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

    //Uniforms//
uniform sampler2D colortex1;

#ifdef SHARPEN_AA
uniform float viewWidth, viewHeight;
#endif

    //Common Functions//

#ifdef SHARPEN_AA
    #if AA > 1
        vec2 sharpenOffsets[4] = vec2[4](
                                vec2( 1.0,  0.0),
                                vec2( 0.0,  1.0),
                                vec2(-1.0,  0.0),
                                vec2( 0.0, -1.0)
        );

        void SharpenFilter(inout vec4 color, in vec2 texCoord) {
            float mult = MC_RENDER_QUALITY * 0.0625;
            vec2 view = 1.0 / vec2(viewWidth, viewHeight);

            color *= MC_RENDER_QUALITY * 0.25 + 1.0;

            for (int i = 0; i < 4; i ++) {
                vec2 offset = sharpenOffsets [i] * view;
                color -= textureLod(colortex1, texCoord + offset, 0) * mult;
            }
        }
    #endif
#endif

        //Program//
void main() {
    vec4 color = textureLod(colortex1, texCoord, 0);

    #ifdef SHARPEN_AA
        #if AA > 1
            SharpenFilter(color, texCoord);
        #endif
    #endif

        /*DRAWBUFFERS:1*/
    gl_FragData[0] = vec4(color);

}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

    //Program//
    void main(){
        texCoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

        gl_Position=ftransform();
    }

#endif