/*//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##     //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##     //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####      //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##       //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####      //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##     //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##     //
//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####           //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##          //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #                //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####           //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##          //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####           //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////*/

//Settings//

#include "/lib/util/fastMath.glsl"

#include "/settings/globalSettings.glsl"

//Varyings//
varying vec2 texCoord;

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

    //Uniforms//

uniform sampler2D colortex1;

#ifndef UNDERWATER_NO_BLUR_HAND
uniform sampler2D depthtex1;
#endif

#ifdef UNDERWATER_BLUR
uniform float viewWidth, viewHeight;
uniform int isEyeInWater;
#endif

    //Common Functions//

#ifndef UNDERWATER_NO_BLUR_HAND
    bool IsHand(float z) {
        return z < 0.56;
    }
#endif

#ifdef UNDERWATER_BLUR
vec4 underwaterBlur(out vec4 waterBlurCol, float z1) {

    vec2 uv = gl_FragCoord.xy / vec2(viewWidth, viewHeight);

    vec4 color = texture2D(colortex1, uv);

    float Size = UNDERWATER_BLUR_FACTOR;

    vec2 Radius = Size / vec2(viewWidth, viewHeight);

    #ifndef UNDERWATER_NO_BLUR_HAND
        if (IsHand(z1))
            return waterBlurCol = color;
    #endif

    for (float d = 0.0; d < TAU; d += TAU * 0.0625) {

        color += texture2D(colortex1, uv + vec2(cos(d), sin(d)) * Radius);

    }

    color *= 0.0625;

    return waterBlurCol = color;

}
#endif

    //Program//
void main() {
    vec4 color = texture2D(colortex1, texCoord);
    float z1 = 0.0;

    #ifndef UNDERWATER_NO_BLUR_HAND
        z1 = texture2D(depthtex1, texCoord).x;
    #endif

    #ifdef UNDERWATER_BLUR
        if (isEyeInWater == 1) {
            underwaterBlur(color, z1);
        }
    #endif

        /*DRAWBUFFERS:1*/
    gl_FragData[0] = vec4(color);

}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

    //Program//
void main() {
    texCoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

    gl_Position = ftransform();
}

#endif