/*//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##     //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##     //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####      //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##       //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####      //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##     //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##     //
//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####           //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##          //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #                //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####           //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##          //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####           //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////*/

//Settings//

#include "/lib/util/fastMath.glsl"

#include "/settings/globalSettings.glsl"

//Varyings//
varying vec2 texCoord;

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

    //Uniforms//
#ifdef HYPER_SPEED
    #ifdef ONLY_SPRINT
        uniform float sprintingSmooth;
    #endif
uniform float effectStrength;
uniform sampler2D depthtex1;
uniform int frameCounter;
#include "/lib/util/dither.glsl"
#endif

uniform sampler2D colortex1;

    //Program//
void main() {

    vec4 color = textureLod(colortex1, texCoord, 0);

    #ifdef HYPER_SPEED

        #ifndef ONLY_SPRINT
        float sprintingSmooth = 1.0;
        #endif

        float z = texelFetch(depthtex1, texelCoord, 0).x;
        float hand = float(z < 0.56);

        float dither = textureLod(colortex1, texCoord.xy * 0.0625, 0).r;

        if (hand < 0.5) {

            for (int i = 0; i < 16; i ++) {
                float f = float(i) + dither;
                float weight = 1.0 - abs(f * 0.125 - 1.0);
                vec3 sample = textureLod(colortex1, mix(texCoord, vec2(0.5), f * 0.03125 * sprintingSmooth * effectStrength * HYPERSPEED_MULTIPLIER), 0).rgb;
                color.rgb += pow2(sample) * weight;
                color.a += weight;
            }

            color.rgb *= (effectStrength + 1.0);
            color.rgb /= 8.0;
            color.rgb = sqrt(color.rgb);
            } else {
                color = textureLod(colortex1, texCoord, 0);
            }

	#endif

        /*DRAWBUFFERS:1*/
    gl_FragData[0] = vec4(color);
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

    //Program//
void main() {
    texCoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

    gl_Position = ftransform();
}

#endif