/*//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##     //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##     //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####      //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##       //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####      //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##     //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##     //
//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####           //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##          //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #                //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####           //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##          //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####           //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////*/

//Settings//

#include "/lib/util/fastMath.glsl"

#include "/settings/globalSettings.glsl"

//Varyings//
varying vec2 texCoord;

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

    //Uniforms//
uniform float viewWidth, viewHeight;

uniform sampler2D colortex1;

    #if AA > 0
        #ifndef KEEP_AA_ON_WATER
            #if MC_VERSION >= 11605
            uniform sampler2D colortex8;
            #endif
        #endif
    #endif

    //Common Functions//
float GetLuminance(vec3 color) {
    return dot(color, vec3(0.299, 0.587, 0.114));
}

    //Includes//

    #if AA == 1
    #ifdef FXAA_VERSION_1
    #include "/lib/antialiasing/fxaa.glsl"
    #endif

    #elif AA == 3
    #ifdef FXAA_VERSION_2
    #include "/lib/antialiasing/fxaa.glsl"
    #endif

    #elif AA == 4
    #ifdef FXAA_VERSION_2
    #include "/lib/antialiasing/fxaa.glsl"
    #endif
    #endif

    //Program//
void main() {
    vec3 color = texelFetch(colortex1, texelCoord, 0).rgb;
    bool water = false;

        #if AA > 0
            #ifndef KEEP_AA_ON_WATER
                #if MC_VERSION >= 11605
                    water = texelFetch(colortex8, texelCoord, 0).r > 0.5;
                #endif
            #endif
        #endif

        #if AA == 1 || AA == 3 || AA == 4
        if (! water)
        FXAA311(color);
        #endif

        /*DRAWBUFFERS:1*/
    gl_FragData[0] = vec4(color, 1.0);
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

    //Program//
    void main() {
        texCoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

        gl_Position = ftransform();
    }

#endif