/*//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##     //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##     //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####      //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##       //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####      //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##     //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##     //
//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####           //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##          //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #                //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####           //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##          //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####           //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////*/

//Settings//

#include "/lib/util/fastMath.glsl"

#include "/settings/globalSettings.glsl"

//Varyings//
varying vec2 texCoord;

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

    //Uniforms//
    #if defined FROSTED_LENS && defined OVERWORLD
        uniform float viewWidth, viewHeight;
    #endif

    #if defined FROSTED_LENS && defined FROSTED_LENS_DYNAMIC_HAND_LIGHT && defined OVERWORLD
	    uniform int heldItemId, heldItemId2;
        #include "/lib/lighting/colorLighting.glsl"
	#endif

    uniform sampler2D colortex1;

    #if defined FROSTED_LENS && defined OVERWORLD
        #if MC_VERSION < 11605
            uniform sampler2D noisetex;
        #endif
        #if MC_VERSION >= 11605
            uniform sampler2D colortex12;
        #endif
    #endif

    #if defined FROSTED_LENS && defined FROSTED_LENS_ONLY_RAIN && defined OVERWORLD
	    uniform float rainStrengthS2;
    #endif

    #if defined FROSTED_LENS && defined OVERWORLD
        uniform float biomeisColdSmooth;
        uniform ivec2 eyeBrightnessSmooth;
    #endif

    //Common Functions//
    #if defined FROSTED_LENS && defined OVERWORLD
        float eBS2 = clamp01((eyeBrightnessSmooth.y - 220) * 0.0666);
    #endif

    #if defined FROSTED_LENS && defined OVERWORLD

			float isColdSmooth = biomeisColdSmooth;

        float rand(vec2 uvFL) {

        uvFL = floor(uvFL * pow(10.0, 2.5)) / pow(10.0, 2.5);

        float a = dot(uvFL, vec2(92.0, 80.0));
        float b = dot(uvFL, vec2(41.0, 62.0));

        float x = sin(a) + cos(b) * 51.0;
        return fract(x);
        }

        void GetFrostedLens(out vec4 FrozenLensCol){

            	vec4 handLightColFL = vec4(0.5255, 0.5255, 0.5255, 0.5);

				#ifdef FROSTED_LENS_DYNAMIC_HAND_LIGHT
                    if (isLightHandled()){

					#ifdef COLORED_DYNAMIC_HAND_LIGHT
                        changeLightingColorByHand(handLightColFL.rgb);
                        handLightColFL.a = 1.0;
					#endif
				}
				#endif


                float frozenVisibility = eBS2;
                      frozenVisibility *= isColdSmooth;

                #ifdef FROSTED_LENS_ONLY_RAIN
                      frozenVisibility *= rainStrengthS2;
                #endif

                if (frozenVisibility < 0.1)
                frozenVisibility = 0.0;
                {
                vec4 frost = vec4(0.0);

                //Noise
                vec2 uvFL=gl_FragCoord.xy / vec2(viewWidth, viewHeight);

                #if MC_VERSION < 11605
                    frost = texture2D(noisetex, uvFL) * frozenVisibility;
                #endif
                #if MC_VERSION >=11605
                    frost = texture2D(colortex12, uvFL) * frozenVisibility;
                #endif

                vec2 rnd = vec2(rand(uvFL + frost.r * 0.5), rand(uvFL + frost.b * 0.5));

                //Vignette
                vec2 lens = vec2(0.5 * 7.5, 0.05);
                float dist = distance(uvFL.xy, vec2(0.5, 0.5));
                float vignette = pow(1.0 - smoothstep(lens.x, lens.y, dist), 2.0);

                //Rendu Final
                rnd *= frost.rg * vignette * FROSTYNESS;
                rnd *= 1.0 - floor(vignette);

                uvFL += rnd;

                //Coloration Vignette
                FrozenLensCol = mix(texture2D(colortex1, uvFL), handLightColFL, COLORIZE * vec4(rnd.r));
                }
        }
    #endif

    //Program//
    void main(){

        vec4 color = texture2D(colortex1, texCoord);

        #if defined FROSTED_LENS && defined OVERWORLD
        GetFrostedLens(color);
        #endif

        /*DRAWBUFFERS:1*/
        gl_FragData[0] = vec4(color);

    }

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

    //Program//
    void main(){
        texCoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

        gl_Position=ftransform();
    }

#endif