/*//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##     //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##     //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####      //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##       //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####      //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##     //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##     //
//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####           //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##          //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #                //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####           //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##          //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####           //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////*/

//Settings//

//#define DEBUG_ARMOR_GLINT

#include "/lib/util/fastMath.glsl"

#include "/settings/globalSettings.glsl"

//Varyings//
varying vec2 texCoord;
varying vec4 color;
varying vec4 position;

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

    //Uniforms//
    uniform sampler2D texture;
    uniform float frameTimeCounter;

    //Includes//
    #ifdef MAGICAL_GLINT
        #include "/lib/color/hue.glsl"
    #endif

    //Program//
    void main(){

        vec4 multiplier = color;

        #ifdef MAGICAL_GLINT
            multiplier = vec4(hue2(frameTimeCounter * MAGICAL_GLINT_SPEED * 2.0), 1.0);
        #endif

        vec4 albedo = textureLod(texture, texCoord, 0) * multiplier;

        #if MC_VERSION >= 11500
            albedo = pow(albedo, vec4(vec3(1.6), 1.0));
            albedo *= 0.2;
        #else
            albedo = pow(albedo, vec4(vec3(2.2), 1.0));
        #endif

        albedo = clamp01(albedo * GLINT_INTENSITY);

        /*DRAWBUFFERS:0*/

        #ifdef DEBUG_ARMOR_GLINT
            gl_FragData[0]=vec4(0.898, 1.0, 0.0, 0.75);
        #else
            gl_FragData[0] = vec4(albedo);
        #endif

    }

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

    //Uniforms//

    uniform mat4 gbufferModelViewInverse;

    uniform float frameTimeCounter;

    //Program//
    void main(){
            texCoord=(gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

            color=gl_Color;

            position=gbufferModelViewInverse * gl_ModelViewMatrix * gl_Vertex;

            vec4 temppos=gl_ProjectionMatrix * gbufferModelView * position;

            if((temppos.z/temppos.w) < 0.56)//hand
            {

                #ifdef MOUVEMENTS_MAINS
                    position-=vec4(0.03 * sin(frameTimeCounter * 3.0 * SPEED_MOOVE), 0.015 * cos(frameTimeCounter * 4.0 * SPEED_MOOVE), 0.0, 0.0) * gbufferModelView;
                #endif

                #ifdef MOUVEMENTS_MAINS_2
                    position.y+=sin(frameTimeCounter * 3.0 * SPEED_MOOVE) * 0.015;
                    position.z-=cos(frameTimeCounter * 4.0 * SPEED_MOOVE) * 0.0015;
                #endif

                position=gbufferModelView * position;

                position.z-=ADVANCE_HAND_POS;
                position.y+=ADVANCE_HAND_POS2;
                position.x+=DECALLAGE_MAINS;

                gl_Position=gl_ProjectionMatrix * position;
            }
            else
            {
                gl_Position = ftransform();
            }

    }
#endif