/*//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##     //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##     //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####      //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##       //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####      //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##     //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##     //
//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####           //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##          //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #                //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####           //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##          //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####           //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////*/

//Settings//

//#define DEBUG_BASIC

#include "/lib/util/fastMath.glsl"

#include "/settings/globalSettings.glsl"

//Varyings//
varying vec2 texCoord, lmCoord;

varying vec3 normal;
varying vec3 sunVec, upVec, eastVec;

varying vec4 color;

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

	//Uniforms//
	uniform sampler2D noisetex;
	uniform int frameCounter;
	uniform int isEyeInWater;
	uniform int heldItemId;
	uniform int heldItemId2;
	uniform int moonPhase;
	#define UNIFORM_MOONPHASE

	uniform int heldBlockLightValue;
	uniform int heldBlockLightValue2;

	uniform float frameTimeCounter;
	uniform float nightVision;
	uniform float rainStrengthS;
	uniform float screenBrightness;
	uniform float far;
	uniform float viewWidth, viewHeight;

	#ifdef ENABLE_DARKNESS_EFFECT
		#if MC_VERSION >= 11900
			uniform float darknessFactor;
			uniform float darknessLightFactor;
		#endif
	#endif

	uniform ivec2 eyeBrightnessSmooth;

	uniform vec3 cameraPosition;
	uniform vec3 fogColor;

	uniform mat4 gbufferProjectionInverse;
	uniform mat4 gbufferModelViewInverse;
	uniform mat4 shadowProjection;
	uniform mat4 shadowModelView;

	#if MC_VERSION >= 11700
		uniform int renderStage;
	#endif

	//Common Variables//

	float eBS              =eyeBrightnessSmooth.y / 240.0;
	float sunVisibility    =clamp00125(dot( sunVec,upVec) + 0.0625) * 8.0;
	float moonVisibility   =clamp00125(dot( -sunVec,upVec) + 0.0625) * 8.0;
	float screenBrightness2=clamp01(screenBrightness);

	#ifdef OVERWORLD
		vec3 lightVec = sunVec * ((timeAngle < 0.5325 || timeAngle > 0.9675) ? 1.0 : -1.0);
	#else
		vec3 lightVec = sunVec;
	#endif

	//Common Functions//
	float GetLuminance(vec3 color){
		return dot(color,vec3(0.299, 0.587, 0.114));
	}

	//Includes//
	#include "/lib/util/dither.glsl"
	#include "/lib/color/blocklightColor.glsl"
	#include "/lib/color/dimensionColor.glsl"
	#include "/lib/util/spaceConversion.glsl"

	#if defined WATER_CAUSTICS && defined OVERWORLD
	#include "/lib/color/waterColor.glsl"
	#endif

	#include "/lib/lighting/forwardLighting.glsl"

	#if COLOR_BLOC_SELECTOR > 0
	#include "/lib/color/selectionColor.glsl"
	#include "/lib/color/hue.glsl"
	#endif

	#if AA > 1
	#include "/lib/util/jitter.glsl"
	#endif

	//Program//
	void main(){
		vec4 albedo = color;

		if (albedo.a > 0.00001){

			vec2 lightmap = clampVec2_01(lmCoord);

			vec3 screenPos = vec3(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z);

			#if AA > 1
				vec3 viewPos = ScreenToView(vec3(TAAJitter(screenPos.xy, -0.5), screenPos.z));
			#else
				vec3 viewPos = ScreenToView(screenPos);
			#endif

			vec3 worldPos = ViewToWorld(viewPos);


			albedo.rgb = pow(albedo.rgb, vec3(2.2));
			albedo.a = albedo.a * 0.5 + 0.5;

			#ifdef WHITE_WORLD
				if (albedo.a > 0.9) albedo.rgb = vec3(0.5);
			#endif

			#ifdef BLACK_WORLD
				if (albedo.a > 0.9) albedo.rgb = vec3(0.0);
			#endif


			float NoL            =clamp01(dot(normal, lightVec) * 1.01 - 0.01);
			float NoU            =clampInv11(dot(normal, upVec));
			float NoE            =clampInv11(dot(normal, eastVec));
			float vanillaDiffuse =(0.25 * NoU + 0.75) + (0.667 - abs(NoE)) * (1.0 - abs(NoU)) * 0.15;
			      vanillaDiffuse*=vanillaDiffuse;

			vec3 shadow = vec3(0.0);
			GetLighting(albedo.rgb, shadow, viewPos, worldPos, lightmap, 1.0, NoL, vanillaDiffuse,
			1.0, 0.0, 0.0);

			#if MC_VERSION >= 11700
				if (renderStage == 14) {
			#else
				if (albedo.rgb == vec3(0.0) && albedo.a > 0.5) {
			#endif

			#if COLOR_BLOC_SELECTOR == 0
				albedo.a = 1.0;

			#elif COLOR_BLOC_SELECTOR == 1
				if (albedo.rgb == vec3(0.0)) albedo.rgb = selectionCol;

			#elif COLOR_BLOC_SELECTOR == 2
				if (albedo.rgb == vec3(0.0)){
					albedo = clamp01(vec4(hue2(frameTimeCounter * RAINBOW_COLOR_BLOC_SELECTOR_SPEED ), 1.0));
					albedo = pow(albedo, vec4(2.2)) * COMPOSANTE_I * 0.5;
				}

			#elif COLOR_BLOC_SELECTOR == 3
				if (albedo.rgb == vec3(0.0)){
					float worldPosCBSA =worldPos.x + worldPos.y + worldPos.z;
					float cameraPosCBSA=cameraPosition.x + cameraPosition.y + cameraPosition.z;
					float finalPosCBSA =worldPosCBSA + cameraPosCBSA;
					      albedo       =clamp01(vec4(hue2(frameTimeCounter * HARLEQUIN_COLOR_BLOC_SELECTOR_SPEED + finalPosCBSA * CBSA_OBSTRUCTION), 1.0));
					      albedo       =pow(albedo, vec4(2.2)) * COMPOSANTE_I * 0.5;
				}
			#endif
			}

			}else discard;

		/*DRAWBUFFERS:0*/
		#ifdef DEBUG_BASIC
            gl_FragData[0]=vec4(1.0, 0.6, 0.0, 0.75);
		#else
			gl_FragData[0] = vec4(albedo);
		#endif

		#ifdef ADVANCED_MATERIALS
		/*DRAWBUFFERS:0361*/
		gl_FragData[1] = vec4(0.0, 0.0, 0.0, 1.0);
		gl_FragData[2] = vec4(0.0, 0.0, float(gl_FragCoord.z < 1.0), 1.0);
		gl_FragData[3] = vec4(0.0, 0.0, 0.0, 1.0);
		#endif
	}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

	//Uniforms//
	uniform int frameCounter;

	uniform float viewWidth, viewHeight;

	uniform vec3 cameraPosition;

	uniform mat4 gbufferModelViewInverse;

	#if MC_VERSION >= 11700
		uniform int renderStage;
	#endif

	//Includes//
	#if AA > 1
		#include "/lib/util/jitter.glsl"
	#endif

	//Program//
	void main(){
		texCoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

		lmCoord  = getLightMapCoord();

		normal=normalize(gl_NormalMatrix*gl_Normal);

		color=gl_Color;

		upVec=normalize(gbufferModelView[1].xyz);
		eastVec=normalize(gbufferModelView[0].xyz);
		vec2 sunRotationData = getSunRotationData();
		vec3 usunvec = getUsunvec(sunRotationData);
		sunVec = getSunVec(usunvec, sunRotationData);

		#ifndef GBUFFERS_LINE

		gl_Position = ftransform();

		#else

		float lineWidth          =3.0;
		vec2  screenSize         =vec2(viewWidth, viewHeight);
		const mat4 VIEW_SCALE    =mat4(mat3(1.0 - (1.0 / 256.0)));
		vec4  linePosStart       =projectionMatrix * VIEW_SCALE * modelViewMatrix * vec4(vaPosition, 1.0);
		vec4  linePosEnd         =projectionMatrix * VIEW_SCALE * modelViewMatrix * (vec4(vaPosition + vaNormal, 1.0));
		vec3  ndc1               =linePosStart.xyz / linePosStart.w;
		vec3  ndc2               =linePosEnd.xyz / linePosEnd.w;
		vec2  lineScreenDirection=normalize((ndc2.xy - ndc1.xy) * screenSize);
		vec2  lineOffset         =vec2(-lineScreenDirection.y, lineScreenDirection.x) * lineWidth / screenSize;
			if (lineOffset.x < 0.0)
				lineOffset*=-1.0;
			if (gl_VertexID % 2 == 0)
				gl_Position=vec4((ndc1 + vec3(lineOffset, 0.0)) * linePosStart.w, linePosStart.w);
			else
				gl_Position=vec4((ndc1 - vec3(lineOffset, 0.0)) * linePosStart.w, linePosStart.w);
		#endif

		#if AA > 1
			gl_Position.xy=TAAJitter(gl_Position.xy, gl_Position.w);
		#endif
	}

#endif