/*//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##     //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##     //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####      //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##       //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####      //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##     //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##     //
//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####           //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##          //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #                //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####           //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##          //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####           //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////*/

//Settings//

//#define DEBUG_SKYTEXTURED

#include "/lib/util/fastMath.glsl"

#include "/settings/globalSettings.glsl"

//Varyings//

#if defined END || (defined OVERWORLD && defined VANILLA_SKYBOX)
varying vec2 texCoord;

varying vec4 color;
#endif

#if defined OVERWORLD && defined VANILLA_SKYBOX
varying vec3 upVec, sunVec;
#endif

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

	//Uniforms//
	uniform sampler2D noisetex;
	uniform float nightVision;
	uniform float rainStrengthS;
	uniform float screenBrightness;
	uniform float viewWidth, viewHeight;

	uniform ivec2 eyeBrightnessSmooth;

	uniform mat4 gbufferProjectionInverse;

	uniform vec3 skyColor;
	uniform vec3 fogColor;

	uniform sampler2D texture;

	uniform vec3 cameraPosition;

	uniform mat4 gbufferModelViewInverse;

	#ifdef UNDERGROUND_SKY
		uniform int isEyeInWater;
	#endif

	#if MC_VERSION >= 11700 && defined OVERWORLD && defined VANILLA_SKYBOX && defined HORIZON_SUN_MOON
		uniform int renderStage;
	#endif

	//Common Variables//

	#if defined OVERWORLD && defined VANILLA_SKYBOX
		float eBS              =eyeBrightnessSmooth.y / 240.0;
		float sunVisibility    =clamp00125(dot( sunVec,upVec) + 0.0625) * 8.0;
		float moonVisibility   =clamp00125(dot( -sunVec,upVec) + 0.0625) * 8.0;
	#endif

	float screenBrightness2=clamp01(screenBrightness);

	//Common Functions//
	float GetLuminance(vec3 color){
		return dot(color,vec3(0.299, 0.587, 0.114));
	}

	//Includes//

	#if defined OVERWORLD && defined VANILLA_SKYBOX
		#include "/lib/color/lightColor.glsl"
	#endif

	//Program//
	void main(){

		#if defined OVERWORLD && defined VANILLA_SKYBOX
			vec4 albedo    =texture2D(texture, texCoord.xy);
			vec4 screenPos =vec4(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z, 1.0);
			vec4 viewPos   =gbufferProjectionInverse * (screenPos * 2.0 - 1.0);
			     viewPos  /=viewPos.w;

			vec3 nViewPos = normalize(viewPos.xyz);

				#ifdef HORIZON_SUN_MOON

				float NdotU = dot(nViewPos, upVec);

					#if MC_VERSION >= 11700
						if (renderStage > 3)
					#endif
					albedo.a *= clamp01((NdotU+0.02)*10);
				#endif

				albedo *= color;

				albedo.rgb = pow(sqrt(albedo.rgb), vec3(2.2 + sunVisibility * 2.2)) * (1.0 + sunVisibility * 4.0) * (SKYBOX_BRIGHTNESS * 0.25) * albedo.a;

				#ifdef UNDERGROUND_SKY
					if (isEyeInWater == 0){
					albedo.rgb *= mix(clamp01((cameraPosition.y - 48.0) / 16.0), 1.0, eBS);
					}
				#endif
		#else

			vec4 albedo = vec4(0.0);

		#endif

		/*DRAWBUFFERS:0*/

		#ifdef DEBUG_SKYTEXTURED
            gl_FragData[0]=vec4(0.0667, 0.0, 1.0, 0.75);
		#else
			gl_FragData[0]=clamp01(albedo);
		#endif
	}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

	//Uniforms//
	#if defined OVERWORLD && defined VANILLA_SKYBOX
		#if AA > 1
			uniform int frameCounter;
			uniform float viewWidth, viewHeight;
			#include "/lib/util/jitter.glsl"
		#endif
	#endif

	//Program//
	void main(){
		#if defined END || (defined OVERWORLD && defined VANILLA_SKYBOX)

			texCoord=(gl_TextureMatrix[0]*gl_MultiTexCoord0).xy;

			color=gl_Color;

			gl_Position=ftransform();

		#endif

		#if defined OVERWORLD && defined VANILLA_SKYBOX

			upVec = normalize(gbufferModelView[1].xyz);
			vec2 sunRotationData = getSunRotationData();
			vec3 usunvec = getUsunvec(sunRotationData);
			sunVec = getSunVec(usunvec, sunRotationData);

			#if AA > 1
				gl_Position.xy=TAAJitter(gl_Position.xy, gl_Position.w);
			#endif

		#else
				#if !defined END
					vec4 color = vec4(0.0);
					gl_Position = color;
				#endif
		#endif
	}

#endif