/*//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##     //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##     //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####      //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##       //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####      //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##     //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##     //
//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####           //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##          //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #                //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####           //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##          //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####           //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////*/

//Settings//

#include "/lib/util/fastMath.glsl"

#include "/settings/globalSettings.glsl"

//Varyings//
varying vec2 texCoord;

varying vec4 position;
varying vec4 color;
//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

	//Uniforms//
	uniform sampler2D texture;
	uniform int entityId;

	//Program//
	void main(){
		vec4 albedo = texture2D(texture, texCoord) * color;

		albedo.rgb = pow(albedo.rgb,vec3(2.2));

		#ifdef WHITE_WORLD
			#ifdef SPIDER_EYESW
				albedo.rgb = vec3(2.0);
			#endif
		#endif

		#ifdef COLORED_EYES
		if (entityId != 18214){
			#if SPIDER_EYES == 1
				albedo.rgb=vec3(1.0, 0.0, 0.0) * 4.0;

			#elif SPIDER_EYES == 2
				albedo.rgb=vec3(0.749, 0.0, 1.0) * 4.0;

			#elif SPIDER_EYES == 3
				albedo.rgb=vec3(0.0, 0.0157, 1.0) * 15.0;

			#elif SPIDER_EYES == 4
				albedo.rgb=vec3(0.0, 0.1333, 0.0235);

			#elif SPIDER_EYES == 5
				albedo.rgb=vec3(1.0, 0.9333, 0.0078) * 4.0;
			#endif
		}
		#endif

		if (entityId == 18214) albedo.a*=0.8;

		/*DRAWBUFFERS:0*/
		gl_FragData[0] = clamp01(albedo);

		#ifdef ADVANCED_MATERIALS

		/*DRAWBUFFERS:0361*/
		gl_FragData[1]=vec4(0.0, 0.0, 0.0, 1.0);
		gl_FragData[2]=vec4(0.0, 0.0, 0.0, 1.0);
		gl_FragData[3]=vec4(0.0, 0.0, 0.0, 1.0);
		#endif
	}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

	//Uniforms//

	uniform mat4 gbufferModelViewInverse;

	uniform float frameTimeCounter;

	//Program//
	void main(){
		texCoord=(gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

		color = gl_Color;

		vec4 position=gbufferModelViewInverse * gl_ModelViewMatrix * gl_Vertex;

		gl_Position=ftransform();

	}

#endif