/*//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##     //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##     //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####      //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##       //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####      //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##     //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##     //
//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####           //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##          //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #                //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####           //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##          //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####           //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////*/

//Settings//

//#define DEBUG_TEXTURED

#include "/lib/util/fastMath.glsl"

#include "/settings/globalSettings.glsl"

//Varyings//

#if !defined OUTLINE_TRIPWIRE && MC_VERSION >= 11605
varying float isTripwire;
#endif

varying vec2 texCoord, lmCoord;

varying vec3 normal;
varying vec3 sunVec, upVec, eastVec;

varying vec4 color;

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

	//Uniforms//
	uniform int frameCounter;
	uniform int isEyeInWater;
	uniform int heldItemId;
	uniform int heldItemId2;

	uniform int heldBlockLightValue;
	uniform int heldBlockLightValue2;

	uniform float far, near;
	uniform float frameTimeCounter;
	uniform float blindFactor, darknessFactor, nightVision;
	uniform float rainStrength;
	uniform float rainStrengthS;
	uniform float screenBrightness;
	uniform float viewWidth, viewHeight;

	uniform ivec2 eyeBrightnessSmooth;

	#if (defined FOG || defined PARTICLES_EMISSION) && MC_VERSION >= 11500
	uniform ivec2 atlasSize;
	#endif

	uniform sampler2D noisetex;

	uniform vec3 cameraPosition;

	uniform vec3 skyColor;
	uniform vec3 fogColor;

	uniform mat4 gbufferProjectionInverse;
	uniform mat4 gbufferModelViewInverse;
	uniform mat4 shadowProjection;
	uniform mat4 shadowModelView;

	uniform sampler2D texture;

	#if MC_VERSION >= 11700
		uniform ivec4 blendFunc;
	#endif

	#ifdef SOFT_PARTICLES
		uniform sampler2D depthtex0;
	#endif

	#ifdef ENABLE_DARKNESS_EFFECT
		#if MC_VERSION >= 11900
			uniform float darknessLightFactor;
		#endif
	#endif

	//Common Variables//

	float eBS              =eyeBrightnessSmooth.y / 240.0;
	float sunVisibility    =clamp00125(dot( sunVec,upVec) + 0.0625) * 8.0;
	float moonVisibility   =clamp00125(dot( -sunVec,upVec) + 0.0625) * 8.0;
	float screenBrightness2=clamp01(screenBrightness);

	#ifdef OVERWORLD
		vec3 lightVec = sunVec * ((timeAngle < 0.5325 || timeAngle > 0.9675) ? 1.0 : -1.0);
	#else
		vec3 lightVec = sunVec;
	#endif

	//Common Functions//
	float GetLuminance(vec3 color){
		return dot(color,vec3(0.299, 0.587, 0.114));
	}

	#ifdef SOFT_PARTICLES
		float GetLinearDepth(float depth) {
			return (2.0 * near) / (far + near - depth * (far - near));
		}
	#endif

	//Includes//
	#if defined NETHER || defined END
		#include "/lib/color/lightColor.glsl"
	#endif

	#include "/lib/color/blocklightColor.glsl"
	#include "/lib/color/dimensionColor.glsl"
	#include "/lib/color/skyColor.glsl"
	#include "/lib/color/waterColor.glsl"
	#include "/lib/util/dither.glsl"
	#include "/lib/atmospherics/waterFog.glsl"
	#include "/lib/util/spaceConversion.glsl"
	#include "/lib/atmospherics/sky.glsl"
	#include "/lib/atmospherics/fog.glsl"
	#include "/lib/lighting/forwardLighting.glsl"

	#if defined WATER_CAUSTICS && defined OVERWORLD
	#include "/lib/lighting/caustics.glsl"
	#endif

	#if AA > 1
	#include "/lib/util/jitter.glsl"
	#endif

	//Program//
	void main(){
		vec4 albedo = vec4(0.0);
		vec4 albedoT = texture2D(texture, texCoord);
			 albedo = albedoT * color;
		vec3 vlAlbedo = vec3(1.0);
		float emission = 0.0;


		if (albedo.a > 0.0){
			vec2 lightmap=clampVec2_01(lmCoord);

			vec3 screenPos = vec3(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z);
			#if AA > 1
				vec3 viewPos = ScreenToView(vec3(TAAJitter(screenPos.xy, -0.5), screenPos.z));
			#else
				vec3 viewPos = ScreenToView(screenPos);
			#endif

			vec3  worldPos =ViewToWorld(viewPos);
			float lViewPos =length(viewPos);

			#if MC_VERSION >= 11700
				if (blendFunc == ivec4(770, 1, 1, 0)) {
					albedo.a = albedoT.a * color.a * 0.2;
					lightmap = vec2(1.0);
				}
			#endif

			albedo.rgb = pow(albedo.rgb, vec3(2.2));

			#ifdef WHITE_WORLD
				#ifdef TEXTURESW
				albedo.rgb = vec3(0.5);
				#endif
			#endif

			#ifdef BLACK_WORLD
				#ifdef TEXTURESW
					albedo.rgb = vec3(0.0);
				#endif
			#endif

			float NoL            =1.0;
			      NoL            =clamp01(dot(normal, lightVec) * 1.01 - 0.01);
			float NoU            =clampInv11(dot(normal, upVec));
			float NoE            =clampInv11(dot(normal, eastVec));
			float vanillaDiffuse =(0.25 * NoU + 0.75) + (0.667 - abs(NoE)) * (1.0 - abs(NoU)) * 0.15;
			      vanillaDiffuse*=vanillaDiffuse;


			#if defined PARTICLES_EMISSION && MC_VERSION >= 11500
				if (atlasSize.x < 900.0) {
				float lAlbedo = length(albedo.rgb);

					/*
					Grayscale Particles
					*/

						if (max(abs(albedoT.r - albedoT.b), abs(albedoT.b - albedoT.g)) < 0.0001) {

					/*
					Ender Particle / Crying Obsidian Drop
					*/

						if (lAlbedo > 0.5 && color.g < 0.5 && color.b > color.r * 1.1 && color.r > 0.3)
								emission = max(pow2(albedo.r), 0.1);

					/*
					Redstone Particles
					*/

						if (lAlbedo > 0.5 && color.g < 0.5 && color.r > (color.g + color.b) * 3.0)
								lightmap = vec2(0.0), emission = max(pow2(albedo.r), 1.0);
					}
				}
			#endif

			vec3 shadow = vec3(0.0);
			GetLighting(albedo.rgb, shadow, viewPos, worldPos, lightmap, 1.0, NoL, 1.0,
			1.0, clamp(emission, 0.0, 0.1), 0.0);

			albedo.rgb *= 1.5;

			#if defined FOG && MC_VERSION >= 11500
			vlAlbedo = mix(vec3(1.0), albedo.rgb, sqrt1(albedo.a)) * (1.0 - pow(albedo.a, 64.0));
			if (atlasSize.x > 5.0) {
				albedo.rgb = Fog(albedo.rgb, viewPos);
			}
			#endif

			#if defined WATER_CAUSTICS && defined OVERWORLD
				#include "/lib/lighting/causticsCall.glsl"
			#endif

		}else discard;

		#ifdef SOFT_PARTICLES
			float linearZ    =GetLinearDepth(gl_FragCoord.z) * (far - near);
			float backZ      =texture2D(depthtex0, gl_FragCoord.xy / vec2(viewWidth, viewHeight)).r;
			float linearBackZ=GetLinearDepth(backZ) * (far - near);

			float difference=clamp01(linearBackZ - linearZ);
			      difference=pow2(difference) * (3.0 - 2.0 * difference);

			float opaqueThreshold=InterleavedGradientNoise();

			if (albedo.a > 0.999) albedo.a *= float(difference > opaqueThreshold);
			else albedo.a *= difference;
		#endif

		/*DRAWBUFFERS:017*/

		#ifdef DEBUG_TEXTURED
            gl_FragData[0]=vec4(0.0353, 1.0, 0.0, 0.75);
		#else
			gl_FragData[0] = vec4(albedo);
		#endif

		gl_FragData[1] = vec4(vlAlbedo, 1.0);
		gl_FragData[2] = vec4(1.0, 1.0, 1.0, 1.0);


		#if defined ADVANCED_MATERIALS && defined REFLECTION_SPECULAR && MC_VERSION < 11500
		/*DRAWBUFFERS:01736*/
		gl_FragData[3] = vec4(0.0, 0.0, 0.0, 1.0);
		gl_FragData[4] = vec4(0.0, 0.0, 0.0, 1.0);
		#endif

		#if !defined OUTLINE_TRIPWIRE && MC_VERSION >= 11605
		/*DRAWBUFFERS:017368*/
		gl_FragData[5] = vec4(0.0, isTripwire, 0.0, 1.0);
		#endif
	}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

	//Uniforms//

	#if AA > 1
		uniform int frameCounter;
		uniform float viewWidth,viewHeight;
	#endif

	uniform float frameTimeCounter;

	uniform vec3 cameraPosition;

	uniform mat4 gbufferModelViewInverse;

	//Attributes//
	attribute vec4 mc_Entity;
	attribute vec4 mc_midTexCoord;

	#ifdef SOFT_PARTICLES
		uniform float far,near;
	#endif

	//Common Functions//
	#ifdef SOFT_PARTICLES
		float GetLinearDepth(float depth) {
		return (2.0 * near) / (far + near - depth * (far - near));
		}
		float GetLogarithmicDepth(float depth) {
			return -(2.0 * near / depth - (far + near)) / (far - near);
		}
	#endif

	//Includes//
	#if AA > 1
	#include "/lib/util/jitter.glsl"
	#endif

	//Program//
	void main(){
		texCoord=(gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

		lmCoord  = getLightMapCoord();

		normal=normalize(gl_NormalMatrix * gl_Normal);

		color=gl_Color;

		upVec  =normalize(gbufferModelView[1].xyz);
		eastVec=normalize(gbufferModelView[0].xyz);
		vec2 sunRotationData = getSunRotationData();
		vec3 usunvec = getUsunvec(sunRotationData);
		sunVec = getSunVec(usunvec, sunRotationData);

		gl_Position=ftransform();

		#if !defined OUTLINE_TRIPWIRE && MC_VERSION >= 11605
			isTripwire = 0.0;
		#endif

		/*
		Tripwire
		*/

		if (mc_Entity.x == 11008){
		#ifdef INVISIBLE_TRIPWIRE
			color.a = 0.0;
		#else
			color.a = 1.0;
		#endif
		}

		#if !defined OUTLINE_TRIPWIRE && MC_VERSION >= 11605
		if (mc_Entity.x == 11008)
				lmCoord.x *= 0.9, isTripwire = 1.0, color.a;
		#else
		if (mc_Entity.x == 11008)
				lmCoord.x *= 0.9, color.a;
		#endif


		#ifdef SOFT_PARTICLES
			gl_Position.z = GetLinearDepth(gl_Position.z / gl_Position.w) * (far - near);
			gl_Position.z -= 0.25;
			gl_Position.z = GetLogarithmicDepth(gl_Position.z / (far - near)) * gl_Position.w;
		#endif

		#if AA > 1
			gl_Position.xy = TAAJitter(gl_Position.xy, gl_Position.w);
		#endif

		gl_Position.z -= 0.000002;
	}

#endif