/*//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##     //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##     //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####      //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##       //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####      //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##     //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##     //
//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####           //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##          //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #                //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####           //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##          //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####           //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////*/

//Settings//

//#define DEBUG_WATER

#include "/lib/util/fastMath.glsl"

#include "/settings/globalSettings.glsl"

//Varyings//
varying float mat;
varying float dist;

varying float isWater;

varying vec2 texCoord, lmCoord;

varying vec3 normal;
varying vec3 binormal, tangent;
varying vec3 sunVec, upVec, eastVec;
varying vec3 viewVector;

varying vec4 color;
varying vec4 position;

varying mat3 moonRotMatrix;

#if PLANET >= 1
varying mat3 planetRotMatrix;
#endif
#ifdef NEBULA
varying mat3 nebulaRotMatrix;
#endif
#ifdef GALAXY
varying mat3 galaxyRotMatrix;
#endif

#if defined ADVANCED_MATERIALS || defined NEW_NETHER_PORTAL
	varying vec4 vTexCoord, vTexCoordAM;
#endif

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

	//Uniforms//
	uniform int frameCounter;
	uniform int isEyeInWater;
	uniform int heldItemId, heldItemId2;
	uniform int moonPhase;
	#define UNIFORM_MOONPHASE

	uniform int heldBlockLightValue;
	uniform int heldBlockLightValue2;

	#ifndef WEATHER_PERBIOME
		uniform float isCold;
	#endif

	uniform float blindFactor, darknessFactor, nightVision;
	uniform float far, near;
	uniform float frameTimeCounter;
	uniform float rainStrength;
	uniform float rainStrengthS;

	#if defined OVERWORLD && defined STARS
	uniform float rainStrengthShiningStars;
	#endif

	uniform float screenBrightness;
	uniform float viewWidth, viewHeight;
	uniform float eyeAltitude;

	uniform ivec2 eyeBrightnessSmooth;

	uniform vec3 moonPosition;
	uniform vec3 cameraPosition, previousCameraPosition;
	uniform vec3 skyColor;
	uniform vec3 fogColor;

	uniform mat4 gbufferProjection, gbufferPreviousProjection, gbufferProjectionInverse;
	uniform mat4 gbufferModelView, gbufferPreviousModelView, gbufferModelViewInverse;
	uniform mat4 shadowProjection;
	uniform mat4 shadowModelView;

	uniform sampler2D texture;
	uniform sampler2D gaux2;
	uniform sampler2D depthtex1;
	uniform sampler2D depthtex2;
	uniform sampler2D noisetex;

	#if PLANET >= 1
		uniform sampler2D colortex9;
	#endif

	#ifdef NEBULA
		uniform sampler2D colortex10;
	#endif

	#ifdef GALAXY
		uniform sampler2D colortex11;
	#endif

	#ifdef ADVANCED_MATERIALS
		uniform ivec2 atlasSize;
		uniform sampler2D specular;
		uniform sampler2D normals;

		#ifdef REFLECTION_RAIN
			uniform float wetness;
		#endif
	#endif

	#ifdef ENABLE_DARKNESS_EFFECT
		#if MC_VERSION >= 11900
			uniform float darknessLightFactor;
		#endif
	#endif

	//Common Variables//

	float eBS = eyeBrightnessSmooth.y / 240.0;
	float sunVisibility  = clamp00125(dot( sunVec,upVec) + 0.0625) * 8.0;
	float moonVisibility = clamp00125(dot( -sunVec,upVec) + 0.0625) * 8.0;
	float screenBrightness2 = clamp01(screenBrightness);

	float smoothness = 0.0;

	#ifdef ADVANCED_MATERIALS
		vec2 dcdx = dFdx(texCoord);
		vec2 dcdy = dFdy(texCoord);
	#endif

	#ifdef OVERWORLD
		vec3 lightVec = sunVec * ((timeAngle < 0.5325 || timeAngle > 0.9675) ? 1.0 : -1.0);
	#else
		vec3 lightVec = sunVec;
	#endif

	//Common Functions//
	float GetLuminance(vec3 color){
		return dot(color,vec3(0.299, 0.587, 0.114));
	}

	float GetNoise(vec2 pos){
	return fract(sin(dot(pos,vec2(12.9898,4.1414)))*43758.5453);
	}

	#include "/lib/surface/water.glsl"

	float WaterOp(float alpha, float difOP, float fresnel, float lViewPos) {

	float waterFogDistance = 1.0 - min(difOP / WATER_FOG_DENSITY, 0.25);
	waterFogDistance *= waterFogDistance;
	alpha = mix(0.97, alpha, min(waterFogDistance, 1.0 - fresnel));

	alpha = max(min(sqrt(lViewPos) * 0.075, 0.9), alpha);

	alpha = min(alpha, 1.0 - nightVision * 0.2);

	return alpha;
	}

	//Includes//

	#include "/lib/atmospherics/lunar.glsl"
	#include "/lib/atmospherics/skyimage.glsl"
	#include "/lib/color/blocklightColor.glsl"
	#include "/lib/color/dimensionColor.glsl"
	#include "/lib/color/skyColor.glsl"
	#include "/lib/color/specularColor.glsl"
	#include "/lib/color/waterColor.glsl"
	#include "/lib/util/dither.glsl"
	#include "/lib/atmospherics/waterFog.glsl"
	#include "/lib/util/spaceConversion.glsl"

	#ifdef OVERWORLD

		#ifdef AURORA
			#include "/lib/atmospherics/aurora.glsl"
		#endif

		#if REALISTIC_CLOUDS == 1
			#include "/lib/atmospherics/ovclouds.glsl"
		#endif

		#ifdef SHININGSTARS
			#include "/lib/atmospherics/shiningstars.glsl"
		#endif

		#ifdef STARS
			#include "/lib/atmospherics/stars.glsl"
		#endif

		#ifdef SHOOTING_STARS
			#include "/lib/atmospherics/shootingstars.glsl"
		#endif

		#include "/lib/atmospherics/sky.glsl"

	#endif

	#if defined WATER_CAUSTICS && defined OVERWORLD
		#include "/lib/lighting/caustics.glsl"
	#endif

	#include "/lib/atmospherics/fog.glsl"
	#include "/lib/lighting/forwardLighting.glsl"
	#include "/lib/surface/ggx.glsl"

	#ifndef KEEP_AA
	#include "/lib/reflections/raytracenokeepaa.glsl"
	#else
	#include "/lib/reflections/raytracekeepaa.glsl"
	#endif

	#include "/lib/reflections/simpleReflections.glsl"

	#if AA > 1
	#include "/lib/util/jitter.glsl"
	#endif

	#ifdef ADVANCED_MATERIALS
		#include "/lib/reflections/complexFresnel.glsl"
		#include "/lib/surface/directionalLightmap.glsl"
		#include "/lib/surface/materialGbuffers.glsl"
		#include "/lib/surface/parallax.glsl"

		#ifdef REFLECTION_RAIN
		#include "/lib/reflections/rainPuddles.glsl"
		#endif
	#endif

	#ifdef SHOW_DARK_ZONES
		#include "/lib/lighting/showdarkzones.glsl"
	#endif

	//Program//
	void main() {
		vec4 albedoT = texture2D(texture, texCoord);
		if (albedoT.a == 0.0) discard;
    	vec4 albedo = albedoT * vec4(color.rgb, 1.0);

		vec3 newNormal = normal;
		float f0 = 0.0;
		vec3 vlAlbedo = vec3(1.0);
		vec3 worldPos = vec3(0.0);
		vec4 cloud=vec4(0.0);

		#ifdef ADVANCED_MATERIALS
			vec2 newCoord = vTexCoord.st * vTexCoordAM.pq + vTexCoordAM.st;
			float surfaceDepth = 1.0;
			float parallaxFade = clamp01((dist - PARALLAX_DISTANCE) / 32.0);
			float skipAdvMat = float(mat > 0.98 && mat < 1.02);

			#ifdef PARALLAX
				if(skipAdvMat < 0.5) {
					newCoord = GetParallaxCoord(texCoord, parallaxFade, surfaceDepth);
					albedo = textureGrad(texture, newCoord, dcdx, dcdy) * vec4(color.rgb, 1.0);
				}
			#endif
		#endif

		vec2 lightmap = clampVec2_01(lmCoord);

		float skyRefFactor = 0.0;

		#if SKY_REFLECT_DARK_AREA == 1
			float lexSkyReflect = 0.99;
		#elif SKY_REFLECT_DARK_AREA == 2
			float lexSkyReflect = 0.88;
		#elif SKY_REFLECT_DARK_AREA == 3
			float lexSkyReflect = 0.85;
		#elif SKY_REFLECT_DARK_AREA == 4
			float lexSkyReflect = 0.80;
		#elif SKY_REFLECT_DARK_AREA == 5
			float lexSkyReflect = 0.50;
		#elif SKY_REFLECT_DARK_AREA == 6
			float lexSkyReflect = 0.0;
		#endif

		if (lightmap.y > lexSkyReflect) skyRefFactor = 1.0;

		if (albedo.a > 0.00001) {

			float water       = float(mat > 0.98 && mat < 1.02);
			float translucent = float(mat > 1.98 && mat < 2.02);
			float tintedGlass = float(mat > 2.98 && mat < 3.02);
			float ice      	  = float(mat > 3.98 && mat < 4.02);
			float netherportal= float(mat > 4.98 && mat < 5.02);

			float metalness      = 0.0;
			float emission       = 0.0;
			float subsurface     = ((translucent + ice) * 0.5) + water;
			vec3 baseReflectance = vec3(0.04);

			#ifndef REFLECTION_TRANSLUCENT
				translucent = 0.0;
				tintedGlass = 0.0;
			#endif

			vec3 screenPos = vec3(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z);

			#if AA > 1
				vec3 viewPos = ScreenToView(vec3(TAAJitter(screenPos.xy, -0.5), screenPos.z));
			#else
				vec3 viewPos = ScreenToView(screenPos);
			#endif

			worldPos = ViewToWorld(viewPos);

			float lViewPos = length(viewPos.xyz);

			vec3 nViewPos = normalize(viewPos.xyz);

			float NdotU = dot(nViewPos, upVec);

			#if WATER_MODE > 0
				float dither = InterleavedGradientNoise();
			#else
				float dither = Bayer64(gl_FragCoord.xy);
					  dither = animateDither(dither);
			#endif

			vec3 normalMap = vec3(0.0, 0.0, 1.0);

			mat3 tbnMatrix = mat3  (tangent.x, binormal.x, normal.x,
									tangent.y, binormal.y, normal.y,
									tangent.z, binormal.z, normal.z);

			#if WATER_NORMALS == 1 || WATER_NORMALS == 2
				if (water > 0.5) {
					normalMap = GetWaterNormal(worldPos, viewPos, viewVector);
					newNormal = clampVec3Inv_11(normalize(normalMap * tbnMatrix));
					float VdotN = dot(nViewPos, normalize(normal));
					if (VdotN > 0.0) newNormal = -newNormal;
				}
			#endif

			#ifdef ADVANCED_MATERIALS
				float porosity = 0.5, ao = 1.0, skyOcclusion = 0.0;
				if (water < 0.5) {
					GetMaterials(smoothness, metalness, f0, emission, subsurface, porosity, ao, normalMap, newCoord, dcdx, dcdy);

					if ((normalMap.x > -0.999 || normalMap.y > -0.999) && viewVector == viewVector)
					newNormal = clampVec3Inv_11(normalize(normalMap * tbnMatrix));

				}
			#endif

			/*////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////NETHER_PORTAL//////////////////////////////////////////////////////
			////////////////////////////////////////////////////////////////////////////////////////*/
			#if NEW_NETHER_PORTAL > 0
				#include "/lib/others/netherPortal.glsl"
			#endif
			/*////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////NETHER_PORTAL//////////////////////////////////////////////////////
			////////////////////////////////////////////////////////////////////////////////////////*/

			if (water < 0.5) albedo.rgb = pow(albedo.rgb, vec3(2.2));

			float fresnel = clamp01(1.0 + dot(newNormal, nViewPos));
			float fresnelWR = pow(clamp01(1.0 + dot(newNormal, nViewPos)),2.0);
			float fresnelWR2=pow2(fresnelWR);
			float fresnel2 = pow2(fresnel);
			float fresnel4 = pow2(fresnel2);

			float lViewPosOP = 0.0;
			float difOP = 0.0;
			vec3 colorTer = vec3(0.0);

			if (water > 0.5) {

			#include "/lib/reflections/waterReflections.glsl"

			}

			#ifdef WHITE_WORLD
				#ifdef WATERW
					albedo.rgb = vec3(0.5);
				#endif
			#endif

			#ifdef BLACK_WORLD
				#ifdef WATERW
					albedo.rgb = vec3(0.0);
				#endif
			#endif

			if (water < 0.5) vlAlbedo = mix(vec3(1.0), albedo.rgb, sqrt1(albedo.a)) * (1.0 - pow(albedo.a, 64.0)) - vec3(0.002);
			else vlAlbedo = vec3(1.0, 1.0, 1.0);

			float NoL = clamp01(dot(newNormal, lightVec) * 1.01 - 0.01);
			float NoU = clampInv11(dot(newNormal, upVec));
			float NoE = clampInv11(dot(newNormal, eastVec));
			float vanillaDiffuse = (0.25 * NoU + 0.75) + (0.667 - abs(NoE)) * (1.0 - abs(NoU)) * 0.15;
			 	  vanillaDiffuse*= vanillaDiffuse;


			float parallaxShadow = 1.0;

			#ifdef ADVANCED_MATERIALS
				vec3 rawAlbedo = albedo.rgb * 0.999 + 0.001;
				albedo.rgb *= ao;

				#ifdef REFLECTION_SPECULAR
					albedo.rgb *= (1.0 - metalness * 0.45);
				#endif

				#ifdef SELF_SHADOW
					if (lightmap.y > 0.0 && NoL > 0.0 && water < 0.5) {
						parallaxShadow = GetParallaxShadow(surfaceDepth, parallaxFade, newCoord, lightVec, tbnMatrix);
						NoL *= parallaxShadow;
					}
				#endif

			#endif

			vec3 shadow = vec3(0.0);
			GetLighting(albedo.rgb, shadow, viewPos, worldPos, lightmap, color.a, NoL, vanillaDiffuse,
			parallaxShadow, emission, subsurface);

			/*/////////////////////////////////////////////
			/////Emin Water Absoption modified by me//////
			////////////Credits EminGT///////////////////
			//////////////////////////////////////////*/
			#ifdef ABSORPTION
				if (water > 0.5 && isEyeInWater == 0) {
					colorTer       =colorTer * 2.0;
					colorTer      *=colorTer;
				vec3  absorbColor    =(normalize(waterColor.rgb + vec3(0.01)) * sqrt(WATER_I)) * colorTer * 1.92;

				float absorbDist     =1.0 - clamp01(difOP / 8.0);

				vec3  waterAlbedoAbs =mix(pow2(absorbColor), pow2(colorTer), pow2(absorbDist));
					  waterAlbedoAbs*=waterAlbedoAbs * 0.9;

				float waterFogAbs    =lViewPosOP / pow(far, 0.05) * 0.015 * (1.0 - sunVisibility * 0.25) * 2.5;
					  waterFogAbs    =(1.0 - (exp(-300.0 * pow(waterFogAbs*0.125, 3.25) * eBS)));

				float fixWaterFogAbs =max(1.0 - waterFogAbs, 0.0);
					  fixWaterFogAbs*=fixWaterFogAbs;
					  fixWaterFogAbs*=fixWaterFogAbs;
					  fixWaterFogAbs*=fixWaterFogAbs;
					  fixWaterFogAbs*=1.0 - rainStrengthS * 0.7;

				float skyLightFactor =clamp01(max(lightmap.y - 0.95, 0.05) * ALBEDO_ABS_POWER);
				float absorb         =(1.0 - albedo.a) * fixWaterFogAbs * skyLightFactor;

					albedo.rgb     =mix(albedo.rgb, waterAlbedoAbs / (1.0 - WATER_ABS_COLOR), absorb);
				}
			#endif

			#ifdef ADVANCED_MATERIALS

				float puddles = 0.0;

				#if defined REFLECTION_RAIN && defined OVERWORLD
					#include "/lib/others/puddles.glsl"
				#endif
			#endif

			if (water > 0.5 || ice > 0.5 || (translucent > 0.5 && albedo.a < 0.95)){

				vec4 reflection = vec4(0.0);
				vec3 skyReflection = vec3(0.0);

				fresnel = fresnel4 * 0.95 + 0.05;
				fresnel*= max(1.0 - isEyeInWater * 0.5 * water, 0.5);
				fresnel*= 1.0 - translucent * (1.0 - albedo.a);
				fresnel*= FRESNEL;

				#ifdef REFLECTION
					reflection = SimpleReflection(viewPos, newNormal, dither);
					reflection.rgb = pow(reflection.rgb * 2.0, vec3(8.0));
				#endif

					if (ice > 0.5){
						fresnel *= fresnel4 * ICE_REFLECTION_STRENGTH;
					}

					if (reflection.a < 1.0) {

						vec3 skyRefPos = reflect(normalize(viewPos), newNormal);
						vec3 specularColor = GetSpecularColor(lightmap.y, 0.0, vec3(1.0));

						#ifdef OVERWORLD
							skyReflection = GetSkyColor(skyRefPos, true);
						#endif

						#ifdef NETHER
							skyReflection = netherCol.rgb * 0.2;
						#endif

						#ifdef END
							skyReflection = endCol.rgb * 0.1;
						#endif

						#ifdef OVERWORLD
							vec3 specular = GetSpecularHighlight(newNormal, viewPos, lightVec, 0.9, vec3(0.02), specularColor, shadow, color.a);


							vec3 gotTheSkyColor = vec3(0.0);
							if (isEyeInWater == 0) gotTheSkyColor = GetSkyColor(skyRefPos, true);
							if (isEyeInWater == 1) gotTheSkyColor = 0.1 * pow(rawWaterColorSqrt.rgb * (1.0 - blindFactor), vec3(2.0));
							skyReflection = gotTheSkyColor;

							float specularAlpha = mix(albedo.a , 1.0, fresnel) * fresnel;

							skyReflection += specular / specularAlpha;

							#include "/lib/reflections/waterReflectionStuff.glsl"

							#ifdef CLASSIC_EXPOSURE
								skyReflection *= (4.0 - 3.0 * eBS) * lightmap.y;
							#endif

							float waterSkyOcclusion = lightmap.y;

							#if REFLECTION_SKY_FALLOFF > 1
								waterSkyOcclusion = clamp(1.0 - (1.0 - waterSkyOcclusion) * REFLECTION_SKY_FALLOFF, 0.0, 1.0);
							#endif
								waterSkyOcclusion *= waterSkyOcclusion;
								skyReflection *= waterSkyOcclusion;

						#endif

								skyReflection *= clamp01(1.0 - isEyeInWater) * skyRefFactor;
					}

				reflection.rgb = max(mix(skyReflection, reflection.rgb, reflection.a), vec3(0.0));

				albedo.rgb = mix(albedo.rgb, reflection.rgb, fresnel);
				albedo.a = mix(albedo.a, 1.0, fresnel);


			}else{

			#ifdef ADVANCED_MATERIALS

					skyOcclusion = Smooth3(lightmap.y);

					#if REFLECTION_SKY_FALLOFF > 1
						skyOcclusion = clamp01(1.0 - (1.0 - skyOcclusion) * REFLECTION_SKY_FALLOFF);
					#endif

					skyOcclusion *= skyOcclusion;

					baseReflectance = mix(vec3(f0), rawAlbedo, metalness);

				#ifdef REFLECTION_SPECULAR

					vec3 fresnel3 = vec3(0.0);

					if(netherportal < 0.5){

						fresnel3 = mix(baseReflectance, vec3(1.0), fresnel);
					}
						#if MATERIAL_FORMAT == 0
							if (f0 >= 0.9 && f0 < 1.0) {
								baseReflectance = GetMetalCol(f0);
								fresnel3 = ComplexFresnel(pow(fresnel, 0.2), f0);
							}
						#endif

					float aoSquared = pow2(ao);
						shadow *= aoSquared;
						fresnel3 *= aoSquared * smoothness * smoothness;

						if (smoothness > 0.0) {
							vec4 reflection = vec4(0.0);
							vec3 skyReflection = vec3(0.0);

							float ssrMask = clamp01(length(fresnel3) * 400.0 - 1.0);
							if(ssrMask > 0.0) reflection = SimpleReflection(viewPos, newNormal, dither);
							reflection.rgb = pow(reflection.rgb * 2.0, vec3(8.0));
							reflection.a *= ssrMask;

						if (reflection.a < 1.0){

						#ifdef OVERWORLD

							vec3 skyRefPos = reflect(normalize(viewPos.xyz), newNormal);
							skyReflection = GetSkyColor(skyRefPos, true);

							#include "/lib/reflections/waterReflectionStuff.glsl"

							float vanillaDiffuse = clamp(0.25 * dot(newNormal, upVec) + 0.75, 0.5, 1.0);
							      vanillaDiffuse *= vanillaDiffuse;

							#ifdef CLASSIC_EXPOSURE
								skyReflection *= 4.0 - 3.0 * eBS * lightmap.y;
							#endif

								skyReflection = mix(vanillaDiffuse * minLightCol * ((isEyeInWater == 1) ? MINLIGHT_U_I : MINLIGHT_I),
												skyReflection, skyOcclusion);
						#endif

							#ifdef NETHER
								skyReflection = netherCol.rgb * 0.2;
							#endif

							#ifdef END
								skyReflection = endCol.rgb * 0.1;
							#endif
					}
								skyReflection *= skyRefFactor;
								reflection.rgb = max(mix(skyReflection, reflection.rgb, reflection.a), vec3(0.0));

								albedo.rgb = albedo.rgb * (1.0 - fresnel3 * (1.0 - metalness)) +
											reflection.rgb * fresnel3;
								albedo.a = mix(albedo.a, 1.0, GetLuminance(fresnel3));
				}
				#endif

				#if defined OVERWORLD || defined END
				vec3 specularColor = GetSpecularColor(lightmap.y, metalness, baseReflectance);

				albedo.rgb += GetSpecularHighlight(newNormal, viewPos, lightVec, smoothness, baseReflectance, specularColor, shadow * vanillaDiffuse, color.a);
				#endif
			#endif
		}

			if (tintedGlass > 0.5) {
				albedo.a = sqrt2(albedo.a);
			}

			#ifdef FOG
				albedo.rgb = Fog(albedo.rgb, viewPos.xyz);
			#endif

			#if defined WATER_CAUSTICS && defined OVERWORLD
				#include "/lib/lighting/causticsCall.glsl"
			#endif

			#ifdef SHOW_DARK_ZONES
				if (vanillaDiffuse > 0.99 && (mat < 0.95 || mat > 1.05) && translucent < 0.5) {
					albedo.rgb=showDarkZones(albedo.rgb);
				}
			#endif
	}

		/*DRAWBUFFERS:01*/

		#ifdef DEBUG_WATER
            gl_FragData[0]=vec4(0.5176, 0.0, 1.0, 0.75);
		#else
			gl_FragData[0] = vec4(albedo);
		#endif

		gl_FragData[1] = vec4(vlAlbedo, 1.0);

		#if MC_VERSION >= 11605

		/*DRAWBUFFERS:018*/
		gl_FragData[2] = vec4(isWater, 0.0, 0.0, 1.0);

		#endif
}

#endif
//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

	//Uniforms//
	uniform float frameTimeCounter;
	uniform vec3 cameraPosition;

	uniform mat4 gbufferModelViewInverse;

	#if AA > 1
		uniform int frameCounter;
		uniform float viewWidth,viewHeight;
	#endif

	//Attributes//
	attribute vec4 mc_Entity;
	attribute vec4 mc_midTexCoord;
	attribute vec4 at_tangent;

	//Common Functions//
	float WavingWater(vec3 worldPos){
		float fractY=fract(worldPos.y + cameraPosition.y + 0.005);

		#ifdef WAVING_WATER
			float wave=sin(TAU * (frameTimeCounter * 0.7 + worldPos.x * 0.14 + worldPos.z * 0.07))+
					   sin(TAU * (frameTimeCounter * 0.5 + worldPos.x * 0.10 + worldPos.z * 0.20));
			if(fractY > 0.01) return wave * 0.0125;
		#endif

		return 0.0;
	}

	//Includes//
	#include "/lib/util/moonrot.glsl"

	#if AA > 1
	#include "/lib/util/jitter.glsl"
	#endif

	//Program//
	void main(){

		texCoord=(gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

		lmCoord  = getLightMapCoord();

		normal  =normalize(gl_NormalMatrix * gl_Normal);
		binormal=normalize(gl_NormalMatrix * cross(at_tangent.xyz, gl_Normal.xyz) * at_tangent.w);
		tangent =normalize(gl_NormalMatrix * at_tangent.xyz);

		mat3 tbnMatrix=mat3(tangent.x,binormal.x,normal.x,
							tangent.y,binormal.y,normal.y,
							tangent.z,binormal.z,normal.z);

		viewVector=tbnMatrix * (gl_ModelViewMatrix * gl_Vertex).xyz;

		dist=length(gl_ModelViewMatrix * gl_Vertex);

		#if defined ADVANCED_MATERIALS || NEW_NETHER_PORTAL > 0
		vec2 midCoord=(gl_TextureMatrix[0] * mc_midTexCoord).st;
		vec2 texMinMidCoord=texCoord - midCoord;

		vTexCoordAM.pq=abs(texMinMidCoord) * 2;
		vTexCoordAM.st=min(texCoord, midCoord - texMinMidCoord);

		vTexCoord.xy=sign(texMinMidCoord) * 0.5 + 0.5;
		#endif

		color=gl_Color;

		if(color.a < 0.1) color.a = 1.0;

		mat= 0.0;
		isWater = 0.0;

		if (mc_Entity.x == 10300){
			mat = 1.0, isWater = 1.0;		//Water Block
		} else if (mc_Entity.x == 10303){
			mat = 2.0; 						//Stained_glass / Stained_glass_pane
		} else if (mc_Entity.x == 10304){
			mat = 3.0; 					    //Tinted_glass
		} else if (mc_Entity.x == 10302){
			mat = 4.0; 						//Ice Block
		}

		/*////////////////////////////////////////////////////////////////////////////////////////
		///////////////////////NETHER_PORTAL//////////////////////////////////////////////////////
		////////////////////////////////////////////////////////////////////////////////////////*/
		#if NEW_NETHER_PORTAL > 0
			float matEmissive = 5.0;
		#else
			float matEmissive = 2.0;
		#endif

		#ifdef OVERWORLD
			// Nether Portal
			if (mc_Entity.x == 10223){
				mat=matEmissive, color.a *= 1.0;
			}
		#endif

		#ifdef NETHER
			// Nether Portal
			if (mc_Entity.x == 10223){
				mat=matEmissive, color.a *= 1.0;
			}
		#endif

		#ifdef END
			// Nether Portal
			if (mc_Entity.x == 10223){
				mat=matEmissive, color.a *= 1.0;
			}
		#endif
		/*////////////////////////////////////////////////////////////////////////////////////////
		///////////////////////NETHER_PORTAL//////////////////////////////////////////////////////
		////////////////////////////////////////////////////////////////////////////////////////*/

		vec2 sunRotationData = getSunRotationData();
		vec3 usunvec = getUsunvec(sunRotationData);
		sunVec = getSunVec(usunvec, sunRotationData);

		moonRotMatrix=getMoonRotMatrix(usunvec);

		#if defined (OVERWORLD) && PLANET >= 1
			float planetRotz =0.0;

			#if PLANET == 1
			planetRotz = PLANET_ROTZ;
			#elif PLANET == 2
			planetRotz = PLANET_ROTZ + 45;
			#endif

			planetRotMatrix=rotmat(PLANET_ROTX, PLANET_ROTY, planetRotz);
		#endif

		#if defined (OVERWORLD) && defined NEBULA
			nebulaRotMatrix=rotmat(NEBULA_ROTX, NEBULA_ROTY, NEBULA_ROTZ);
		#endif

		#if defined (OVERWORLD) && defined GALAXY
			galaxyRotMatrix=rotmat(GALAXY_ROTX, GALAXY_ROTY, GALAXY_ROTZ);
		#endif

		upVec  =normalize(gbufferModelView[1].xyz);
		eastVec=normalize(gbufferModelView[0].xyz);

		vec4 position=gbufferModelViewInverse*gl_ModelViewMatrix*gl_Vertex;

		#ifdef WAVING_LIQUID
			float istopv = gl_MultiTexCoord0.t < mc_midTexCoord.t ? 1.0 : 0.0;
			if (mc_Entity.x == 10300) position.y += WavingWater(position.xyz);
		#endif

		gl_Position=gl_ProjectionMatrix*gbufferModelView*position;

		if (mat == 0.0) {
			gl_Position.z-=0.00001;
			lmCoord       =(lmCoord - 0.03125) * 1.06667;
		} else {
			lmCoord.y=(lmCoord.y - 0.03125) * 1.06667;
			lmCoord.x=smoothstep(0.0, 1.0, pow((lmCoord.x - 0.03125) * 0.55, 0.35));
		}

		lmCoord = clampVec2_01(lmCoord);

		#if AA > 1
			gl_Position.xy=TAAJitter(gl_Position.xy,gl_Position.w);
		#endif
	}

#endif