/*//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##     //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##     //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####      //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##       //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####      //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##     //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##     //
//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####           //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##          //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #                //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####           //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##          //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##          //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####           //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////*/

//Settings//

#include "/lib/util/fastMath.glsl"

#include "/settings/globalSettings.glsl"

//Varyings//
varying vec2 texCoord, lmCoord;
varying vec3 upVec, sunVec;
varying vec4 position;
varying vec4 color;
//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

	//Uniforms//
	#if AA > 1
	uniform int frameCounter;
	#endif

	uniform float rainStrengthS;
	uniform float nightVision;

	#if defined WEATHER && defined OVERWORLD
	uniform float rainStrengthS2;
	#endif

	uniform float screenBrightness;
	uniform float viewWidth, viewHeight;

	#if defined WEATHER_DYNAMIC_HAND_LIGHT && defined OVERWORLD
	uniform int heldItemId, heldItemId2;
	uniform int heldBlockLightValue;
	uniform int heldBlockLightValue2;
	#include "/lib/lighting/colorLighting.glsl"
	#endif

	uniform mat4 gbufferModelViewInverse;
	uniform mat4 shadowProjection;
	uniform mat4 shadowModelView;

	uniform int moonPhase;
	#define UNIFORM_MOONPHASE

	uniform ivec2 eyeBrightnessSmooth;

	uniform mat4 gbufferProjectionInverse;

	uniform sampler2D texture;
	uniform sampler2D depthtex0;

	//Common Variables//

	float eBS              =eyeBrightnessSmooth.y / 240.0;
	float sunVisibility    =clamp00125(dot( sunVec,upVec) + 0.0625) * 8.0;
	float moonVisibility   =clamp00125(dot( -sunVec,upVec) + 0.0625) * 8.0;
	float screenBrightness2=clamp01(screenBrightness);

	//Common Functions//
	void Defog(inout vec3 albedo){
		float z=texture2D(depthtex0,gl_FragCoord.xy/vec2(viewWidth,viewHeight)).r;
		if (z == 1.0) return;

		vec4 screenPos =vec4(gl_FragCoord.xy / vec2(viewWidth, viewHeight), z, 1.0);
		vec4 viewPos   =gbufferProjectionInverse * (screenPos * 2.0 - 1.0);
		     viewPos  /=viewPos.w;

		float fog        =length(viewPos) * OVERWORLD_FOG_DENSITY / 256.0;
		float clearDay   =sunVisibility * (1.0 - rainStrengthS);
		      fog       *=(0.5 * rainStrengthS + 1.0) / (3.0 * clearDay + 1.0);
		      fog        =1.0 - exp(-2.0 * pow(fog, 0.25 * clearDay + 1.25) * eBS);
		      albedo.rgb/=1.0 - fog;
	}

	//Includes//
	#include "/lib/color/lightColor.glsl"
	#include "/lib/color/blocklightColor.glsl"

	#if AA > 1
	#include "/lib/util/jitter.glsl"
	#endif

	#include "/lib/util/spaceConversion.glsl"

	//Program//
	void main(){
		#if defined NETHER || defined END
		discard;
		#endif

		vec4 albedo = texture2D(texture, texCoord.xy);
		vec2 lightmap = lmCoord;

		#if defined WEATHER && defined OVERWORLD
			 	albedo.a = texture2D(texture, texCoord).a;
				lightmap.x = Max0(lightmap.x * lightmap.y - 0.15);

			if (albedo.a > 0.0){
				vec3 screenPos = vec3(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z);

				#if AA > 1
					vec3 viewPos = ScreenToView(vec3(TAAJitter(screenPos.xy, -0.5), screenPos.z));
				#else
					vec3 viewPos = ScreenToView(screenPos);
				#endif

				vec3  worldPos          =ViewToWorld(viewPos);
				float lViewPos          =length(viewPos.xyz);
				float torchDist         =length(worldPos);
				float handTorchLightmap2=0.0;
				vec3  handLightCol      =vec3(0.1);

				#ifdef WEATHER_DYNAMIC_HAND_LIGHT
					float handLight = max(float(heldBlockLightValue), float(heldBlockLightValue2));
					float handLightFactor = clamp((handLight - 2.0 * lViewPos) * 0.04, 0.0, 0.9333);
					lightmap.x = max(lightmap.x, handLightFactor);
				#endif

				#ifdef WEATHER_DYNAMIC_HAND_LIGHT
					if (isLightHandled()){

					handTorchLightmap2=clamp01(1.0 - ((DIST_DECLINE * 2.0 - DIST_MAX_LIGHT * 2.0) / (torchDist - DIST_MAX_LIGHT * 2.0))) * MAX_LIGHT;

					#ifdef COLORED_DYNAMIC_HAND_LIGHT

						changeLightingColorByHand(handLightCol);

					#endif
				}
				#endif

				albedo.a *= 0.25 * rainStrengthS2 * length(albedo.rgb * 0.125) * float(albedo.a > 0.1);

				#if CUSTOM_RAIN_SNOW_COLORING == 1
					albedo.rgb *= (finalRainSnowCol.rgb + pow2(lightmap.x) * (blocklightCol * mix(5.0, 10.0, moonVisibility)) + ((pow2(handLightCol) * mix(3.0, 4.0, moonVisibility)) * handTorchLightmap2)) * (WEATHER_OPACITY * mix(2.0, 0.2, moonVisibility));
				#else
					albedo.rgb *= (ambientCol2 + pow2(lightmap.x) * (blocklightCol * mix(4.0, 2.0, moonVisibility)) + ((handLightCol * mix(1.0, 0.5, moonVisibility)) * handTorchLightmap2)) * WEATHER_OPACITY;
				#endif

				#if MC_VERSION <= 11500 && defined FOG
					if (gl_FragCoord.z > 0.991) Defog(albedo.rgb);
				#endif

				#if MC_VERSION < 10800
					albedo.a *= 4.0;
					albedo.rgb *= 0.525;
				#endif
			}
		#endif

		/*DRAWBUFFERS:0*/
		gl_FragData[0] = vec4(albedo);
	}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

	//Uniforms//
	#if NOUVELLE_PLUIE > 0
		uniform vec3 cameraPosition;
	#endif

	uniform mat4 gbufferModelViewInverse;
	uniform float frameTimeCounter;

	#if NOUVELLE_PLUIE > 0
		uniform float biomeisNotColdSmooth;
	#endif

	#if AA > 1
	uniform float viewWidth,viewHeight;
	uniform int frameCounter;
	#include "/lib/util/jitter.glsl"
	#endif

	//Program//
	void main(){

		position=gbufferModelViewInverse * gl_ModelViewMatrix * gl_Vertex;

		#if NOUVELLE_PLUIE > 0
			vec3 worldpos            =position.xyz + cameraPosition;
			bool istopv              =worldpos.y > cameraPosition.y + 5.0;
			float notColdSmooth = 0.0;
			float frameTimeCounter2=frameTimeCounter * 2.0;

			if  (!istopv)
				#if NOUVELLE_PLUIE == 1

					notColdSmooth = biomeisNotColdSmooth;

					position.xz        += vec2(0.2, 0.2) + pow3(sin(frameTimeCounter2)) * vec2(0.1, 0.1) * notColdSmooth;
					position.xz        -=(vec2(0.3, 0.2) + pow3(sin(frameTimeCounter2)) * vec2(0.2, 0.1)) * 0.10 * notColdSmooth;
					position.xz        -=(vec2(0.4, 0.2) + pow3(sin(frameTimeCounter2)) * vec2(0.3, 0.1)) * 0.08 * notColdSmooth;
					position.xz        -=(vec2(0.5, 0.2) + pow3(sin(frameTimeCounter2)) * vec2(0.4, 0.1)) * 0.06 * notColdSmooth;

				#elif NOUVELLE_PLUIE == 2
					notColdSmooth = biomeisNotColdSmooth;

					position.xz		   += vec2(3.5, 1.0) * notColdSmooth;
				#endif
		#endif

		texCoord=(gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

		lmCoord  = getLightMapCoord();

		upVec=normalize(gbufferModelView[1].xyz);
		vec2 sunRotationData = getSunRotationData();
		vec3 usunvec = getUsunvec(sunRotationData);
		sunVec = getSunVec(usunvec, sunRotationData);

		gl_Position=gl_ProjectionMatrix * gbufferModelView * position;

		color = gl_Color;

		#if AA > 1
			gl_Position.xy=TAAJitter(gl_Position.xy,gl_Position.w);
		#endif
	}

#endif